/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.response;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.server.core.transport.VInt;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public class RecoveryTestResponse
extends TestResponse {
    private final Collection<XidImpl> xids;

    public RecoveryTestResponse(byte version, long messageId, String cacheName, short clientIntel, HotRodOperation operation, OperationStatus status, int topologyId, AbstractTestTopologyAwareResponse topologyResponse, ByteBuf buffer) {
        super(version, messageId, cacheName, clientIntel, operation, status, topologyId, topologyResponse);
        this.xids = RecoveryTestResponse.readXids(buffer);
    }

    private static Collection<XidImpl> readXids(ByteBuf buffer) {
        int size = VInt.read((ByteBuf)buffer);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>(size);
        for (int i = 0; i < size; ++i) {
            int formatId = SignedNumeric.decode((int)VInt.read((ByteBuf)buffer));
            byte[] globalId = ExtendedByteBuf.readRangedBytes((ByteBuf)buffer);
            byte[] branchId = ExtendedByteBuf.readRangedBytes((ByteBuf)buffer);
            xids.add(XidImpl.create((int)formatId, (byte[])globalId, (byte[])branchId));
        }
        return xids;
    }

    public Collection<XidImpl> getXids() {
        return this.xids;
    }
}

