/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestCustomEvent;
import org.infinispan.server.hotrod.test.TestKeyEvent;
import org.infinispan.server.hotrod.test.TestKeyWithVersionEvent;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestException;
import org.testng.AssertJUnit;

public class EventLogListener
extends TestClientListener {
    private final ArrayBlockingQueue<TestKeyWithVersionEvent> createdEvents = new ArrayBlockingQueue(128);
    private final ArrayBlockingQueue<TestKeyWithVersionEvent> modifiedEvents = new ArrayBlockingQueue(128);
    private final ArrayBlockingQueue<TestKeyEvent> removedEvents = new ArrayBlockingQueue(128);
    private final ArrayBlockingQueue<TestCustomEvent> customEvents = new ArrayBlockingQueue(128);

    @Override
    public int queueSize(Event.Type eventType) {
        return this.queue(eventType).size();
    }

    @Override
    public Object pollEvent(Event.Type eventType) {
        try {
            return this.queue(eventType).poll(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestException();
        }
    }

    private <T> BlockingQueue<T> queue(Event.Type eventType) {
        ArrayBlockingQueue<TestResponse> eventQueue;
        switch (eventType) {
            case CACHE_ENTRY_CREATED: {
                eventQueue = this.createdEvents;
                break;
            }
            case CACHE_ENTRY_MODIFIED: {
                eventQueue = this.modifiedEvents;
                break;
            }
            case CACHE_ENTRY_REMOVED: {
                eventQueue = this.removedEvents;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected event type: " + eventType);
            }
        }
        return eventQueue;
    }

    @Override
    public void onCreated(TestKeyWithVersionEvent event) {
        this.createdEvents.add(event);
    }

    @Override
    public void onModified(TestKeyWithVersionEvent event) {
        this.modifiedEvents.add(event);
    }

    @Override
    public void onRemoved(TestKeyEvent event) {
        this.removedEvents.add(event);
    }

    @Override
    public int customQueueSize() {
        return this.customEvents.size();
    }

    @Override
    public TestCustomEvent pollCustom() {
        try {
            return this.customEvents.poll(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestException();
        }
    }

    @Override
    public void onCustom(TestCustomEvent event) {
        this.customEvents.add(event);
    }

    @Override
    public byte[] getId() {
        return new byte[]{1, 2, 3};
    }

    public void expectNoEvents(Optional<Event.Type> eventType) {
        if (eventType.isPresent()) {
            AssertJUnit.assertEquals((int)0, (int)this.queueSize(eventType.get()));
        } else {
            AssertJUnit.assertEquals((int)0, (int)this.queueSize(Event.Type.CACHE_ENTRY_CREATED));
            AssertJUnit.assertEquals((int)0, (int)this.queueSize(Event.Type.CACHE_ENTRY_MODIFIED));
            AssertJUnit.assertEquals((int)0, (int)this.queueSize(Event.Type.CACHE_ENTRY_REMOVED));
            AssertJUnit.assertEquals((int)0, (int)this.customQueueSize());
        }
    }

    public void expectOnlyRemovedEvent(Cache cache, byte[] k) {
        this.expectSingleEvent(cache, k, Event.Type.CACHE_ENTRY_REMOVED);
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_CREATED));
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_MODIFIED));
    }

    public void expectOnlyModifiedEvent(Cache cache, byte[] k) {
        this.expectSingleEvent(cache, k, Event.Type.CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_CREATED));
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_REMOVED));
    }

    public void expectOnlyCreatedEvent(Cache cache, byte[] k) {
        this.expectSingleEvent(cache, k, Event.Type.CACHE_ENTRY_CREATED);
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_MODIFIED));
        this.expectNoEvents(Optional.of(Event.Type.CACHE_ENTRY_REMOVED));
    }

    public void expectSingleEvent(Cache cache, byte[] k, Event.Type eventType) {
        this.expectEvent(cache, k, eventType);
        AssertJUnit.assertEquals((int)0, (int)this.queueSize(eventType));
    }

    public void expectEvent(Cache cache, byte[] k, Event.Type eventType) {
        Object event = this.pollEvent(eventType);
        AssertJUnit.assertNotNull((Object)event);
        if (event instanceof TestKeyWithVersionEvent) {
            TestKeyWithVersionEvent t = (TestKeyWithVersionEvent)event;
            HotRodTestingUtil.assertByteArrayEquals(k, t.key);
            AssertJUnit.assertEquals((long)this.serverDataVersion(k, cache), (long)t.dataVersion);
        } else if (event instanceof TestKeyEvent) {
            HotRodTestingUtil.assertByteArrayEquals(k, ((TestKeyEvent)event).key);
        }
    }

    public void expectUnorderedEvents(Cache cache, Collection<byte[]> keys, Event.Type eventType) {
        ArrayList assertedKeys = new ArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            Object event = this.pollEvent(eventType);
            AssertJUnit.assertNotNull((Object)event);
            int initialSize = assertedKeys.size();
            keys.forEach(key -> {
                if (event instanceof TestKeyWithVersionEvent) {
                    TestKeyWithVersionEvent t = (TestKeyWithVersionEvent)event;
                    boolean keyMatched = this.checkUnorderedKeyEvent(assertedKeys, (byte[])key, t.key);
                    if (keyMatched) {
                        AssertJUnit.assertEquals((long)this.serverDataVersion((byte[])key, cache), (long)t.dataVersion);
                    }
                } else if (event instanceof TestKeyEvent) {
                    this.checkUnorderedKeyEvent(assertedKeys, (byte[])key, ((TestKeyEvent)event).key);
                }
            });
            int finalSize = assertedKeys.size();
            AssertJUnit.assertEquals((int)(initialSize + 1), (int)finalSize);
        }
    }

    private boolean checkUnorderedKeyEvent(List<byte[]> assertedKeys, byte[] key, byte[] eventKey) {
        if (Arrays.equals(key, eventKey)) {
            AssertJUnit.assertFalse((boolean)assertedKeys.contains(key));
            assertedKeys.add(key);
            return true;
        }
        return false;
    }

    public void expectSingleCustomEvent(Cache cache, byte[] eventData) {
        TestCustomEvent event = this.pollCustom();
        AssertJUnit.assertNotNull((Object)event);
        HotRodTestingUtil.assertByteArrayEquals(eventData, event.eventData);
        int remaining = this.customQueueSize();
        AssertJUnit.assertEquals((int)0, (int)remaining);
    }

    private long serverDataVersion(byte[] k, Cache cache) {
        CacheEntry cacheEntry = cache.getAdvancedCache().withStorageMediaType().getCacheEntry((Object)k);
        Metadata metadata = cacheEntry.getMetadata();
        EntryVersion version = metadata.version();
        return ((NumericVersion)version).getVersion();
    }
}

