/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.module.TestGlobalConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodConstants;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConcurrentStartTest")
public class HotRodConcurrentStartTest
extends MultipleCacheManagersTest {
    public static final int NUMBER_OF_SERVERS = 2;
    public static final String CACHE_NAME = "hotRodConcurrentStart";

    protected void createCacheManagers() {
        for (int i = 0; i < 2; ++i) {
            GlobalConfigurationBuilder globalConfig = GlobalConfigurationBuilder.defaultClusteredBuilder();
            if (i == 0) {
                ((TestGlobalConfigurationBuilder)globalConfig.addModule(TestGlobalConfigurationBuilder.class)).cacheStartingCallback(cr -> {
                    if (cr.getCacheName().startsWith("___hotRodTopologyCache")) {
                        log.tracef("Delaying start of cache %s on %s", (Object)cr.getCacheName(), (Object)((Transport)cr.getComponent(Transport.class)).getAddress());
                        TestingUtil.sleepThread((long)1000L);
                    }
                });
            }
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalConfig, null);
            this.cacheManagers.add(cm);
            ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration(HotRodConcurrentStartTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
            cm.defineConfiguration(CACHE_NAME, cfg.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStartup(Method m) throws Exception {
        int initialPort = HotRodTestingUtil.serverPort();
        ArrayList servers = new ArrayList();
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            int i = 0;
            while (i < 2) {
                int finalI = i++;
                futures.add(this.fork(() -> {
                    HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.getCacheManagers().get(finalI), initialPort + finalI * 10);
                    servers.add(server);
                    return server;
                }));
            }
            for (Future hotRodServerFuture : futures) {
                hotRodServerFuture.get(30L, TimeUnit.SECONDS);
            }
            try (HotRodClient client = new HotRodClient(((HotRodServer)servers.get(0)).getHost(), ((HotRodServer)servers.get(0)).getPort(), CACHE_NAME, 10, HotRodConstants.VERSION_30);){
                client.assertPut(m);
            }
        }
        finally {
            servers.forEach(ServerTestingUtil::killServer);
        }
    }
}

