/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConcurrentTest")
public class HotRodConcurrentTest
extends HotRodSingleNodeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentPutRequests(Method m) throws Exception {
        int numClients = 10;
        int numOpsPerClient = 100;
        CyclicBarrier barrier = new CyclicBarrier(numClients + 1);
        ArrayList<Future> futures = new ArrayList<Future>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        try {
            for (int i = 0; i < numClients; ++i) {
                Operator operator = new Operator(barrier, m, i, numOpsPerClient);
                operators.add(operator);
                Future future = this.fork(operator);
                futures.add(future);
            }
            barrier.await();
            barrier.await();
            log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            for (Operator operator : operators) {
                operator.stop();
            }
        }
    }

    class Operator
    implements Callable<Void> {
        private final CyclicBarrier barrier;
        private final Method m;
        private final int clientId;
        private final int numOpsPerClient;
        private HotRodClient client;

        public Operator(CyclicBarrier barrier, Method m, int clientId, int numOpsPerClient) {
            this.client = new HotRodClient("127.0.0.1", HotRodConcurrentTest.this.server().getPort(), HotRodConcurrentTest.this.cacheName, 60, 20);
            this.barrier = barrier;
            this.m = m;
            this.clientId = clientId;
            this.numOpsPerClient = numOpsPerClient;
        }

        @Override
        public Void call() throws Exception {
            TestResourceTracker.testThreadStarted((String)HotRodConcurrentTest.this.getTestName());
            log.debug((Object)"Wait for all executions paths to be ready to perform calls");
            this.barrier.await();
            try {
                for (int i = 0; i < this.numOpsPerClient; ++i) {
                    HotRodConcurrentTest.this.client().assertPut(this.m, "k" + this.clientId + "-" + i + "-", "v" + this.clientId + "-" + i + "-");
                }
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
            return null;
        }

        public Future<?> stop() {
            return this.client.stop();
        }
    }
}

