/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodDistributionTest")
public class HotRodDistributionTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "hotRodDistSync";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration(HotRodDistributionTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfg.clustering().l1().disable();
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedPutWithTopologyChanges(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers(), this.cacheName(), this.currentServerTopologyId());
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), (byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), (byte)2, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v3-"));
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v4-"), (byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v4-"));
        resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v5-"), (byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        List<HotRodServer> allServers = Stream.concat(Stream.of(newServer), this.servers().stream()).collect(Collectors.toList());
        try {
            log.trace((Object)"New client started, modify key to be v6-*");
            resp = newClient.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v6-"), (byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, allServers, this.cacheName(), this.currentServerTopologyId());
            log.trace((Object)"Get key and verify that's v6-*");
            HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v6-"));
            resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v7-"), (byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, allServers, this.cacheName(), this.currentServerTopologyId());
            HotRodTestingUtil.assertSuccess(newClient.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v7-"));
        }
        catch (Throwable throwable) {
            log.trace((Object)"Stopping new server");
            HotRodTestingUtil.killClient(newClient);
            this.stopClusteredServer(newServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            log.trace((Object)"New server stopped");
            throw throwable;
        }
        log.trace((Object)"Stopping new server");
        HotRodTestingUtil.killClient(newClient);
        this.stopClusteredServer(newServer);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        log.trace((Object)"New server stopped");
        resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v8-"), (byte)3, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil.assertSuccess(client1.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v8-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSize(Method m) {
        String newCacheName = "dist-size";
        this.startCaches(newCacheName);
        List<HotRodClient> newClients = this.createClients(newCacheName);
        try {
            TestSizeResponse sizeStart = newClients.get(0).size();
            HotRodTestingUtil.assertStatus(sizeStart, OperationStatus.Success);
            AssertJUnit.assertEquals((long)0L, (long)sizeStart.size);
            for (int i = 0; i < 20; ++i) {
                newClients.get(1).assertPut(m, "k-" + i, "v-" + i);
            }
            TestSizeResponse sizeEnd = newClients.get(1).size();
            HotRodTestingUtil.assertStatus(sizeEnd, OperationStatus.Success);
            AssertJUnit.assertEquals((long)20L, (long)sizeEnd.size);
        }
        finally {
            newClients.forEach(HotRodTestingUtil::killClient);
        }
    }
}

