/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodNoDefaultCacheTest")
public class HotRodNoDefaultCacheTest
extends SingleCacheManagerTest {
    private HotRodServer server;
    private HotRodClient client;

    public EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)null);
        return cm;
    }

    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
        this.server = HotRodTestingUtil.startHotRodServer(this.cacheManager, (String)null);
        this.client = new HotRodClient("127.0.0.1", this.server.getPort(), "", 60, HotRodVersion.HOTROD_21.getVersion());
    }

    protected void teardown() {
        log.debug((Object)"Killing Hot Rod client and server");
        HotRodTestingUtil.killClient(this.client);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.server);
        super.teardown();
    }

    public void testNoDefault() {
        TestResponse response = this.client.get("k1");
        AssertJUnit.assertTrue((boolean)(response instanceof TestErrorResponse));
        TestErrorResponse error = (TestErrorResponse)response;
        AssertJUnit.assertEquals((String)"org.infinispan.server.hotrod.CacheNotFoundException: Default cache requested but not configured", (String)error.msg);
    }
}

