/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSingleClusteredNonLoopbackTest")
public class HotRodSingleClusteredNonLoopbackTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer;
    private HotRodClient hotRodClient;
    private final String cacheName = "HotRodCache";

    protected void createCacheManagers() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManagers.add(cm);
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration(HotRodSingleClusteredNonLoopbackTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        cm.defineConfiguration("HotRodCache", builder.build());
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        List<NetworkInterface> nonLoopInterfaces = HotRodTestingUtil.findNetworkInterfaces(false);
        SkipTestNG.skipIf((boolean)nonLoopInterfaces.isEmpty(), (String)"No non-loop network interface");
        NetworkInterface iface = nonLoopInterfaces.iterator().next();
        String address = iface.getInetAddresses().nextElement().getHostAddress();
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), address, HotRodTestingUtil.serverPort(), HotRodTestingUtil.getDefaultHotRodConfiguration());
        this.hotRodClient = new HotRodClient(address, this.hotRodServer.getPort(), "HotRodCache", 60, 20);
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        log.debug((Object)"Test finished, close client, server, and cache managers");
        HotRodTestingUtil.killClient(this.hotRodClient);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
        super.destroy();
    }

    public void testNonLoopbackPutOnProtectedCache(Method m) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)this.manager(0).getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("MyInternalCache", HotRodTestingUtil.hotRodCacheConfiguration().build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED));
        TestResponse resp = this.hotRodClient.execute(160, (byte)1, "MyInternalCache", HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        Assert.assertEquals((Object)resp.status, (Object)OperationStatus.Success, (String)("Status should have been 'Success' but instead was: " + resp.status));
        this.hotRodClient.assertPut(m);
    }
}

