/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.EnumSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSingleClusteredTest")
public class HotRodSingleClusteredTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer;
    private HotRodClient hotRodClient;
    private String cacheName = "HotRodCache";

    protected void createCacheManagers() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManagers.add(cm);
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration(HotRodSingleClusteredTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        cm.defineConfiguration(this.cacheName, builder.build());
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0));
        this.hotRodClient = new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), this.cacheName, 60, 20);
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        log.debug((Object)"Test finished, close client, server, and cache managers");
        HotRodTestingUtil.killClient(this.hotRodClient);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
        super.destroy();
    }

    public void testPutGet(Method m) {
        HotRodTestingUtil.assertStatus(this.hotRodClient.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m)), OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.hotRodClient.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
    }

    public void testPutOnPrivateCache(Method m) {
        TestErrorResponse resp = (TestErrorResponse)this.hotRodClient.execute(160, (byte)1, ((HotRodServerConfiguration)this.hotRodServer.getConfiguration()).topologyCacheName(), HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        AssertJUnit.assertTrue((boolean)resp.msg.contains("Remote requests are not allowed to private caches."));
        AssertJUnit.assertEquals((String)("Status should have been 'ParseError' but instead was: " + resp.status), (Object)OperationStatus.ParseError, (Object)resp.status);
        this.hotRodClient.assertPut(m);
    }

    public void testLoopbackPutOnProtectedCache(Method m) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)this.manager(0).getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("MyInternalCache", HotRodTestingUtil.hotRodCacheConfiguration().build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED));
        TestResponse resp = this.hotRodClient.execute(160, (byte)1, "MyInternalCache", HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        AssertJUnit.assertEquals((Object)OperationStatus.Success, (Object)resp.status);
    }
}

