/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.Op;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSniFunctionalTest")
public class HotRodSniFunctionalTest
extends HotRodSingleNodeTest {
    private final String defaultServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_server_keystore.p12").getPath();
    private final String sniServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("sni_server_keystore.p12").getPath();
    private final String noAuthorizedClientsServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("no_trusted_clients_keystore.p12").getPath();
    private final String defaultTrustedClientTruststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_client_truststore.p12").getPath();
    private final String sniTrustedClientTruststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("sni_client_truststore.p12").getPath();

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        HotRodTestingUtil.killClient(this.hotRodClient);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
    }

    public void testServerAndClientWithDefaultSslContext(Method m) {
        this.hotRodServer = new HotrodServerBuilder().addSniDomain("*", this.defaultServerKeystore, "secret", this.defaultTrustedClientTruststore, "secret").build();
        this.hotRodClient = new HotrodClientBuilder(this.hotRodServer).useSslConfiguration(this.defaultServerKeystore, "secret", this.defaultTrustedClientTruststore, "secret").build();
        this.client().assertPut(m);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
    }

    public void testServerAndClientWithSniSslContext(Method m) {
        this.hotRodServer = new HotrodServerBuilder().addSniDomain("*", this.noAuthorizedClientsServerKeystore, "secret", this.sniTrustedClientTruststore, "secret").addSniDomain("sni", this.sniServerKeystore, "secret", this.sniTrustedClientTruststore, "secret").build();
        this.hotRodClient = new HotrodClientBuilder(this.hotRodServer).useSslConfiguration(this.sniServerKeystore, "secret", this.sniTrustedClientTruststore, "secret").addSniDomain(Collections.singletonList("sni")).build();
        this.client().assertPut(m);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
    }

    public void testServerWithNotMatchingDefaultAndClientWithSNI(Method m) {
        this.hotRodServer = new HotrodServerBuilder().addSniDomain("*", this.noAuthorizedClientsServerKeystore, "secret", this.sniTrustedClientTruststore, "secret").build();
        this.hotRodClient = new HotrodClientBuilder(this.hotRodServer).useSslConfiguration(this.sniServerKeystore, "secret", this.sniTrustedClientTruststore, "secret").addSniDomain(Collections.singletonList("sni")).build();
        Op op = new Op(160, 1, 20, this.client().defaultCacheName(), HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0, 0L, 1, 0);
        boolean success = false;
        try {
            success = this.client().writeOp(op, false);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)success);
    }

    @Override
    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        return null;
    }

    @Override
    protected HotRodClient connectClient() {
        return null;
    }

    class HotrodServerBuilder {
        HotRodServerConfigurationBuilder builder = (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().proxyHost("127.0.0.1").proxyPort(HotRodTestingUtil.serverPort()).idleTimeout(0);

        HotrodServerBuilder() {
        }

        public HotrodServerBuilder addSniDomain(String domain, String keystoreFileName, String keystorePassword, String truststoreFileName, String truststorePassword) {
            this.builder.ssl().enable().sniHostName(domain).keyStoreFileName(keystoreFileName).keyStorePassword(keystorePassword.toCharArray()).keyStoreType("pkcs12").trustStoreFileName(truststoreFileName).trustStorePassword(truststorePassword.toCharArray()).trustStoreType("pkcs12");
            return this;
        }

        public HotRodServer build() {
            return HotRodTestingUtil.startHotRodServer(HotRodSniFunctionalTest.this.cacheManager, HotRodTestingUtil.serverPort(), this.builder);
        }
    }

    class HotrodClientBuilder {
        private final HotRodServer hotRodServer;
        SSLContext sslContext;
        SSLEngine sslEngine;

        public HotrodClientBuilder(HotRodServer hotRodServer) {
            this.hotRodServer = hotRodServer;
        }

        public HotrodClientBuilder useSslConfiguration(String keystoreFileName, String keystorePassword, String truststoreFileName, String truststorePassword) {
            this.sslContext = new SslContextFactory().keyStoreFileName(keystoreFileName).keyStorePassword(keystorePassword.toCharArray()).keyStoreType("pkcs12").trustStoreFileName(truststoreFileName).trustStorePassword(truststorePassword.toCharArray()).trustStoreType("pkcs12").getContext();
            this.sslEngine = SslContextFactory.getEngine((SSLContext)this.sslContext, (boolean)true, (boolean)false);
            return this;
        }

        public HotrodClientBuilder addSniDomain(List<String> sniNames) {
            if (!sniNames.isEmpty()) {
                SSLParameters sslParameters = this.sslEngine.getSSLParameters();
                List<SNIServerName> hosts = sniNames.stream().map(SNIHostName::new).collect(Collectors.toList());
                sslParameters.setServerNames(hosts);
                this.sslEngine.setSSLParameters(sslParameters);
            }
            return this;
        }

        public HotRodClient build() {
            return new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), HotRodSniFunctionalTest.this.cacheName, 60, 20, this.sslEngine);
        }
    }
}

