/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.EncryptionConfiguration;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.Attribute;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.Element;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.TopologyCacheConfiguration;

@BuiltBy(value=HotRodServerConfigurationBuilder.class)
@ConfigurationFor(value=HotRodServer.class)
public class HotRodServerConfiguration
extends ProtocolServerConfiguration {
    public static final String TOPOLOGY_CACHE_NAME_PREFIX = "___hotRodTopologyCache";
    public static final AttributeDefinition<String> PROXY_HOST = AttributeDefinition.builder((Enum)Attribute.EXTERNAL_HOST, null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> PROXY_PORT = AttributeDefinition.builder((Enum)Attribute.EXTERNAL_PORT, (Object)-1).immutable().build();
    public static final AttributeDefinition<Integer> WORKER_THREADS = AttributeDefinition.builder((String)"worker-threads", (Object)160).immutable().build();
    private final TopologyCacheConfiguration topologyCache;
    private final AuthenticationConfiguration authentication;
    private final EncryptionConfiguration encryption;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HotRodServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{WORKER_THREADS, PROXY_HOST, PROXY_PORT});
    }

    HotRodServerConfiguration(AttributeSet attributes, TopologyCacheConfiguration topologyCache, SslConfiguration ssl, AuthenticationConfiguration authentication, EncryptionConfiguration encryption, IpFilterConfiguration ipRules) {
        super((Enum)Element.HOTROD_CONNECTOR, attributes, ssl, ipRules);
        this.topologyCache = topologyCache;
        this.authentication = authentication;
        this.encryption = encryption;
    }

    public String proxyHost() {
        return (String)this.attributes.attribute(PROXY_HOST).get();
    }

    public String publicHost() {
        return (String)this.attributes.attribute(PROXY_HOST).orElse((Object)this.host());
    }

    public int proxyPort() {
        return (Integer)this.attributes.attribute(PROXY_PORT).get();
    }

    public int publicPort() {
        return (Integer)this.attributes.attribute(PROXY_PORT).orElse((Object)this.port());
    }

    public String topologyCacheName() {
        String name = this.name();
        return TOPOLOGY_CACHE_NAME_PREFIX + (name.length() > 0 ? "_" + name : name);
    }

    public long topologyLockTimeout() {
        return this.topologyCache.lockTimeout();
    }

    public long topologyReplTimeout() {
        return this.topologyCache.replicationTimeout();
    }

    public boolean topologyAwaitInitialTransfer() {
        return this.topologyCache.awaitInitialTransfer();
    }

    @Deprecated
    public boolean topologyStateTransfer() {
        return !this.topologyCache.lazyRetrieval();
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public TopologyCacheConfiguration topologyCache() {
        return this.topologyCache;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }
}

