/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.concurrent.TimeUnit;
import org.infinispan.util.KeyValuePair;

public enum TimeUnitValue {
    SECONDS(0),
    MILLISECONDS(1),
    NANOSECONDS(2),
    MICROSECONDS(3),
    MINUTES(4),
    HOURS(5),
    DAYS(6),
    DEFAULT(7),
    INFINITE(8);

    private final byte code;

    private TimeUnitValue(int code) {
        this.code = (byte)code;
    }

    public byte getCode() {
        return this.code;
    }

    public TimeUnit toTimeUnit() {
        switch (this.code) {
            case 0: {
                return TimeUnit.SECONDS;
            }
            case 1: {
                return TimeUnit.MILLISECONDS;
            }
            case 2: {
                return TimeUnit.NANOSECONDS;
            }
            case 3: {
                return TimeUnit.MICROSECONDS;
            }
            case 4: {
                return TimeUnit.MINUTES;
            }
            case 5: {
                return TimeUnit.HOURS;
            }
            case 6: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("TimeUnit not supported for: " + this.code);
    }

    public static TimeUnitValue fromTimeUnit(TimeUnit unit) {
        switch (unit) {
            case MICROSECONDS: {
                return MICROSECONDS;
            }
            case MILLISECONDS: {
                return MILLISECONDS;
            }
            case SECONDS: {
                return SECONDS;
            }
            case MINUTES: {
                return MINUTES;
            }
            case HOURS: {
                return HOURS;
            }
            case DAYS: {
                return DAYS;
            }
        }
        throw new IllegalArgumentException(unit.name());
    }

    public static TimeUnitValue decode(byte rightBits) {
        switch (rightBits) {
            case 0: {
                return SECONDS;
            }
            case 1: {
                return MILLISECONDS;
            }
            case 2: {
                return NANOSECONDS;
            }
            case 3: {
                return MICROSECONDS;
            }
            case 4: {
                return MINUTES;
            }
            case 5: {
                return HOURS;
            }
            case 6: {
                return DAYS;
            }
            case 7: {
                return DEFAULT;
            }
            case 8: {
                return INFINITE;
            }
        }
        throw new IllegalArgumentException("Unsupported byte value: " + rightBits);
    }

    public static KeyValuePair<TimeUnitValue, TimeUnitValue> decodePair(byte timeUnitValues) {
        return new KeyValuePair((Object)TimeUnitValue.decode((byte)((timeUnitValues & 0xF0) >> 4)), (Object)TimeUnitValue.decode((byte)(timeUnitValues & 0xF)));
    }

    private static byte encodeDuration(long duration, TimeUnit timeUnit) {
        return duration == 0L ? TimeUnitValue.DEFAULT.code : (duration < 0L ? TimeUnitValue.INFINITE.code : TimeUnitValue.fromTimeUnit((TimeUnit)timeUnit).code);
    }

    public static byte encodeTimeUnits(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        byte encodedLifespan = TimeUnitValue.encodeDuration(lifespan, lifespanTimeUnit);
        byte encodedMaxIdle = TimeUnitValue.encodeDuration(maxIdle, maxIdleTimeUnit);
        return (byte)(encodedLifespan << 4 | encodedMaxIdle);
    }
}

