/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.TopologyCacheConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HotRodServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<HotRodServerConfiguration, HotRodServerConfigurationBuilder>
implements Builder<HotRodServerConfiguration>,
HotRodServerChildConfigurationBuilder {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final TopologyCacheConfigurationBuilder topologyCache = new TopologyCacheConfigurationBuilder();
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());
    private static final String DEFAULT_NAME = "hotrod";

    public HotRodServerConfigurationBuilder() {
        super(11222, HotRodServerConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public HotRodServerConfigurationBuilder self() {
        return this;
    }

    @Override
    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyHost(String proxyHost) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).set((Object)proxyHost);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyPort(int proxyPort) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_PORT).set((Object)proxyPort);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyLockTimeout(long topologyLockTimeout) {
        this.topologyCache.lockTimeout(topologyLockTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyReplTimeout(long topologyReplTimeout) {
        this.topologyCache.replicationTimeout(topologyReplTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyAwaitInitialTransfer(boolean topologyAwaitInitialTransfer) {
        this.topologyCache.awaitInitialTransfer(topologyAwaitInitialTransfer);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyNetworkPrefixOverride(boolean topologyNetworkPrefixOverride) {
        this.topologyCache.networkPrefixOverride(topologyNetworkPrefixOverride);
        return this;
    }

    @Override
    @Deprecated
    public HotRodServerConfigurationBuilder topologyStateTransfer(boolean topologyStateTransfer) {
        this.topologyCache.lazyRetrieval(!topologyStateTransfer);
        return this;
    }

    public HotRodServerConfiguration create() {
        if (!this.attributes.attribute(ProtocolServerConfiguration.NAME).isModified()) {
            String socketBinding = this.socketBinding();
            this.name(DEFAULT_NAME + (String)(socketBinding == null ? "" : "-" + socketBinding));
        }
        return new HotRodServerConfiguration(this.attributes.protect(), this.topologyCache.create(), this.ssl.create(), this.authentication.create(), this.encryption.create(), this.ipFilter.create());
    }

    public HotRodServerConfigurationBuilder read(HotRodServerConfiguration template, Combine combine) {
        super.read((ProtocolServerConfiguration)template, combine);
        this.authentication.read(template.authentication(), combine);
        this.topologyCache.read(template.topologyCache(), combine);
        this.encryption.read(template.encryption(), combine);
        return this;
    }

    public void validate() {
        super.validate();
        if (this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).isNull() && this.attributes.attribute(ProtocolServerConfiguration.HOST).isNull()) {
            throw log.missingHostAddress();
        }
        this.authentication.validate();
        this.topologyCache.validate();
    }

    public HotRodServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodServerConfiguration build() {
        return this.build(true);
    }
}

