/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.util.concurrent.TimeoutException;

public class BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(BaseRequestProcessor.class, Log.class);
    protected final Channel channel;
    protected final Executor executor;
    protected final HotRodServer server;
    private final HotRodAccessLogging accessLogging;

    BaseRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        this.channel = channel;
        this.executor = executor;
        this.server = server;
        this.accessLogging = server.accessLogging();
    }

    Channel channel() {
        return this.channel;
    }

    void writeException(HotRodHeader header, Throwable cause) {
        OperationStatus status;
        if (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        String msg = cause.toString();
        if (cause instanceof InvalidMagicIdException) {
            log.exceptionReported(cause);
            status = OperationStatus.InvalidMagicOrMsgId;
        } else if (cause instanceof HotRodUnknownOperationException) {
            log.exceptionReported(cause);
            HotRodUnknownOperationException hruoe = (HotRodUnknownOperationException)cause;
            header = hruoe.toHeader();
            status = OperationStatus.UnknownOperation;
        } else if (cause instanceof UnknownVersionException) {
            log.exceptionReported(cause);
            UnknownVersionException uve = (UnknownVersionException)cause;
            header = uve.toHeader();
            status = OperationStatus.UnknownVersion;
        } else if (cause instanceof RequestParsingException) {
            if (cause instanceof CacheNotFoundException) {
                log.debug(cause.getMessage());
            } else {
                log.exceptionReported(cause);
            }
            msg = cause.getCause() == null ? cause.toString() : String.format("%s: %s", cause.getMessage(), cause.getCause().toString());
            RequestParsingException rpe = (RequestParsingException)((Object)cause);
            header = rpe.toHeader();
            status = OperationStatus.ParseError;
        } else if (cause instanceof IOException) {
            status = OperationStatus.ParseError;
        } else if (cause instanceof TimeoutException) {
            status = OperationStatus.OperationTimedOut;
        } else if (cause instanceof IllegalStateException || this.isExceptionTrace(cause)) {
            if (this.isExceptionTrace(cause)) {
                log.trace("Exception reported", cause);
            } else {
                log.exceptionReported(cause);
            }
            if (header != null) {
                status = header.encoder().errorStatus(cause);
                msg = this.createErrorMsg(cause);
            } else {
                status = OperationStatus.ServerError;
            }
        } else if (header != null) {
            if (cause instanceof MissingMembersException) {
                log.warn(cause.getMessage());
            } else {
                log.exceptionReported(cause);
            }
            status = header.encoder().errorStatus(cause);
            msg = this.createErrorMsg(cause);
        } else {
            log.exceptionReported(cause);
            status = OperationStatus.ServerError;
        }
        if (header == null) {
            header = new HotRodHeader(HotRodOperation.ERROR, 0, 0L, "", 0, 1, 0, MediaType.MATCH_ALL, MediaType.MATCH_ALL, null);
        } else {
            header.op = HotRodOperation.ERROR;
        }
        ByteBuf buf = header.encoder().errorResponse(header, this.server, this.channel, msg, status);
        int responseBytes = buf.readableBytes();
        ChannelFuture future = this.channel.writeAndFlush((Object)buf);
        if (header instanceof AccessLoggingHeader) {
            this.accessLogging.logException(future, (AccessLoggingHeader)header, cause.toString(), responseBytes);
        }
    }

    void writeSuccess(HotRodHeader header, CacheEntry<byte[], byte[]> entry) {
        if (header.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
            this.writeResponse(header, header.encoder().successResponse(header, this.server, this.channel, entry));
        } else {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
        }
    }

    void writeSuccess(HotRodHeader header) {
        this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
    }

    void writeNotExecuted(HotRodHeader header, CacheEntry<byte[], byte[]> prev) {
        if (header.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
            this.writeResponse(header, header.encoder().notExecutedResponse(header, this.server, this.channel, prev));
        } else {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.OperationNotExecuted));
        }
    }

    void writeNotExecuted(HotRodHeader header) {
        this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.OperationNotExecuted));
    }

    void writeNotExist(HotRodHeader header) {
        this.writeResponse(header, header.encoder().notExistResponse(header, this.server, this.channel));
    }

    protected void writeResponse(HotRodHeader header, ByteBuf buf) {
        int responseBytes = buf.readableBytes();
        ChannelFuture future = this.channel.writeAndFlush((Object)buf);
        if (header instanceof AccessLoggingHeader) {
            this.accessLogging.logOK(future, (AccessLoggingHeader)header, responseBytes);
        }
    }

    private String createErrorMsg(Throwable t) {
        LinkedHashSet<Throwable> causes = new LinkedHashSet<Throwable>();
        for (Throwable initial = t; initial != null && !causes.contains(initial); initial = initial.getCause()) {
            causes.add(initial);
        }
        return causes.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    private boolean isExceptionTrace(Throwable t) {
        return t instanceof MissingMembersException;
    }
}

