/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

class Events {
    Events() {
    }

    static class CustomRawEvent
    extends Event {
        protected final byte[] eventData;

        protected CustomRawEvent(byte version, long messageId, HotRodOperation op, byte[] listenerId, boolean isRetried, byte[] eventData, CompletableFuture<Void> eventFuture) {
            super(version, messageId, op, listenerId, isRetried, (byte)2, eventFuture);
            this.eventData = eventData;
        }

        public String toString() {
            return "CustomRawEvent{version=" + this.version + ", messageId=" + this.messageId + ", op=" + this.op + ", listenerId=" + Util.printArray((byte[])this.listenerId, (boolean)false) + ", isRetried=" + this.isRetried + ", event=" + Util.toStr((Object)this.eventData) + "}";
        }

        @Override
        void writeEvent(ByteBuf buf) {
            this.defaultEvent(buf);
            ExtendedByteBuf.writeRangedBytes(this.eventData, buf);
        }
    }

    static class CustomEvent
    extends Event {
        protected final byte[] eventData;

        protected CustomEvent(byte version, long messageId, HotRodOperation op, byte[] listenerId, boolean isRetried, byte[] eventData, CompletableFuture<Void> eventFuture) {
            super(version, messageId, op, listenerId, isRetried, (byte)1, eventFuture);
            this.eventData = eventData;
        }

        public String toString() {
            return "CustomEvent{version=" + this.version + ", messageId=" + this.messageId + ", op=" + this.op + ", listenerId=" + Util.printArray((byte[])this.listenerId, (boolean)false) + ", isRetried=" + this.isRetried + ", event=" + Util.toStr((Object)this.eventData) + "}";
        }

        @Override
        void writeEvent(ByteBuf buf) {
            this.defaultEvent(buf);
            ExtendedByteBuf.writeRangedBytes(this.eventData, buf);
        }
    }

    static class KeyWithVersionEvent
    extends Event {
        protected final byte[] key;
        protected final long dataVersion;

        protected KeyWithVersionEvent(byte version, long messageId, HotRodOperation op, byte[] listenerId, boolean isRetried, byte[] key, long dataVersion, CompletableFuture<Void> eventFuture) {
            super(version, messageId, op, listenerId, isRetried, (byte)0, eventFuture);
            this.key = key;
            this.dataVersion = dataVersion;
        }

        public String toString() {
            return "KeyWithVersionEvent{version=" + this.version + ", messageId=" + this.messageId + ", op=" + this.op + ", listenerId=" + Util.printArray((byte[])this.listenerId, (boolean)false) + ", isRetried=" + this.isRetried + ", key=" + Util.toStr((Object)this.key) + ", dataVersion=" + this.dataVersion + "}";
        }

        @Override
        void writeEvent(ByteBuf buf) {
            this.defaultEvent(buf);
            ExtendedByteBuf.writeRangedBytes(this.key, buf);
            buf.writeLong(this.dataVersion);
        }
    }

    static class KeyEvent
    extends Event {
        protected final byte[] key;

        protected KeyEvent(byte version, long messageId, HotRodOperation op, byte[] listenerId, boolean isRetried, byte[] key, CompletableFuture<Void> eventFuture) {
            super(version, messageId, op, listenerId, isRetried, (byte)0, eventFuture);
            this.key = key;
        }

        public String toString() {
            return "KeyEvent{version=" + this.version + ", messageId=" + this.messageId + ", op=" + this.op + ", listenerId=" + Util.printArray((byte[])this.listenerId, (boolean)false) + ", isRetried=" + this.isRetried + ", key=" + Util.toStr((Object)this.key) + "}";
        }

        @Override
        void writeEvent(ByteBuf buf) {
            this.defaultEvent(buf);
            ExtendedByteBuf.writeRangedBytes(this.key, buf);
        }
    }

    static abstract class Event {
        protected final byte version;
        protected final long messageId;
        protected final HotRodOperation op;
        protected final byte[] listenerId;
        protected final boolean isRetried;
        protected final byte marker;
        protected final CompletableFuture<Void> eventFuture;

        protected Event(byte version, long messageId, HotRodOperation op, byte[] listenerId, boolean isRetried, byte marker, CompletableFuture<Void> eventFuture) {
            this.version = version;
            this.messageId = messageId;
            this.op = op;
            this.listenerId = listenerId;
            this.isRetried = isRetried;
            this.marker = marker;
            this.eventFuture = eventFuture;
        }

        abstract void writeEvent(ByteBuf var1);

        void defaultEvent(ByteBuf buf) {
            buf.writeByte((int)this.marker);
            buf.writeByte(this.isRetried ? 1 : 0);
        }
    }
}

