/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.listener;

import io.netty.buffer.ByteBuf;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterState;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public final class ClientCounterEvent {
    private final String counterName;
    private final CounterEvent event;
    private final byte version;
    private final byte[] listenerId;

    ClientCounterEvent(byte[] listenerId, byte version, String counterName, CounterEvent event) {
        this.version = version;
        this.counterName = counterName;
        this.event = event;
        this.listenerId = listenerId;
    }

    public static CounterState decodeOldState(byte encoded) {
        switch (encoded & 3) {
            case 0: {
                return CounterState.VALID;
            }
            case 1: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 2: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    public static CounterState decodeNewState(byte encoded) {
        switch (encoded & 0xC) {
            case 0: {
                return CounterState.VALID;
            }
            case 4: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 8: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    public byte getVersion() {
        return this.version;
    }

    public void writeTo(ByteBuf buffer) {
        ExtendedByteBuf.writeString(this.counterName, buffer);
        ExtendedByteBuf.writeRangedBytes(this.listenerId, buffer);
        buffer.writeByte(this.encodeCounterStates());
        buffer.writeLong(this.event.getOldValue());
        buffer.writeLong(this.event.getNewValue());
    }

    public String toString() {
        return "ClientCounterEvent{counterName='" + this.counterName + "', event=" + this.event + ", version=" + this.version + ", listenerId=" + Util.printArray((byte[])this.listenerId) + "}";
    }

    private int encodeCounterStates() {
        int encoded = 0;
        switch (this.event.getOldState()) {
            case LOWER_BOUND_REACHED: {
                encoded = 1;
                break;
            }
            case UPPER_BOUND_REACHED: {
                encoded = 2;
                break;
            }
        }
        switch (this.event.getNewState()) {
            case LOWER_BOUND_REACHED: {
                encoded = (byte)(encoded | 4);
                break;
            }
            case UPPER_BOUND_REACHED: {
                encoded = (byte)(encoded | 8);
                break;
            }
        }
        return encoded;
    }
}

