/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.SaslUtils;
import org.infinispan.server.core.security.external.ExternalSaslServerFactory;
import org.infinispan.server.hotrod.configuration.Policy;
import org.infinispan.server.hotrod.configuration.QOP;
import org.infinispan.server.hotrod.configuration.SaslConfiguration;
import org.infinispan.server.hotrod.configuration.Strength;
import org.infinispan.server.hotrod.logging.Log;

public class SaslConfigurationBuilder
implements Builder<SaslConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(SaslConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes;
    private Map<String, String> mechProperties = new HashMap<String, String>();

    SaslConfigurationBuilder() {
        this.attributes = SaslConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SaslConfigurationBuilder serverName(String name) {
        this.attributes.attribute(SaslConfiguration.SERVER_NAME).set((Object)name);
        return this;
    }

    public String serverName() {
        return (String)this.attributes.attribute(SaslConfiguration.SERVER_NAME).get();
    }

    public SaslConfigurationBuilder addQOP(String value) {
        Attribute attribute = this.attributes.attribute(SaslConfiguration.QOP);
        List qops = (List)attribute.get();
        qops.add(QOP.fromString(value));
        attribute.set((Object)qops);
        return this;
    }

    public SaslConfigurationBuilder addStrength(String value) {
        Attribute attribute = this.attributes.attribute(SaslConfiguration.STRENGTH);
        List strengths = (List)attribute.get();
        strengths.add(Strength.fromString(value));
        attribute.set((Object)strengths);
        return this;
    }

    public SaslConfigurationBuilder addPolicy(String value) {
        Attribute attribute = this.attributes.attribute(SaslConfiguration.POLICY);
        List policies = (List)attribute.get();
        policies.add(Policy.fromString(value));
        attribute.set((Object)policies);
        return this;
    }

    public SaslConfigurationBuilder addProperty(String key, String value) {
        Attribute a = this.attributes.attribute(SaslConfiguration.SASL_PROPERTIES);
        Map map = (Map)a.get();
        map.put(key, value);
        a.set((Object)map);
        return this;
    }

    private Map<String, String> getMechProperties() {
        if (this.mechProperties.isEmpty()) {
            List strengths;
            this.mechProperties = new HashMap<String, String>();
            List qops = (List)this.attributes.attribute(SaslConfiguration.QOP).get();
            if (!qops.isEmpty()) {
                String qopsValue = qops.stream().map(QOP::toString).collect(Collectors.joining(","));
                this.mechProperties.put("javax.security.sasl.qop", qopsValue);
            }
            if (!(strengths = (List)this.attributes.attribute(SaslConfiguration.STRENGTH).get()).isEmpty()) {
                String strengthsValue = strengths.stream().map(Strength::toString).collect(Collectors.joining(","));
                this.mechProperties.put("javax.security.sasl.strength", strengthsValue);
            }
            this.mechProperties.putAll((Map)this.attributes.attribute(SaslConfiguration.SASL_PROPERTIES).get());
        }
        return this.mechProperties;
    }

    public SaslConfigurationBuilder addMechanisms(String ... mechs) {
        for (String mech : mechs) {
            this.addAllowedMech(mech);
        }
        return this;
    }

    public SaslConfigurationBuilder addAllowedMech(String mech) {
        Attribute attribute = this.attributes.attribute(SaslConfiguration.MECHANISMS);
        Set mechs = (Set)attribute.get();
        mechs.add(mech);
        attribute.set((Object)mechs);
        return this;
    }

    public boolean hasMechanisms() {
        return !((Set)this.attributes.attribute(SaslConfiguration.MECHANISMS).get()).isEmpty();
    }

    public Set<String> mechanisms() {
        return (Set)this.attributes.attribute(SaslConfiguration.MECHANISMS).get();
    }

    public void validate() {
        LinkedHashSet<String> allMechs = new LinkedHashSet<String>(Arrays.asList(ExternalSaslServerFactory.NAMES));
        for (SaslServerFactory factory : SaslUtils.getSaslServerFactories((ClassLoader)this.getClass().getClassLoader(), null, (boolean)true)) {
            allMechs.addAll(Arrays.asList(factory.getMechanismNames(this.mechProperties)));
        }
        Attribute mechanismAttr = this.attributes.attribute(SaslConfiguration.MECHANISMS);
        Set allowedMechs = (Set)mechanismAttr.get();
        if (allowedMechs.isEmpty()) {
            mechanismAttr.set(allMechs);
        } else if (!allMechs.containsAll(allowedMechs)) {
            throw log.invalidAllowedMechs(allowedMechs, allMechs);
        }
        if (this.attributes.attribute(SaslConfiguration.SERVER_NAME) == null) {
            throw log.missingServerName();
        }
    }

    public SaslConfiguration create() {
        Map<String, String> mechProperties = this.getMechProperties();
        return new SaslConfiguration(this.attributes.protect(), mechProperties);
    }

    public SaslConfigurationBuilder read(SaslConfiguration template) {
        this.attributes.read(template.attributes());
        this.mechProperties = template.mechProperties();
        return this;
    }

    SaslConfigurationBuilder addMechProperty(String key, String value) {
        this.mechProperties.put(key, value);
        return this;
    }

    void setMechProperty(Map<String, String> mechProperties) {
        this.mechProperties = mechProperties;
    }
}

