/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.server.hotrod.ServerAddress;

public class SingleHomedServerAddress
implements ServerAddress {
    private final String host;
    private final int port;

    public SingleHomedServerAddress(String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleHomedServerAddress that = (SingleHomedServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "SingleHomedServerAddress{host='" + this.host + "', port=" + this.port + "}";
    }

    @Override
    public String getHost(InetAddress localAddress) {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    static class Externalizer
    extends AbstractExternalizer<SingleHomedServerAddress> {
        Externalizer() {
        }

        public Set<Class<? extends SingleHomedServerAddress>> getTypeClasses() {
            return Collections.singleton(SingleHomedServerAddress.class);
        }

        public void writeObject(ObjectOutput output, SingleHomedServerAddress object) throws IOException {
            output.writeObject(object.host);
            output.writeShort(object.port);
        }

        public SingleHomedServerAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String host = (String)input.readObject();
            int port = input.readUnsignedShort();
            return new SingleHomedServerAddress(host, port);
        }
    }
}

