/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;

class CounterRequestProcessor
extends BaseRequestProcessor {
    private final ClientCounterManagerNotificationManager notificationManager;
    private final EmbeddedCounterManager counterManager;

    CounterRequestProcessor(Channel channel, EmbeddedCounterManager counterManager, Executor executor, HotRodServer server) {
        super(channel, executor, server);
        this.counterManager = counterManager;
        this.notificationManager = server.getClientCounterNotificationManager();
    }

    private EmbeddedCounterManager counterManager(HotRodHeader header) {
        header.cacheName = "org.infinispan.COUNTER";
        return this.counterManager;
    }

    void removeCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        this.executor.execute(() -> this.removeCounterListenerInternal(header, counterName, listenerId));
    }

    private void removeCounterListenerInternal(HotRodHeader header, String counterName, byte[] listenerId) {
        try {
            this.writeResponse(header, this.createResponseFrom(header, this.notificationManager.removeCounterListener(listenerId, counterName)));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void addCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        this.executor.execute(() -> this.addCounterListenerInternal(header, counterName, listenerId));
    }

    private void addCounterListenerInternal(HotRodHeader header, String counterName, byte[] listenerId) {
        try {
            this.writeResponse(header, this.createResponseFrom(header, this.notificationManager.addCounterListener(listenerId, header.getVersion(), counterName, this.channel, header.encoder())));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void getCounterNames(HotRodHeader header, Subject subject) {
        Collection counterNames = this.counterManager(header).getCounterNames();
        this.writeResponse(header, header.encoder().counterNamesResponse(header, this.server, this.channel, counterNames));
    }

    void counterRemove(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).removeAsync(counterName, true).whenComplete((___, throwable) -> this.voidResultHandler(header, (Throwable)throwable));
    }

    void counterCompareAndSwap(HotRodHeader header, Subject subject, String counterName, long expect, long update) {
        this.counterManager(header).getStrongCounterAsync(counterName).thenCompose(strongCounter -> strongCounter.compareAndSwap(expect, update)).whenComplete((returnValue, throwable) -> this.longResultHandler(header, (Long)returnValue, (Throwable)throwable));
    }

    void counterGet(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::value).whenComplete((value, throwable) -> this.longResultHandler(header, (Long)value, (Throwable)throwable));
    }

    void counterReset(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::reset).whenComplete((unused, throwable) -> this.voidResultHandler(header, (Throwable)throwable));
    }

    void counterAddAndGet(HotRodHeader header, Subject subject, String counterName, long value) {
        this.counterManager(header).getOrCreateAsync(counterName).thenAccept(counter -> {
            if (counter.isWeakCounter()) {
                counter.asWeakCounter().add(value).whenComplete((___, t) -> this.longResultHandler(header, 0L, (Throwable)t));
            } else {
                counter.asStrongCounter().addAndGet(value).whenComplete((rv, t) -> this.longResultHandler(header, (Long)rv, (Throwable)t));
            }
        }).exceptionally(throwable -> {
            this.checkCounterThrowable(header, (Throwable)throwable);
            return null;
        });
    }

    void counterSet(HotRodHeader header, Subject subject, String counterName, long value) {
        this.counterManager(header).getStrongCounterAsync(counterName).thenCompose(strongCounter -> strongCounter.getAndSet(value)).whenComplete((returnValue, throwable) -> this.longResultHandler(header, (Long)returnValue, (Throwable)throwable));
    }

    void getCounterConfiguration(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getConfigurationAsync(counterName).whenComplete((configuration, throwable) -> this.handleGetCounterConfiguration(header, (CounterConfiguration)configuration, (Throwable)throwable));
    }

    private void handleGetCounterConfiguration(HotRodHeader header, CounterConfiguration configuration, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            ByteBuf response = configuration == null ? this.missingCounterResponse(header) : header.encoder().counterConfigurationResponse(header, this.server, this.channel, configuration);
            this.writeResponse(header, response);
        }
    }

    void isCounterDefined(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).isDefinedAsync(counterName).whenComplete((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable));
    }

    void createCounter(HotRodHeader header, Subject subject, String counterName, CounterConfiguration configuration) {
        this.counterManager(header).defineCounterAsync(counterName, configuration).whenComplete((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable));
    }

    private ByteBuf createResponseFrom(HotRodHeader header, ListenerOperationStatus status) {
        switch (status) {
            case OK: {
                return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.OperationNotExecuted);
            }
            case OK_AND_CHANNEL_IN_USE: {
                return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success);
            }
            case COUNTER_NOT_FOUND: {
                return this.missingCounterResponse(header);
            }
        }
        throw new IllegalStateException();
    }

    private void checkCounterThrowable(HotRodHeader header, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterOutOfBoundsException) {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.NotExecutedWithPrevious));
        } else if (cause instanceof CounterNotFoundException) {
            this.writeResponse(header, this.missingCounterResponse(header));
        } else {
            this.writeException(header, cause);
        }
    }

    private ByteBuf missingCounterResponse(HotRodHeader header) {
        return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.KeyDoesNotExist);
    }

    private void booleanResultHandler(HotRodHeader header, Boolean value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            OperationStatus status = value != false ? OperationStatus.Success : OperationStatus.OperationNotExecuted;
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, status));
        }
    }

    private void longResultHandler(HotRodHeader header, Long value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().longResponse(header, this.server, this.channel, value));
        }
    }

    private void voidResultHandler(HotRodHeader header, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
        }
    }
}

