/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.server.core.transport.ExtendedByteBufJava;

public class Intrinsics {
    public static int vInt(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
    }

    public static int signedVInt(ByteBuf buf) {
        buf.markReaderIndex();
        return SignedNumeric.decode((int)ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf));
    }

    public static long vLong(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeVLong((ByteBuf)buf);
    }

    public static long long_(ByteBuf buf) {
        if (buf.readableBytes() >= 8) {
            return buf.readLong();
        }
        return 0L;
    }

    public static byte byte_(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte();
        }
        return 0;
    }

    public static int int_(ByteBuf buffer) {
        if (buffer.readableBytes() >= 4) {
            return buffer.readInt();
        }
        return 0;
    }

    public static boolean bool(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte() != 0;
        }
        return false;
    }

    public static byte[] array(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf);
    }

    public static byte[] fixedArray(ByteBuf buf, int length) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf, (int)length);
    }

    public static String string(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readString((ByteBuf)buf);
    }

    public static byte[] optionalArray(ByteBuf buf) {
        buf.markReaderIndex();
        int pos = buf.readerIndex();
        int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
        if (pos == buf.readerIndex()) {
            return null;
        }
        if ((length = SignedNumeric.decode((int)length)) < 0) {
            return null;
        }
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf, (int)length);
    }

    public static String optionalString(ByteBuf buf) {
        byte[] bytes = Intrinsics.optionalArray(buf);
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        return new String(bytes, CharsetUtil.UTF_8);
    }

    public static ByteBuf readable(ByteBuf buf, int length) {
        if (buf.readableBytes() >= length) {
            buf.readerIndex(buf.readerIndex() + length);
            return buf;
        }
        return null;
    }

    public static ByteBuf retained(ByteBuf buf, int length) {
        if (buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

