/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import java.net.SocketAddress;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=6001, max=7000)
public interface Log
extends BasicLogger {
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error detecting crashed member", id=6002)
    public void errorDetectingCrashedMember(@Cause Throwable var1);

    @Message(value="The requested operation is invalid", id=6007)
    public UnsupportedOperationException invalidOperation();

    @Message(value="Event not handled by current Hot Rod event implementation: '%s'", id=6009)
    public IllegalStateException unexpectedEvent(Event var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6010)
    @Once
    public void warnConditionalOperationNonTransactional(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6011)
    @Once
    public void warnForceReturnPreviousNonTransactional(String var1);

    @Message(value="Listener %s factory '%s' not found in server", id=6013)
    public MissingFactoryException missingCacheEventFactory(String var1, String var2);

    @Message(value="Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory", id=6014)
    public IllegalStateException illegalFilterConverterEventFactory(String var1);

    @Message(value="Operation '%s' requires authentication", id=6017)
    public SecurityException unauthorizedOperation(String var1);

    @Message(value="A host or proxyHost address has not been specified", id=6019)
    public CacheConfigurationException missingHostAddress();

    @Message(value="Cache '%s' is not transactional to execute a client transaction", id=6020)
    public IllegalStateException expectedTransactionalCache(String var1);

    @Message(value="Cache '%s' must have REPEATABLE_READ isolation level", id=6021)
    public IllegalStateException unexpectedIsolationLevel(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not wrapping custom marshaller with media type '%s' since the format is already supported by the server", id=6022)
    @Once
    public void skippingMarshallerWrapping(String var1);

    @Message(value="Error serializing script response '%s'", id=6023)
    public EncodingException errorSerializingResponse(Object var1);

    @Message(value="Invalid credentials", id=6024)
    public SecurityException authenticationException(@Cause Throwable var1);

    @Message(value="Invalid mech '%s'", id=6025)
    public IllegalArgumentException invalidMech(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Client %s keeps providing outdated topology %s", id=6026)
    public void clientNotUpdatingTopology(SocketAddress var1, int var2);
}

