/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import org.infinispan.server.hotrod.streaming.StreamingState;

public class GetStreamingState
extends StreamingState {
    private final ByteBuf value;
    private final int batchAmount;

    public GetStreamingState(byte[] key, Channel channelUsed, byte[] value, int batchAmount) {
        super(key, channelUsed);
        this.value = Unpooled.wrappedBuffer((byte[])value);
        this.batchAmount = batchAmount;
    }

    @Override
    public ByteBuf nextGet() {
        this.verifyCorrectThread();
        return this.value.readRetainedSlice(Math.min(this.value.readableBytes(), this.batchAmount));
    }

    @Override
    public boolean isGetComplete() {
        this.verifyCorrectThread();
        return !this.value.isReadable();
    }

    @Override
    public void closeGet() {
        this.verifyCorrectThread();
        this.close();
    }

    @Override
    public void close() {
        this.value.release();
    }
}

