/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.metadata.Metadata;

public abstract class StreamingState {
    private final byte[] key;
    private final Channel channelUsed;

    public StreamingState(byte[] key, Channel channelUsed) {
        this.key = key;
        this.channelUsed = channelUsed;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] valueForPut() {
        throw this.unsupportedType();
    }

    public Metadata.Builder metadataForPut() {
        throw this.unsupportedType();
    }

    public long versionForPut() {
        throw this.unsupportedType();
    }

    public void nextPut(ByteBuf buf) {
        throw this.unsupportedType();
    }

    public ByteBuf nextGet() {
        throw this.unsupportedType();
    }

    public boolean isGetComplete() {
        throw this.unsupportedType();
    }

    public void closePut() {
        throw this.unsupportedType();
    }

    public void closeGet() {
        throw this.unsupportedType();
    }

    private IllegalStateException unsupportedType() {
        return new IllegalStateException("Unsupported streaming state operation type");
    }

    protected void verifyCorrectThread() {
        if (!this.channelUsed.eventLoop().inEventLoop()) {
            throw new IllegalStateException("Streaming operation only supported in same event loop it was started!");
        }
    }

    public abstract void close();
}

