/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api._private.CounterEncodeUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.BaseDecoder;
import org.infinispan.server.hotrod.BitShift;
import org.infinispan.server.hotrod.HotRodConstants;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.Intrinsics;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.tx.ControlByte;

public class HotRodDecoder
extends BaseDecoder {
    private int state;
    private int requestBytes;
    private byte hr2x_timeUnits;
    private int hr2x_numEntries;
    private String hr2x_iterationId;
    private byte hr2x_controlByte;
    private int hr2x_bloomBits;
    private byte[] hr2x_otherParamValue;
    private byte[] hr2x_fixedArray;
    private byte[] hr2x_queryBytes;
    private byte hr2x_counterFlags;
    private long hr2x_expectValue;
    private ByteBuf hr2x_readable;
    private boolean hr2x_includeCurrentState;
    private String hr2x_taskParam;
    private String hr2x_otherParamName;
    private String hr2x_cacheName;
    private int hr2x_vInt;
    private MediaType hr2x_valueType;
    private long hr2x_initialValue;
    private int hr2x_numModifications;
    private byte[] hr2x_param;
    private String hr2x_authMech;
    private byte[] hr2x_authResponse;
    private int hr2x_otherParamsNum;
    private int hr2x_listenerInterests;
    private byte hr2x_numParams;
    private int hr2x_xidFormat;
    private String hr2x_filterFactory;
    private long hr2x_maxIdleLong;
    private HotRodOperation hr2x_operation;
    private Map<String, byte[]> hr2x_otherParams;
    private long hr2x_upperBound;
    private byte hr2x_version;
    private String hr2x_converterFactory;
    private boolean hr2x_lastPut;
    private int hr2x_int;
    private int hr2x_signedVInt;
    private boolean hr2x_supportsDuplicates;
    private MediaType hr2x_keyType;
    private String hr2x_filterConverterFactory;
    private Map<String, String> hr2x_mediaTypeParams;
    private long hr2x_versionRead;
    private int hr2x_lifespanInt;
    private String hr2x_mediaParamValue;
    private byte hr2x_intelligence;
    private long hr2x_long;
    private String hr2x_mediaParamName;
    private List<byte[]> hr2x_converterParams;
    private boolean hr2x_recoverable;
    private byte[] hr2x_bloomArray;
    private byte[] hr2x_value;
    private byte hr2x_branchLength;
    private String hr2x_optionalString;
    private byte[] hr2x_optionalArray;
    private boolean hr2x_bool;
    private byte hr2x_xidLength;
    private byte hr2x_mediaTypeDefinition;
    private Metadata.Builder hr2x_expiration;
    private List<byte[]> hr2x_filterParams;
    private int hr2x_offset;
    private ByteBuf hr2x_chunkBytes;
    private long hr2x_updateValue;
    private byte hr2x_txMarker;
    private boolean hr2x_useRawEvents;
    private int hr2x_chunkLength;
    private long hr2x_timeout;
    private String hr2x_taskName;
    private String hr2x_mediaTypeName;
    private long hr2x_lowerBound;
    private byte[] hr2x_taskParamValue;
    private ByteBuf hr2x_chunkedValue;
    private byte[] hr2x_key;
    private int hr2x_batchSize;
    private HotRodHeader hr2x_header;
    private int hr2x_scope;
    private long hr2x_lifespanLong;
    private Map<String, byte[]> hr2x_taskParams;
    private byte[] hr2x_array;
    private int hr2x_flags;
    private byte[] hr2x_listenerId;
    private byte[] hr2x_segmentMask;
    private byte hr2x_magic;
    private int hr2x_maxIdleInt;
    private boolean hr2x_onePhaseCommit;
    private long hr2x_entryVersion;
    private int hr2x_mediaTypeId;
    private boolean hr2x_includeMetadata;
    private byte hr2x_opCode;
    private Map<byte[], byte[]> hr2x_entryMap;
    private int hr2x_mediaTypeParamsNum;
    private long hr2x_messageId;
    private long hr2x_vLong;
    private List<byte[]> hr2x_filterConverterParams;
    private ByteBuf hr2x_retained;
    private int hr2x_numKeys;
    private Map<String, byte[]> hr2x_otherParamsRev;
    private MediaType hr2x_mediaType;
    private byte[] hr2x_branchId;
    private ByteBuf hr2x_retainedChunk;
    private int hr2x_intValue;
    private String hr2x_string;
    private byte hr2x_byte;
    private byte[] hr2x_transactionId;
    private MediaType hr2x_mediaTypeDescription;
    private String hr2x_counterName;
    private TransactionWrite hr2x_modification;
    private CounterConfiguration.Builder hr2x_counterConfiguration;
    private int hr2x_topologyId;
    private Set<byte[]> hr2x_keys;
    private XidImpl hr2x_xid;
    private List<TransactionWrite> hr2x_modifications;
    private final boolean accessLogging;
    private Temporal requestStart;
    private boolean deadEnd = false;

    public HotRodDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
        super(cacheManager, executor, server);
        server.accessLogging();
        this.accessLogging = HotRodAccessLogging.isEnabled();
    }

    @Override
    protected HotRodHeader getHeader() {
        if (this.accessLogging && this.hr2x_header != null) {
            return new AccessLoggingHeader(this.hr2x_header, null, this.hr2x_key != null ? this.hr2x_key : (byte[])this.hr2x_taskName, this.requestBytes, this.requestStart);
        }
        return this.hr2x_header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch1_0(buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(buf, out);
            }
            case 1: {
                return this.switch1(buf, out);
            }
            case 2: {
                return this.switch2(buf, out);
            }
            case 3: {
                return this.switch3(buf, out);
            }
            case 4: {
                return this.switch4(buf, out);
            }
            case 5: {
                return this.switch5(buf, out);
            }
            case 6: {
                return this.switch6(buf, out);
            }
            case 7: {
                return this.switch7(buf, out);
            }
            case 8: {
                return this.switch8(buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_magic = this.hr2x_byte;
                this.state = 2;
            }
            case 2: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 3;
            }
            case 3: {
                if (this.hr2x_magic != -96) {
                    this.state = 5;
                    return true;
                }
                this.deadEnd = false;
                this.state = 6;
                return true;
            }
            case 4: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", this.hr2x_header);
                }
                this.state = 63;
                return true;
            }
            case 5: {
                throw new InvalidMagicIdException("Error reading magic byte or message id: " + this.hr2x_magic);
            }
            case 6: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_messageId = this.hr2x_vLong;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_version = this.hr2x_byte;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_opCode = this.hr2x_byte;
                this.hr2x_operation = HotRodOperation.fromRequestOpCode(this.hr2x_byte);
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_cacheName = this.hr2x_string;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_flags = this.hr2x_vInt;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intelligence = this.hr2x_byte;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_topologyId = this.hr2x_vInt;
                this.state = 13;
            }
            case 13: {
                if (this.hr2x_version < HotRodConstants.VERSION_20) {
                    this.state = 15;
                    return true;
                }
                this.hr2x_txMarker = 0;
                this.state = 14;
            }
            case 14: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 17;
                    return true;
                }
                this.hr2x_keyType = this.hr2x_mediaType = null;
                this.state = 16;
                return true;
            }
            case 15: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_txMarker = this.hr2x_byte;
                this.state = 14;
                return true;
            }
            case 16: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 37;
                    return true;
                }
                this.hr2x_valueType = this.hr2x_mediaType = null;
                this.state = 36;
                return true;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 18;
            }
            case 18: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 19;
                        return true;
                    }
                    case 1: {
                        this.state = 20;
                        return true;
                    }
                    case 2: {
                        this.state = 28;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 19: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 16;
                return true;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 21;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 23;
                return true;
            }
            case 22: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 23: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 24;
            }
            case 24: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 22;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 25;
            }
            case 25: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 26;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 27;
            }
            case 27: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 24;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 29;
            }
            case 29: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 31;
                return true;
            }
            case 30: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 31: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 32;
            }
            case 32: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 30;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 33;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 34;
            }
            case 34: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 35;
            }
            case 35: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 32;
                return true;
            }
            case 36: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 56;
                    return true;
                }
                this.hr2x_otherParams = null;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType, this.hr2x_otherParams);
                this.state = 4;
                return true;
            }
            case 37: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 38;
            }
            case 38: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 39;
                        return true;
                    }
                    case 1: {
                        this.state = 40;
                        return true;
                    }
                    case 2: {
                        this.state = 48;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 39: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 36;
                return true;
            }
            case 40: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 41;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 43;
                return true;
            }
            case 42: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 36;
                return true;
            }
            case 43: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 44;
            }
            case 44: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 42;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 45;
            }
            case 45: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 46;
            }
            case 46: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 47;
            }
            case 47: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 44;
                return true;
            }
            case 48: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 49;
            }
            case 49: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 51;
                return true;
            }
            case 50: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 36;
                return true;
            }
            case 51: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 52;
            }
            case 52: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 50;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 53;
            }
            case 53: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 54;
            }
            case 54: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 55;
            }
            case 55: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 52;
                return true;
            }
            case 56: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamsNum = this.hr2x_vInt;
                this.state = 58;
                return true;
            }
            case 57: {
                this.hr2x_otherParams = this.hr2x_otherParamsRev;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType, this.hr2x_otherParams);
                this.state = 4;
                return true;
            }
            case 58: {
                this.hr2x_otherParamsRev = this.allocMap(this.hr2x_otherParamsNum);
                this.state = 59;
            }
            case 59: {
                if (this.hr2x_otherParamsNum == 0) {
                    this.state = 57;
                    return true;
                }
                --this.hr2x_otherParamsNum;
                this.state = 60;
            }
            case 60: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamName = this.hr2x_string;
                this.state = 61;
            }
            case 61: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamValue = this.hr2x_array;
                this.state = 62;
            }
            case 62: {
                this.hr2x_otherParamsRev.put(this.hr2x_otherParamName, this.hr2x_otherParamValue);
                this.state = 59;
                return true;
            }
            case 63: {
                return this.userSwitch63();
            }
        }
        return true;
    }

    private boolean switch1(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 65;
            }
            case 65: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 67;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 69;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 74;
                return true;
            }
            case 66: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 78;
                return true;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 68;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 66;
                return true;
            }
            case 69: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 70;
            }
            case 70: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 72;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 71;
            }
            case 71: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 73;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 66;
                return true;
            }
            case 72: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 71;
                return true;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 66;
                return true;
            }
            case 74: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 76;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 75;
            }
            case 75: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 77;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 66;
                return true;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 75;
                return true;
            }
            case 77: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 66;
                return true;
            }
            case 78: {
                this.cacheProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 79: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 80;
            }
            case 80: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 82;
            }
            case 82: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 84;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 86;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 91;
                return true;
            }
            case 83: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 95;
                return true;
            }
            case 84: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 85;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 83;
                return true;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 87;
            }
            case 87: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 89;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 88;
            }
            case 88: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 90;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 83;
                return true;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 88;
                return true;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 83;
                return true;
            }
            case 91: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 93;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 92;
            }
            case 92: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 94;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 83;
                return true;
            }
            case 93: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 92;
                return true;
            }
            case 94: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 83;
                return true;
            }
            case 95: {
                this.cacheProcessor.putIfAbsent(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 97;
            }
            case 97: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 99;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 101;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 106;
                return true;
            }
            case 98: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 110;
                return true;
            }
            case 99: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 100;
            }
            case 100: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 98;
                return true;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 102;
            }
            case 102: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 104;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 103;
            }
            case 103: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 105;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 98;
                return true;
            }
            case 104: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 103;
                return true;
            }
            case 105: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 98;
                return true;
            }
            case 106: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 108;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 107;
            }
            case 107: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 109;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 98;
                return true;
            }
            case 108: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 107;
                return true;
            }
            case 109: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 98;
                return true;
            }
            case 110: {
                this.cacheProcessor.replace(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 111: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 112;
            }
            case 112: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 114;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 116;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 121;
                return true;
            }
            case 113: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 125;
                return true;
            }
            case 114: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 115;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 113;
                return true;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 117;
            }
            case 117: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 119;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 118;
            }
            case 118: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 120;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 113;
                return true;
            }
            case 119: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 118;
                return true;
            }
            case 120: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 113;
                return true;
            }
            case 121: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 123;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 122;
            }
            case 122: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 124;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 113;
                return true;
            }
            case 123: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 122;
                return true;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 113;
                return true;
            }
            case 125: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 126;
            }
            case 126: {
                this.cacheProcessor.replaceIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 127: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 128;
            }
        }
        return true;
    }

    private boolean switch2(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 128: {
                this.cacheProcessor.remove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 129: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 130;
            }
            case 130: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 131;
            }
            case 131: {
                this.cacheProcessor.removeIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 132: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 133;
            }
            case 133: {
                this.cacheProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 134: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 135;
            }
            case 135: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 136: {
                this.cacheProcessor.clear(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 137: {
                this.cacheProcessor.stats(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 138: {
                this.cacheProcessor.ping(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 139: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 140;
            }
            case 140: {
                this.cacheProcessor.bulkGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_numKeys);
                this.state = 0;
                return true;
            }
            case 141: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 142;
            }
            case 142: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, 0);
                this.state = 0;
                return true;
            }
            case 143: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_scope = this.hr2x_vInt;
                this.state = 144;
            }
            case 144: {
                this.cacheProcessor.bulkGetKeys(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_scope);
                this.state = 0;
                return true;
            }
            case 145: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_queryBytes = this.hr2x_array;
                this.state = 146;
            }
            case 146: {
                this.cacheProcessor.query(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_queryBytes);
                this.state = 0;
                return true;
            }
            case 147: {
                this.auth.authMechList(this.hr2x_header);
                this.state = 0;
                return true;
            }
            case 148: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authMech = this.hr2x_string;
                this.state = 149;
            }
            case 149: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authResponse = this.hr2x_array;
                this.state = 150;
            }
            case 150: {
                this.auth.auth(this.hr2x_header, this.hr2x_authMech, this.hr2x_authResponse);
                this.state = 0;
                return true;
            }
            case 151: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 152;
            }
            case 152: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeCurrentState = this.hr2x_bool;
                this.state = 153;
            }
            case 153: {
                if (this.hr2x_version >= HotRodConstants.VERSION_26) {
                    this.state = 155;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_21) {
                    this.state = 171;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 186;
                return true;
            }
            case 154: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, this.hr2x_includeCurrentState, this.hr2x_filterFactory, this.hr2x_filterParams, this.hr2x_converterFactory, this.hr2x_converterParams, this.hr2x_useRawEvents, this.hr2x_listenerInterests, 0);
                this.state = 0;
                return true;
            }
            case 155: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 156;
            }
            case 156: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 158;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 157;
            }
            case 157: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 163;
                return true;
            }
            case 158: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 159;
            }
            case 159: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 160;
            }
            case 160: {
                if (this.hr2x_numParams == 0) {
                    this.state = 157;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 161;
            }
            case 161: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 162;
            }
            case 162: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 160;
                return true;
            }
            case 163: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 165;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 164;
            }
            case 164: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 170;
                return true;
            }
            case 165: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 166;
            }
            case 166: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 167;
            }
            case 167: {
                if (this.hr2x_numParams == 0) {
                    this.state = 164;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 168;
            }
            case 168: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 169;
            }
            case 169: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 167;
                return true;
            }
            case 170: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerInterests = this.hr2x_vInt;
                this.state = 154;
                return true;
            }
            case 171: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 172;
            }
            case 172: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 174;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 173;
            }
            case 173: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 179;
                return true;
            }
            case 174: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 175;
            }
            case 175: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 176;
            }
            case 176: {
                if (this.hr2x_numParams == 0) {
                    this.state = 173;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 177;
            }
            case 177: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 178;
            }
            case 178: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 176;
                return true;
            }
            case 179: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 181;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 180;
            }
            case 180: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 154;
                return true;
            }
            case 181: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 182;
            }
            case 182: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 183;
            }
            case 183: {
                if (this.hr2x_numParams == 0) {
                    this.state = 180;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 184;
            }
            case 184: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 185;
            }
            case 185: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 183;
                return true;
            }
            case 186: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 188;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 187;
            }
            case 187: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 193;
                return true;
            }
            case 188: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 189;
            }
            case 189: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 190;
            }
            case 190: {
                if (this.hr2x_numParams == 0) {
                    this.state = 187;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 191;
            }
            case 191: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 192;
            }
        }
        return true;
    }

    private boolean switch3(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 192: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 190;
                return true;
            }
            case 193: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 194;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 154;
                return true;
            }
            case 194: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 195;
            }
            case 195: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 196;
            }
            case 196: {
                if (this.hr2x_numParams == 0) {
                    this.state = 154;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 197;
            }
            case 197: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 198;
            }
            case 198: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 196;
                return true;
            }
            case 199: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 200;
            }
            case 200: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_bloomBits = this.hr2x_vInt;
                this.state = 201;
            }
            case 201: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, false, null, null, null, null, false, 14, this.hr2x_bloomBits);
                this.state = 0;
                return true;
            }
            case 202: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 203;
            }
            case 203: {
                this.cacheProcessor.removeClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 204: {
                this.cacheProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 205: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskName = this.hr2x_string;
                this.state = 206;
            }
            case 206: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 208;
                return true;
            }
            case 207: {
                this.taskProcessor.exec(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_taskName, this.hr2x_taskParams);
                this.state = 0;
                return true;
            }
            case 208: {
                this.hr2x_taskParams = this.allocMap(this.hr2x_numParams);
                this.state = 209;
            }
            case 209: {
                if (this.hr2x_numParams == 0) {
                    this.state = 207;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 210;
            }
            case 210: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParam = this.hr2x_string;
                this.state = 211;
            }
            case 211: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParamValue = this.hr2x_array;
                this.state = 212;
            }
            case 212: {
                this.hr2x_taskParams.put(this.hr2x_taskParam, this.hr2x_taskParamValue);
                this.state = 209;
                return true;
            }
            case 213: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 215;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 217;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 222;
                return true;
            }
            case 214: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numEntries = this.hr2x_vInt;
                this.state = 227;
                return true;
            }
            case 215: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 216;
            }
            case 216: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 214;
                return true;
            }
            case 217: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 218;
            }
            case 218: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 220;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 219;
            }
            case 219: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 221;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 214;
                return true;
            }
            case 220: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 219;
                return true;
            }
            case 221: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 214;
                return true;
            }
            case 222: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 224;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 223;
            }
            case 223: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 225;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 214;
                return true;
            }
            case 224: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 223;
                return true;
            }
            case 225: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 214;
                return true;
            }
            case 226: {
                this.cacheProcessor.putAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_entryMap, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 227: {
                this.hr2x_entryMap = this.allocMap(this.hr2x_numEntries);
                this.state = 228;
            }
            case 228: {
                if (this.hr2x_numEntries == 0) {
                    this.state = 226;
                    return true;
                }
                --this.hr2x_numEntries;
                this.state = 229;
            }
            case 229: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 230;
            }
            case 230: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 231;
            }
            case 231: {
                this.hr2x_entryMap.put(this.hr2x_key, this.hr2x_value);
                this.state = 228;
                return true;
            }
            case 232: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 234;
                return true;
            }
            case 233: {
                this.cacheProcessor.getAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_keys);
                this.state = 0;
                return true;
            }
            case 234: {
                this.hr2x_keys = this.allocSet(this.hr2x_numKeys);
                this.state = 235;
            }
            case 235: {
                if (this.hr2x_numKeys == 0) {
                    this.state = 233;
                    return true;
                }
                --this.hr2x_numKeys;
                this.state = 236;
            }
            case 236: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 237;
            }
            case 237: {
                this.hr2x_keys.add(this.hr2x_key);
                this.state = 235;
                return true;
            }
            case 238: {
                int pos = buf.readerIndex();
                this.hr2x_optionalArray = Intrinsics.optionalArray(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_segmentMask = this.hr2x_optionalArray;
                this.state = 239;
            }
            case 239: {
                int pos = buf.readerIndex();
                this.hr2x_optionalString = Intrinsics.optionalString(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterConverterFactory = this.hr2x_optionalString;
                this.state = 240;
            }
            case 240: {
                if (this.hr2x_filterConverterFactory != null) {
                    this.state = 242;
                    return true;
                }
                this.hr2x_filterConverterParams = null;
                this.state = 241;
            }
            case 241: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_batchSize = this.hr2x_vInt;
                this.state = 247;
                return true;
            }
            case 242: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 243;
            }
            case 243: {
                this.hr2x_filterConverterParams = this.allocList(this.hr2x_numParams);
                this.state = 244;
            }
            case 244: {
                if (this.hr2x_numParams == 0) {
                    this.state = 241;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 245;
            }
            case 245: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 246;
            }
            case 246: {
                this.hr2x_filterConverterParams.add(this.hr2x_param);
                this.state = 244;
                return true;
            }
            case 247: {
                if (this.hr2x_version >= HotRodConstants.VERSION_24) {
                    this.state = 249;
                    return true;
                }
                this.hr2x_includeMetadata = false;
                this.state = 248;
            }
            case 248: {
                this.cacheProcessor.iterationStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_segmentMask, this.hr2x_filterConverterFactory, this.hr2x_filterConverterParams, this.hr2x_batchSize, this.hr2x_includeMetadata);
                this.state = 0;
                return true;
            }
            case 249: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeMetadata = this.hr2x_bool;
                this.state = 248;
                return true;
            }
            case 250: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 251;
            }
            case 251: {
                this.cacheProcessor.iterationNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 252: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 253;
            }
            case 253: {
                this.cacheProcessor.iterationEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 254: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 255;
            }
            case 255: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_offset = this.hr2x_vInt;
                this.state = 256;
            }
        }
        return true;
    }

    private boolean switch4(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 256: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_offset);
                this.state = 0;
                return true;
            }
            case 257: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 258;
            }
            case 258: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 260;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 262;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 267;
                return true;
            }
            case 259: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 271;
                return true;
            }
            case 260: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 261;
            }
            case 261: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 259;
                return true;
            }
            case 262: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 263;
            }
            case 263: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 265;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 264;
            }
            case 264: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 266;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 259;
                return true;
            }
            case 265: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 264;
                return true;
            }
            case 266: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 259;
                return true;
            }
            case 267: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 269;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 268;
            }
            case 268: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 270;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 259;
                return true;
            }
            case 269: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 268;
                return true;
            }
            case 270: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 259;
                return true;
            }
            case 271: {
                this.hr2x_chunkedValue = this.cacheProcessor.channel().alloc().buffer();
                this.hr2x_chunkLength = 1;
                this.state = 273;
                return true;
            }
            case 272: {
                this.cacheProcessor.putStream(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkedValue, this.hr2x_entryVersion, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 273: {
                if (this.hr2x_chunkLength == 0) {
                    this.state = 272;
                    return true;
                }
                --this.hr2x_chunkLength;
                this.state = 274;
            }
            case 274: {
                if (this.hr2x_version >= HotRodConstants.VERSION_41) {
                    this.state = 275;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 278;
                return true;
            }
            case 275: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 276;
            }
            case 276: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 277;
                    return true;
                }
                throw new RequestParsingException("Retained chunk requires a chunk length greater than 0", this.hr2x_version, this.hr2x_messageId);
            }
            case 277: {
                int pos = buf.readerIndex();
                this.hr2x_retained = Intrinsics.retained(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_retainedChunk = this.hr2x_retained;
                this.state = 273;
                return true;
            }
            case 278: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 280;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0, 0);
                this.state = 279;
            }
            case 279: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 273;
                return true;
            }
            case 280: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 279;
                return true;
            }
            case 281: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_bloomArray = this.hr2x_array;
                this.state = 282;
            }
            case 282: {
                this.cacheProcessor.updateBloomFilter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_bloomArray);
                this.state = 0;
                return true;
            }
            case 283: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 284;
            }
            case 284: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 286;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 288;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 293;
                return true;
            }
            case 285: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 297;
                return true;
            }
            case 286: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 287;
            }
            case 287: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 285;
                return true;
            }
            case 288: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 289;
            }
            case 289: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 291;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 290;
            }
            case 290: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 292;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 285;
                return true;
            }
            case 291: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 290;
                return true;
            }
            case 292: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 285;
                return true;
            }
            case 293: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 295;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 294;
            }
            case 294: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 296;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 285;
                return true;
            }
            case 295: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 294;
                return true;
            }
            case 296: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 285;
                return true;
            }
            case 297: {
                this.cacheProcessor.putStreamStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_expiration, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 298: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 299;
            }
            case 299: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lastPut = this.hr2x_bool;
                this.state = 300;
            }
            case 300: {
                if (this.hr2x_version >= HotRodConstants.VERSION_41) {
                    this.state = 302;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 305;
                return true;
            }
            case 301: {
                this.cacheProcessor.putStreamNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue, this.hr2x_lastPut, this.hr2x_retainedChunk);
                this.state = 0;
                return true;
            }
            case 302: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 303;
            }
            case 303: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 304;
                    return true;
                }
                throw new RequestParsingException("Retained chunk requires a chunk length greater than 0", this.hr2x_version, this.hr2x_messageId);
            }
            case 304: {
                int pos = buf.readerIndex();
                this.hr2x_retained = Intrinsics.retained(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_retainedChunk = this.hr2x_retained;
                this.state = 301;
                return true;
            }
            case 305: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 307;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0, 0);
                this.state = 306;
            }
            case 306: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 301;
                return true;
            }
            case 307: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 306;
                return true;
            }
            case 308: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 309;
            }
            case 309: {
                this.cacheProcessor.putStreamEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 310: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 311;
            }
            case 311: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 312;
            }
            case 312: {
                this.cacheProcessor.getStreamStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkLength);
                this.state = 0;
                return true;
            }
            case 313: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 314;
            }
            case 314: {
                this.cacheProcessor.getStreamNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 315: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 316;
            }
            case 316: {
                this.cacheProcessor.getStreamEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 317: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 319;
                return true;
            }
            case 318: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 325;
                return true;
            }
            case 319: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 320;
            }
        }
        return true;
    }

    private boolean switch5(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 320: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 322;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 321;
            }
            case 321: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 323;
                return true;
            }
            case 322: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 321;
                return true;
            }
            case 323: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 324;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 318;
                return true;
            }
            case 324: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 318;
                return true;
            }
            case 325: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 327;
                return true;
            }
            case 326: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, false, 60000L);
                this.state = 0;
                return true;
            }
            case 327: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 328;
            }
            case 328: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 326;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 329;
            }
            case 329: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 331;
                return true;
            }
            case 330: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 328;
                return true;
            }
            case 331: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 332;
            }
            case 332: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 334;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 333;
            }
            case 333: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 335;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 330;
                return true;
            }
            case 334: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 333;
                return true;
            }
            case 335: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 337;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 339;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 344;
                return true;
            }
            case 336: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 330;
                return true;
            }
            case 337: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 338;
            }
            case 338: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 336;
                return true;
            }
            case 339: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 340;
            }
            case 340: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 342;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 341;
            }
            case 341: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 343;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 336;
                return true;
            }
            case 342: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 341;
                return true;
            }
            case 343: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 336;
                return true;
            }
            case 344: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 346;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 345;
            }
            case 345: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 347;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 336;
                return true;
            }
            case 346: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 345;
                return true;
            }
            case 347: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 336;
                return true;
            }
            case 348: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 350;
                return true;
            }
            case 349: {
                this.cacheProcessor.commitTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 350: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 351;
            }
            case 351: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 353;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 352;
            }
            case 352: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 354;
                return true;
            }
            case 353: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 352;
                return true;
            }
            case 354: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 355;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 349;
                return true;
            }
            case 355: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 349;
                return true;
            }
            case 356: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 358;
                return true;
            }
            case 357: {
                this.cacheProcessor.rollbackTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 358: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 359;
            }
            case 359: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 361;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 360;
            }
            case 360: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 362;
                return true;
            }
            case 361: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 360;
                return true;
            }
            case 362: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 363;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 357;
                return true;
            }
            case 363: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 357;
                return true;
            }
            case 364: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 366;
                return true;
            }
            case 365: {
                this.cacheProcessor.forgetTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 366: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 367;
            }
            case 367: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 369;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 368;
            }
            case 368: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 370;
                return true;
            }
            case 369: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 368;
                return true;
            }
            case 370: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 371;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 365;
                return true;
            }
            case 371: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 365;
                return true;
            }
            case 372: {
                this.cacheProcessor.getPreparedTransactions(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 373: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 375;
                return true;
            }
            case 374: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 381;
                return true;
            }
            case 375: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 376;
            }
            case 376: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 378;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 377;
            }
            case 377: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 379;
                return true;
            }
            case 378: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 377;
                return true;
            }
            case 379: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 380;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 374;
                return true;
            }
            case 380: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 374;
                return true;
            }
            case 381: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_recoverable = this.hr2x_bool;
                this.state = 382;
            }
            case 382: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeout = this.hr2x_long;
                this.state = 383;
            }
            case 383: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 385;
                return true;
            }
        }
        return true;
    }

    private boolean switch6(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 384: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, this.hr2x_recoverable, this.hr2x_timeout);
                this.state = 0;
                return true;
            }
            case 385: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 386;
            }
            case 386: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 384;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 387;
            }
            case 387: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 389;
                return true;
            }
            case 388: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 386;
                return true;
            }
            case 389: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 390;
            }
            case 390: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 392;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 391;
            }
            case 391: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 393;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 388;
                return true;
            }
            case 392: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 391;
                return true;
            }
            case 393: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 395;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 397;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 402;
                return true;
            }
            case 394: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 388;
                return true;
            }
            case 395: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 396;
            }
            case 396: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 394;
                return true;
            }
            case 397: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 398;
            }
            case 398: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 400;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 399;
            }
            case 399: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 401;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 394;
                return true;
            }
            case 400: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 399;
                return true;
            }
            case 401: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 394;
                return true;
            }
            case 402: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 404;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 403;
            }
            case 403: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 405;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 394;
                return true;
            }
            case 404: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 403;
                return true;
            }
            case 405: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 394;
                return true;
            }
            case 406: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 407;
            }
            case 407: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterFlags = this.hr2x_byte;
                this.state = 409;
                return true;
            }
            case 408: {
                this.counterProcessor.createCounter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_counterConfiguration.build());
                this.state = 0;
                return true;
            }
            case 409: {
                this.hr2x_counterConfiguration = CounterConfiguration.builder((CounterType)CounterEncodeUtil.decodeType((byte)this.hr2x_counterFlags)).storage(CounterEncodeUtil.decodeStorage((byte)this.hr2x_counterFlags));
                this.state = 410;
            }
            case 410: {
                if ((this.hr2x_counterFlags & 1) == 1) {
                    this.state = 412;
                    return true;
                }
                this.state = 411;
            }
            case 411: {
                if ((this.hr2x_counterFlags & 2) == 2) {
                    this.state = 415;
                    return true;
                }
                this.state = 414;
                return true;
            }
            case 412: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 413;
            }
            case 413: {
                this.hr2x_counterConfiguration.concurrencyLevel(this.hr2x_vInt);
                this.state = 411;
                return true;
            }
            case 414: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_initialValue = this.hr2x_long;
                this.hr2x_counterConfiguration = this.hr2x_counterConfiguration.initialValue(this.hr2x_initialValue);
                this.state = 408;
                return true;
            }
            case 415: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lowerBound = this.hr2x_long;
                this.state = 416;
            }
            case 416: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_upperBound = this.hr2x_long;
                this.state = 417;
            }
            case 417: {
                this.hr2x_counterConfiguration.lowerBound(this.hr2x_lowerBound).upperBound(this.hr2x_upperBound);
                this.state = 414;
                return true;
            }
            case 418: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 419;
            }
            case 419: {
                this.counterProcessor.getCounterConfiguration(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 420: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 421;
            }
            case 421: {
                this.counterProcessor.isCounterDefined(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 422: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 423;
            }
            case 423: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 424;
            }
            case 424: {
                this.counterProcessor.counterAddAndGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 425: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 426;
            }
            case 426: {
                this.counterProcessor.counterReset(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 427: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 428;
            }
            case 428: {
                this.counterProcessor.counterGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 429: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 430;
            }
            case 430: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_expectValue = this.hr2x_long;
                this.state = 431;
            }
            case 431: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 432;
            }
            case 432: {
                this.counterProcessor.counterCompareAndSwap(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_expectValue, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 433: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 434;
            }
            case 434: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 435;
            }
            case 435: {
                this.counterProcessor.addCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 436: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 437;
            }
            case 437: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 438;
            }
            case 438: {
                this.counterProcessor.removeCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 439: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 440;
            }
            case 440: {
                this.counterProcessor.counterRemove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 441: {
                this.counterProcessor.getCounterNames(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 442: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 443;
            }
            case 443: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 444;
            }
            case 444: {
                this.counterProcessor.counterSet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 445: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 446;
            }
            case 446: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 448;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 447;
            }
            case 447: {
                this.multimapProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private boolean switch7(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 448: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 447;
                return true;
            }
            case 449: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 450;
            }
            case 450: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 452;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 451;
            }
            case 451: {
                this.multimapProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 452: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 451;
                return true;
            }
            case 453: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 454;
            }
            case 454: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 456;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 458;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 463;
                return true;
            }
            case 455: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 467;
                return true;
            }
            case 456: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 457;
            }
            case 457: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 455;
                return true;
            }
            case 458: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 459;
            }
            case 459: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 461;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 460;
            }
            case 460: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 462;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 455;
                return true;
            }
            case 461: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 460;
                return true;
            }
            case 462: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 455;
                return true;
            }
            case 463: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 465;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 464;
            }
            case 464: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 466;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 455;
                return true;
            }
            case 465: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 464;
                return true;
            }
            case 466: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 455;
                return true;
            }
            case 467: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 469;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 468;
            }
            case 468: {
                this.multimapProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 469: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 468;
                return true;
            }
            case 470: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 471;
            }
            case 471: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 473;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 472;
            }
            case 472: {
                this.multimapProcessor.removeKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 473: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 472;
                return true;
            }
            case 474: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 475;
            }
            case 475: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 477;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 479;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 484;
                return true;
            }
            case 476: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 488;
                return true;
            }
            case 477: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 478;
            }
            case 478: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 476;
                return true;
            }
            case 479: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 480;
            }
            case 480: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 482;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 481;
            }
            case 481: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 483;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 476;
                return true;
            }
            case 482: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 481;
                return true;
            }
            case 483: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 476;
                return true;
            }
            case 484: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 486;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 485;
            }
            case 485: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 487;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 476;
                return true;
            }
            case 486: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 485;
                return true;
            }
            case 487: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 476;
                return true;
            }
            case 488: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 490;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 489;
            }
            case 489: {
                this.multimapProcessor.removeEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 490: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 489;
                return true;
            }
            case 491: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 493;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 492;
            }
            case 492: {
                this.multimapProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 493: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 492;
                return true;
            }
            case 494: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 495;
            }
            case 495: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 497;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 499;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 504;
                return true;
            }
            case 496: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 508;
                return true;
            }
            case 497: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 498;
            }
            case 498: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 496;
                return true;
            }
            case 499: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 500;
            }
            case 500: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 502;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 501;
            }
            case 501: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 503;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 496;
                return true;
            }
            case 502: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 501;
                return true;
            }
            case 503: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 496;
                return true;
            }
            case 504: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 506;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 505;
            }
            case 505: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 507;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 496;
                return true;
            }
            case 506: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 505;
                return true;
            }
            case 507: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 496;
                return true;
            }
            case 508: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 510;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 509;
            }
            case 509: {
                this.multimapProcessor.containsEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 510: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 509;
                return true;
            }
            case 511: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 512;
            }
        }
        return true;
    }

    private boolean switch8(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 512: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 514;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 513;
            }
            case 513: {
                this.multimapProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 514: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 513;
                return true;
            }
            case 515: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 517;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 519;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 524;
                return true;
            }
            case 516: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 528;
                return true;
            }
            case 517: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 518;
            }
            case 518: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 516;
                return true;
            }
            case 519: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 520;
            }
            case 520: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 522;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 521;
            }
            case 521: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 523;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 516;
                return true;
            }
            case 522: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 521;
                return true;
            }
            case 523: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 516;
                return true;
            }
            case 524: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 526;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 525;
            }
            case 525: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 527;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 516;
                return true;
            }
            case 526: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 525;
                return true;
            }
            case 527: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 516;
                return true;
            }
            case 528: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 530;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 529;
            }
            case 529: {
                this.multimapProcessor.containsValue(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 530: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 529;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.cacheProcessor.writeException(this.getHeader(), (Throwable)((Object)new RequestParsingException("Invalid state of parsing", this.hr2x_version, this.hr2x_messageId)));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(Throwable t) throws Exception {
        log.trace("Parsing error", t);
        this.cacheProcessor.writeException(this.getHeader(), t);
        this.state = 0;
    }

    private void reset() {
        this.requestBytes = 0;
        this.hr2x_timeUnits = 0;
        this.hr2x_numEntries = 0;
        this.hr2x_iterationId = null;
        this.hr2x_controlByte = 0;
        this.hr2x_bloomBits = 0;
        this.hr2x_otherParamValue = null;
        this.hr2x_fixedArray = null;
        this.hr2x_queryBytes = null;
        this.hr2x_counterFlags = 0;
        this.hr2x_expectValue = 0L;
        this.hr2x_readable = null;
        this.hr2x_includeCurrentState = false;
        this.hr2x_taskParam = null;
        this.hr2x_otherParamName = null;
        this.hr2x_cacheName = null;
        this.hr2x_vInt = 0;
        this.hr2x_valueType = null;
        this.hr2x_initialValue = 0L;
        this.hr2x_numModifications = 0;
        this.hr2x_param = null;
        this.hr2x_authMech = null;
        this.hr2x_authResponse = null;
        this.hr2x_otherParamsNum = 0;
        this.hr2x_listenerInterests = 0;
        this.hr2x_numParams = 0;
        this.hr2x_xidFormat = 0;
        this.hr2x_filterFactory = null;
        this.hr2x_maxIdleLong = 0L;
        this.hr2x_operation = null;
        this.hr2x_otherParams = null;
        this.hr2x_upperBound = 0L;
        this.hr2x_version = 0;
        this.hr2x_converterFactory = null;
        this.hr2x_lastPut = false;
        this.hr2x_int = 0;
        this.hr2x_signedVInt = 0;
        this.hr2x_supportsDuplicates = false;
        this.hr2x_keyType = null;
        this.hr2x_filterConverterFactory = null;
        this.hr2x_mediaTypeParams = null;
        this.hr2x_versionRead = 0L;
        this.hr2x_lifespanInt = 0;
        this.hr2x_mediaParamValue = null;
        this.hr2x_intelligence = 0;
        this.hr2x_long = 0L;
        this.hr2x_mediaParamName = null;
        this.hr2x_converterParams = null;
        this.hr2x_recoverable = false;
        this.hr2x_bloomArray = null;
        this.hr2x_value = null;
        this.hr2x_branchLength = 0;
        this.hr2x_optionalString = null;
        this.hr2x_optionalArray = null;
        this.hr2x_bool = false;
        this.hr2x_xidLength = 0;
        this.hr2x_mediaTypeDefinition = 0;
        this.hr2x_expiration = null;
        this.hr2x_filterParams = null;
        this.hr2x_offset = 0;
        this.hr2x_chunkBytes = null;
        this.hr2x_updateValue = 0L;
        this.hr2x_txMarker = 0;
        this.hr2x_useRawEvents = false;
        this.hr2x_chunkLength = 0;
        this.hr2x_timeout = 0L;
        this.hr2x_taskName = null;
        this.hr2x_mediaTypeName = null;
        this.hr2x_lowerBound = 0L;
        this.hr2x_taskParamValue = null;
        this.hr2x_chunkedValue = null;
        this.hr2x_key = null;
        this.hr2x_batchSize = 0;
        this.hr2x_header = null;
        this.hr2x_scope = 0;
        this.hr2x_lifespanLong = 0L;
        this.hr2x_taskParams = null;
        this.hr2x_array = null;
        this.hr2x_flags = 0;
        this.hr2x_listenerId = null;
        this.hr2x_segmentMask = null;
        this.hr2x_magic = 0;
        this.hr2x_maxIdleInt = 0;
        this.hr2x_onePhaseCommit = false;
        this.hr2x_entryVersion = 0L;
        this.hr2x_mediaTypeId = 0;
        this.hr2x_includeMetadata = false;
        this.hr2x_opCode = 0;
        this.hr2x_entryMap = null;
        this.hr2x_mediaTypeParamsNum = 0;
        this.hr2x_messageId = 0L;
        this.hr2x_vLong = 0L;
        this.hr2x_filterConverterParams = null;
        this.hr2x_retained = null;
        this.hr2x_numKeys = 0;
        this.hr2x_otherParamsRev = null;
        this.hr2x_mediaType = null;
        this.hr2x_branchId = null;
        this.hr2x_retainedChunk = null;
        this.hr2x_intValue = 0;
        this.hr2x_string = null;
        this.hr2x_byte = 0;
        this.hr2x_transactionId = null;
        this.hr2x_mediaTypeDescription = null;
        this.hr2x_counterName = null;
        this.hr2x_modification = null;
        this.hr2x_counterConfiguration = null;
        this.hr2x_topologyId = 0;
        this.hr2x_keys = null;
        this.hr2x_xid = null;
        this.hr2x_modifications = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch63() throws Exception {
        switch (this.hr2x_opCode) {
            case 1: {
                this.state = 64;
                return true;
            }
            case 3: {
                this.state = 79;
                return true;
            }
            case 5: {
                this.state = 81;
                return true;
            }
            case 7: {
                this.state = 96;
                return true;
            }
            case 9: {
                this.state = 111;
                return true;
            }
            case 11: {
                this.state = 127;
                return true;
            }
            case 13: {
                this.state = 129;
                return true;
            }
            case 15: {
                this.state = 132;
                return true;
            }
            case 17: {
                this.state = 134;
                return true;
            }
            case 19: {
                this.state = 136;
                return true;
            }
            case 21: {
                this.state = 137;
                return true;
            }
            case 23: {
                this.state = 138;
                return true;
            }
            case 25: {
                this.state = 139;
                return true;
            }
            case 27: {
                this.state = 141;
                return true;
            }
            case 29: {
                this.state = 143;
                return true;
            }
            case 31: {
                this.state = 145;
                return true;
            }
            case 33: {
                this.state = 147;
                return true;
            }
            case 35: {
                this.state = 148;
                return true;
            }
            case 37: {
                this.state = 151;
                return true;
            }
            case 65: {
                this.state = 199;
                return true;
            }
            case 39: {
                this.state = 202;
                return true;
            }
            case 41: {
                this.state = 204;
                return true;
            }
            case 43: {
                this.state = 205;
                return true;
            }
            case 45: {
                this.state = 213;
                return true;
            }
            case 47: {
                this.state = 232;
                return true;
            }
            case 49: {
                this.state = 238;
                return true;
            }
            case 51: {
                this.state = 250;
                return true;
            }
            case 53: {
                this.state = 252;
                return true;
            }
            case 55: {
                this.state = 254;
                return true;
            }
            case 57: {
                this.state = 257;
                return true;
            }
            case 67: {
                this.state = 281;
                return true;
            }
            case -17: {
                this.state = 283;
                return true;
            }
            case -19: {
                this.state = 298;
                return true;
            }
            case -21: {
                this.state = 308;
                return true;
            }
            case -23: {
                this.state = 310;
                return true;
            }
            case -25: {
                this.state = 313;
                return true;
            }
            case -27: {
                this.state = 315;
                return true;
            }
            case 59: {
                this.state = 317;
                return true;
            }
            case 61: {
                this.state = 348;
                return true;
            }
            case 63: {
                this.state = 356;
                return true;
            }
            case 121: {
                this.state = 364;
                return true;
            }
            case 123: {
                this.state = 372;
                return true;
            }
            case 125: {
                this.state = 373;
                return true;
            }
            case 75: {
                this.state = 406;
                return true;
            }
            case 77: {
                this.state = 418;
                return true;
            }
            case 79: {
                this.state = 420;
                return true;
            }
            case 82: {
                this.state = 422;
                return true;
            }
            case 84: {
                this.state = 425;
                return true;
            }
            case 86: {
                this.state = 427;
                return true;
            }
            case 88: {
                this.state = 429;
                return true;
            }
            case 90: {
                this.state = 433;
                return true;
            }
            case 92: {
                this.state = 436;
                return true;
            }
            case 94: {
                this.state = 439;
                return true;
            }
            case 100: {
                this.state = 441;
                return true;
            }
            case 127: {
                this.state = 442;
                return true;
            }
            case 103: {
                this.state = 445;
                return true;
            }
            case 105: {
                this.state = 449;
                return true;
            }
            case 107: {
                this.state = 453;
                return true;
            }
            case 109: {
                this.state = 470;
                return true;
            }
            case 111: {
                this.state = 474;
                return true;
            }
            case 113: {
                this.state = 491;
                return true;
            }
            case 115: {
                this.state = 494;
                return true;
            }
            case 117: {
                this.state = 511;
                return true;
            }
            case 119: {
                this.state = 515;
                return true;
            }
        }
        throw new HotRodUnknownOperationException("Unknown operation " + this.hr2x_opCode, this.hr2x_version, this.hr2x_messageId);
    }
}

