/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.streaming.StreamingState;

public class PutStreamingState
extends StreamingState {
    private final Metadata.Builder metadata;
    private final long version;
    CompositeByteBuf compositeByteBuf;
    byte[] value;

    public PutStreamingState(byte[] key, Channel channel, Metadata.Builder metadata, long version) {
        super(key, channel);
        this.metadata = metadata;
        this.version = version;
        this.compositeByteBuf = channel.alloc().compositeHeapBuffer();
    }

    @Override
    public byte[] valueForPut() {
        this.verifyCorrectThread();
        return this.value;
    }

    @Override
    public Metadata.Builder metadataForPut() {
        this.verifyCorrectThread();
        return this.metadata;
    }

    @Override
    public long versionForPut() {
        this.verifyCorrectThread();
        return this.version;
    }

    @Override
    public void nextPut(ByteBuf buf) {
        this.verifyCorrectThread();
        this.compositeByteBuf.addComponent(true, buf);
    }

    @Override
    public void closePut() {
        this.verifyCorrectThread();
        this.close();
    }

    @Override
    public void close() {
        byte[] value = new byte[this.compositeByteBuf.readableBytes()];
        this.compositeByteBuf.readBytes(value);
        this.value = value;
        this.compositeByteBuf.release();
    }
}

