/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.None$;
import scala.ScalaObject;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11DistributionTest")
@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0017\tA\u0002j\u001c;S_\u0012\f\u0014\u0007R5tiJL'-\u001e;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u00025piJ|GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111\u0003S8u%>$W*\u001e7uS:{G-\u001a+fgR\u0004\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u00111bU2bY\u0006|%M[3di\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003\u001b\u0001AQa\u0007\u0001\u0005Rq\t\u0011bY1dQ\u0016t\u0015-\\3\u0016\u0003u\u0001\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t1\fgn\u001a\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0004TiJLgn\u001a\u0005\u0006M\u0001!\tfJ\u0001\u0012GJ,\u0017\r^3DC\u000eDWmQ8oM&<W#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-2\u0011AB2p]\u001aLw-\u0003\u0002.U\ti1i\u001c8gS\u001e,(/\u0019;j_:DQa\f\u0001\u0005RA\nq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002cA\u0011\u0011CM\u0005\u0003gI\u0011AAQ=uK\")Q\u0007\u0001C\tm\u0005aa/\u001b:uk\u0006dgj\u001c3fgV\tq\u0007\u0005\u0002\u0012q%\u0011\u0011H\u0005\u0002\u0004\u0013:$\b\"B\u001e\u0001\t\u0003a\u0014!\n;fgR$\u0015n\u001d;sS\n,H/\u001a3QkR<\u0016\u000e\u001e5U_B|Gn\\4z\u0007\"\fgnZ3t)\ti\u0004\t\u0005\u0002\u0012}%\u0011qH\u0005\u0002\u0005+:LG\u000fC\u0003Bu\u0001\u0007!)A\u0001n!\t\u0019e)D\u0001E\u0015\t)u$A\u0004sK\u001adWm\u0019;\n\u0005\u001d#%AB'fi\"|G\r\u000b\u0004\u0001\u0013F\u0013VK\u0016\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b1\"\u00198o_R\fG/[8og*\u0011a\nC\u0001\u0007i\u0016\u001cHO\\4\n\u0005A[%\u0001\u0002+fgR\faa\u001a:pkB\u001cH&A*\"\u0003Q\u000b!BZ;oGRLwN\\1m\u0003!!Xm\u001d;OC6,\u0017%A,\u0002MM,'O^3s]!|GO]8e]!{GOU8ecE\"\u0015n\u001d;sS\n,H/[8o)\u0016\u001cH\u000f")
public class HotRod11DistributionTest
extends HotRodMultiNodeTest
implements ScalaObject {
    public String cacheName() {
        return "distributedVersion11";
    }

    public Configuration createCacheConfig() {
        return AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
    }

    public byte protocolVersion() {
        return 11;
    }

    public int virtualNodes() {
        return 1;
    }

    public void testDistributedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.virtualNodes());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        boolean exceptionResult1 = false;
        this.log.trace((Object)"New client started, modify key to be v6-*");
        resp = newClient.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodServer hotRodServer = newServer;
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)this.servers().$colon$colon((Object)hotRodServer), this.virtualNodes());
        this.log.trace((Object)"Get key and verify that's v6-*");
        exceptionResult1 = HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)3, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        return;
        finally {
            newClient.stop();
            this.stopClusteredServer(newServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
    }
}

