/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestBulkGetResponse;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestResponseWithPrevious;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ByteArrayKey;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Test(groups={"functional"}, testName="server.hotrod.HotRodFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u0001-\u0011A\u0003S8u%>$g)\u001e8di&|g.\u00197UKN$(BA\u0002\u0005\u0003\u0019Aw\u000e\u001e:pI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003)!{GOU8e'&tw\r\\3O_\u0012,G+Z:u!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\u0007\u0001\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003I!Xm\u001d;V].twn\u001e8D_6l\u0017M\u001c3\u0015\u0005u\u0001\u0003CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\b\"B\u0011\u001b\u0001\u0004\u0011\u0013!A7\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002:fM2,7\r\u001e\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005\u0019iU\r\u001e5pI\")Q\u0006\u0001C\u0001]\u0005\u0001B/Z:u+:\\gn\\<o\u001b\u0006<\u0017n\u0019\u000b\u0003;=BQ!\t\u0017A\u0002\tBQ!\r\u0001\u0005\u0002I\nA\u0002^3tiB+HOQ1tS\u000e$\"!H\u001a\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000bU\u0002A\u0011\u0001\u001c\u0002+Q,7\u000f\u001e)vi>sG)\u001a4bk2$8)Y2iKR\u0011Qd\u000e\u0005\u0006CQ\u0002\rA\t\u0005\u0006s\u0001!\tAO\u0001\u0018i\u0016\u001cH\u000fU;u\u001f:,f\u000eZ3gS:,GmQ1dQ\u0016$\"!H\u001e\t\u000b\u0005B\u0004\u0019\u0001\u0012\t\u000bu\u0002A\u0011\u0001 \u0002-Q,7\u000f\u001e)vi>sGk\u001c9pY><\u0017pQ1dQ\u0016$\"!H \t\u000b\u0005b\u0004\u0019\u0001\u0012\t\u000b\u0005\u0003A\u0011\u0001\"\u0002'Q,7\u000f\u001e)vi^KG\u000f\u001b'jM\u0016\u001c\b/\u00198\u0015\u0005u\u0019\u0005\"B\u0011A\u0001\u0004\u0011\u0003\"B#\u0001\t\u00031\u0015A\u0005;fgR\u0004V\u000f^,ji\"l\u0015\r_%eY\u0016$\"!H$\t\u000b\u0005\"\u0005\u0019\u0001\u0012\t\u000b%\u0003A\u0011\u0001&\u00021Q,7\u000f\u001e)vi^KG\u000f\u001b)sKZLw.^:WC2,X\r\u0006\u0002\u001e\u0017\")\u0011\u0005\u0013a\u0001E!)Q\n\u0001C\u0001\u001d\u0006aA/Z:u\u000f\u0016$()Y:jGR\u0011Qd\u0014\u0005\u0006C1\u0003\rA\t\u0005\u0006#\u0002!\tAU\u0001\u0014i\u0016\u001cHoR3u\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0003;MCQ!\t)A\u0002\tBQ!\u0016\u0001\u0005\u0002Y\u000bq\u0003^3tiB+H/\u00134BEN,g\u000e\u001e(pi\u0016C\u0018n\u001d;\u0015\u0005u9\u0006\"B\u0011U\u0001\u0004\u0011\u0003\"B-\u0001\t\u0003Q\u0016\u0001\u0006;fgR\u0004V\u000f^%g\u0003\n\u001cXM\u001c;Fq&\u001cH\u000f\u0006\u0002\u001e7\")\u0011\u0005\u0017a\u0001E!)Q\f\u0001C\u0001=\u0006YB/Z:u!V$\u0018JZ!cg\u0016tGoV5uQ2Kg-Z:qC:$\"!H0\t\u000b\u0005b\u0006\u0019\u0001\u0012\t\u000b\u0005\u0004A\u0011\u00012\u00025Q,7\u000f\u001e)vi&3\u0017IY:f]R<\u0016\u000e\u001e5NCbLE\r\\3\u0015\u0005u\u0019\u0007\"B\u0011a\u0001\u0004\u0011\u0003\"B3\u0001\t\u00031\u0017\u0001\t;fgR\u0004V\u000f^%g\u0003\n\u001cXM\u001c;XSRD\u0007K]3wS>,8OV1mk\u0016$\"!H4\t\u000b\u0005\"\u0007\u0019\u0001\u0012\t\u000b%\u0004A\u0011\u00016\u0002!Q,7\u000f\u001e*fa2\f7-\u001a\"bg&\u001cGCA\u000fl\u0011\u0015\t\u0003\u000e1\u0001#\u0011\u0015i\u0007\u0001\"\u0001o\u0003i!Xm\u001d;O_R\u0014V\r\u001d7bG\u0016LeMT8u!J,7/\u001a8u)\tir\u000eC\u0003\"Y\u0002\u0007!\u0005C\u0003r\u0001\u0011\u0005!/A\fuKN$(+\u001a9mC\u000e,w+\u001b;i\u0019&4Wm\u001d9b]R\u0011Qd\u001d\u0005\u0006CA\u0004\rA\t\u0005\u0006k\u0002!\tA^\u0001\u0017i\u0016\u001cHOU3qY\u0006\u001cWmV5uQ6\u000b\u00070\u00133mKR\u0011Qd\u001e\u0005\u0006CQ\u0004\rA\t\u0005\u0006s\u0002!\tA_\u0001\u001di\u0016\u001cHOU3qY\u0006\u001cWmV5uQB\u0013XM^5pkN4\u0016\r\\;f)\ti2\u0010C\u0003\"q\u0002\u0007!\u0005C\u0003~\u0001\u0011\u0005a0A\fuKN$x)\u001a;XSRDg+\u001a:tS>t')Y:jGR\u0011Qd \u0005\u0006Cq\u0004\rA\t\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003y!Xm\u001d;HKR<\u0016\u000e\u001e5WKJ\u001c\u0018n\u001c8E_\u0016\u001chj\u001c;Fq&\u001cH\u000fF\u0002\u001e\u0003\u000fAa!IA\u0001\u0001\u0004\u0011\u0003bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u001di\u0016\u001cHOU3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012\u0014\u0015m]5d)\ri\u0012q\u0002\u0005\u0007C\u0005%\u0001\u0019\u0001\u0012\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005yB/Z:u%\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a(pi\u001a{WO\u001c3\u0015\u0007u\t9\u0002\u0003\u0004\"\u0003#\u0001\rA\t\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\t\"Xm\u001d;SKBd\u0017mY3JMVsWn\u001c3jM&,GMT8u\u000bb,7-\u001e;fIR\u0019Q$a\b\t\r\u0005\nI\u00021\u0001#\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\t\u0001\u0006^3tiJ+\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3XSRD\u0007K]3wS>,8OV1mk\u0016$2!HA\u0014\u0011\u0019\t\u0013\u0011\u0005a\u0001E!9\u00111\u0006\u0001\u0005\u0002\u00055\u0012\u0001\t;fgR\u0014V-\\8wK&3WK\\7pI&4\u0017.\u001a3XSRDW\t\u001f9jef$2!HA\u0018\u0011\u0019\t\u0013\u0011\u0006a\u0001E!9\u00111\u0007\u0001\u0005\n\u0005U\u0012\u0001D<bSRtu\u000e\u001e$pk:$GcB\u000f\u00028\u0005\u0005\u0013Q\t\u0005\t\u0003s\t\t\u00041\u0001\u0002<\u0005I1\u000f^1siRKW.\u001a\t\u0004#\u0005u\u0012bAA %\t!Aj\u001c8h\u0011!\t\u0019%!\rA\u0002\u0005m\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\r\u0005\n\t\u00041\u0001#\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nq\u0002^3tiJ+Wn\u001c<f\u0005\u0006\u001c\u0018n\u0019\u000b\u0004;\u00055\u0003BB\u0011\u0002H\u0001\u0007!\u0005C\u0004\u0002R\u0001!\t!a\u0015\u0002-Q,7\u000f\u001e*f[>4X\rR8fg:{G/\u0012=jgR$2!HA+\u0011\u0019\t\u0013q\na\u0001E!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013a\u0007;fgR\u0014V-\\8wK^KG\u000f\u001b)sKZLw.^:WC2,X\rF\u0002\u001e\u0003;Ba!IA,\u0001\u0004\u0011\u0003bBA1\u0001\u0011\u0005\u00111M\u0001\u001ci\u0016\u001cHOU3n_Z,\u0017JZ+o[>$\u0017NZ5fI\n\u000b7/[2\u0015\u0007u\t)\u0007\u0003\u0004\"\u0003?\u0002\rA\t\u0005\b\u0003S\u0002A\u0011AA6\u0003y!Xm\u001d;SK6|g/Z%g+:lw\u000eZ5gS\u0016$gj\u001c;G_VtG\rF\u0002\u001e\u0003[Ba!IA4\u0001\u0004\u0011\u0003bBA9\u0001\u0011\u0005\u00111O\u0001\"i\u0016\u001cHOU3n_Z,\u0017JZ+o[>$\u0017NZ5fI:{G/\u0012=fGV$X\r\u001a\u000b\u0004;\u0005U\u0004BB\u0011\u0002p\u0001\u0007!\u0005C\u0004\u0002z\u0001!\t!a\u001f\u0002MQ,7\u000f\u001e*f[>4X-\u00134V[>$\u0017NZ5fI^KG\u000f\u001b)sKZLw.^:WC2,X\rF\u0002\u001e\u0003{Ba!IA<\u0001\u0004\u0011\u0003bBAA\u0001\u0011\u0005\u00111Q\u0001\u0015i\u0016\u001cHoQ8oi\u0006Lgn]&fs\n\u000b7/[2\u0015\u0007u\t)\t\u0003\u0004\"\u0003\u007f\u0002\rA\t\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003m!Xm\u001d;D_:$\u0018-\u001b8t\u0017\u0016LHi\\3t\u001d>$X\t_5tiR\u0019Q$!$\t\r\u0005\n9\t1\u0001#\u0011\u001d\t\t\n\u0001C\u0001\u0003'\u000b\u0011\u0002^3ti\u000ecW-\u0019:\u0015\u0007u\t)\n\u0003\u0004\"\u0003\u001f\u0003\rA\t\u0005\b\u00033\u0003A\u0011AAN\u0003E!Xm\u001d;Ti\u0006$8\u000fR5tC\ndW\r\u001a\u000b\u0004;\u0005u\u0005BB\u0011\u0002\u0018\u0002\u0007!\u0005C\u0004\u0002\"\u0002!\t!a)\u0002\u0011Q,7\u000f\u001e)j]\u001e$2!HAS\u0011\u0019\t\u0013q\u0014a\u0001E!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0016a\b;fgR\u0004\u0016N\\4XSRDGk\u001c9pY><\u00170Q<be\u0016\u001cE.[3oiR\u0019Q$!,\t\r\u0005\n9\u000b1\u0001#\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b1\u0002^3ti\n+Hn[$fiR\u0019Q$!.\t\r\u0005\ny\u000b1\u0001#\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000b\u0011\u0003^3tiB+HOQ5h'&TXmS3z)\ri\u0012Q\u0018\u0005\u0007C\u0005]\u0006\u0019\u0001\u0012\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\u0006\u0019B/Z:u!V$()[4TSj,g+\u00197vKR\u0019Q$!2\t\r\u0005\ny\f1\u0001#\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017\fQ\u0005^3tiN#xN]3Bg\nKg.\u0019:z\u001fZ,'O]5eK>sg*Y7fI\u000e\u000b7\r[3\u0015\u0007u\ti\r\u0003\u0004\"\u0003\u000f\u0004\rA\t\u0015\f\u0001\u0005E\u0017\u0011]Ar\u0003S\fY\u000f\u0005\u0003\u0002T\u0006uWBAAk\u0015\u0011\t9.!7\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0004\u00037D\u0011A\u0002;fgRtw-\u0003\u0003\u0002`\u0006U'\u0001\u0002+fgR\faa\u001a:pkB\u001cHFAAsC\t\t9/\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0003\u0003[\f!e]3sm\u0016\u0014h\u0006[8ue>$g\u0006S8u%>$g)\u001e8di&|g.\u00197UKN$\b")
public class HotRodFunctionalTest
extends HotRodSingleNodeTest
implements ScalaObject {
    public void testUnknownCommand(Method m) {
        Enumeration.Value status = this.client().execute(160, (byte)119, this.cacheName(), HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L, (byte)1, 0).status();
        Assert.assertEquals((Object)status, (Object)OperationStatus$.MODULE$.UnknownOperation(), (String)new StringBuilder().append((Object)"Status should have been 'UnknownOperation' but instead was: ").append((Object)status).toString());
    }

    public void testUnknownMagic(Method m) {
        this.client().assertPut(m);
        Enumeration.Value status = this.client().executeExpectBadMagic(102, (byte)1, this.cacheName(), HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L).status();
        Assert.assertEquals((Object)status, (Object)OperationStatus$.MODULE$.InvalidMagicOrMsgId(), (String)new StringBuilder().append((Object)"Status should have been 'InvalidMagicOrMsgId' but instead was: ").append((Object)status).toString());
    }

    public void testPutBasic(Method m) {
        this.client().assertPut(m);
    }

    public void testPutOnDefaultCache(Method m) {
        TestResponse resp = this.client().execute(160, (byte)1, "", HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L, (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Cache cache = this.cacheManager.getCache();
        CacheValue value = (CacheValue)cache.get(new ByteArrayKey(HotRodTestingUtil$.MODULE$.k(m)));
        Assert.assertTrue((boolean)Arrays.equals(value.data(), HotRodTestingUtil$.MODULE$.v(m)));
    }

    public void testPutOnUndefinedCache(Method m) {
        TestErrorResponse resp = (TestErrorResponse)this.client().execute(160, (byte)1, "boomooo", HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L, (byte)1, 0);
        Assert.assertTrue((boolean)resp.msg().contains("CacheNotFoundException"));
        Assert.assertEquals((Object)resp.status(), (Object)OperationStatus$.MODULE$.ParseError(), (String)new StringBuilder().append((Object)"Status should have been 'ParseError' but instead was: ").append((Object)resp.status()).toString());
        this.client().assertPut(m);
    }

    public void testPutOnTopologyCache(Method m) {
        TestErrorResponse resp = (TestErrorResponse)this.client().execute(160, (byte)1, HotRodServer$.MODULE$.ADDRESS_CACHE_NAME(), HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L, (byte)1, 0);
        Assert.assertTrue((boolean)resp.msg().contains("Remote requests are not allowed to topology cache."));
        Assert.assertEquals((Object)resp.status(), (Object)OperationStatus$.MODULE$.ParseError(), (String)new StringBuilder().append((Object)"Status should have been 'ParseError' but instead was: ").append((Object)resp.status()).toString());
        this.client().assertPut(m);
    }

    public void testPutWithLifespan(Method m) {
        this.client().assertPut(m, 1, 0);
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutWithMaxIdle(Method m) {
        this.client().assertPut(m, 0, 1);
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        resp = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), 1);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testGetBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testGetDoesNotExist(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentNotExist(Method m) {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
    }

    public void testPutIfAbsentExist(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
    }

    public void testPutIfAbsentWithLifespan(Method m) {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 1, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentWithMaxIdle(Method m) {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 1, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        resp = (TestResponseWithPrevious)this.client().putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        Assert.assertTrue((boolean)Arrays.equals(HotRodTestingUtil$.MODULE$.v(m), (byte[])resp.previous().get()));
    }

    public void testReplaceBasic(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        TestResponse resp = this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
    }

    public void testReplaceWithLifespan(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 1, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testReplaceWithMaxIdle(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 0, 1, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Thread.sleep(1100L);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testReplaceWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        resp = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        resp = (TestResponseWithPrevious)this.client().replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), 1);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testGetWithVersionBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m), 0);
    }

    public void testGetWithVersionDoesNotExist(Method m) {
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(resp);
        Assert.assertTrue((resp.dataVersion() == 0L ? 1 : 0) != 0);
    }

    public void testReplaceIfUnmodifiedBasic(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
    }

    public void testReplaceIfUnmodifiedNotFound(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m, "k1-"), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.KeyDoesNotExist());
    }

    public void testReplaceIfUnmodifiedNotExecuted(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
        TestGetWithVersionResponse resp3 = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp3, HotRodTestingUtil$.MODULE$.v(m, "v1-"), 0);
        Assert.assertTrue((resp.dataVersion() != resp3.dataVersion() ? 1 : 0) != 0);
        TestResponse resp4 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp4, OperationStatus$.MODULE$.OperationNotExecuted());
        TestResponse resp5 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), resp3.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp5, OperationStatus$.MODULE$.Success());
    }

    public void testReplaceIfUnmodifiedWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 999L, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.KeyDoesNotExist());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        this.client().assertPut(m);
        TestGetWithVersionResponse getResp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(getResp, HotRodTestingUtil$.MODULE$.v(m), 0);
        resp = (TestResponseWithPrevious)this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), 888L, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        Assert.assertTrue((boolean)Arrays.equals(HotRodTestingUtil$.MODULE$.v(m), (byte[])resp.previous().get()));
        resp = (TestResponseWithPrevious)this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), getResp.dataVersion(), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertTrue((boolean)Arrays.equals(HotRodTestingUtil$.MODULE$.v(m), (byte[])resp.previous().get()));
    }

    public void testRemoveIfUnmodifiedWithExpiry(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        Assert.assertTrue((resp.dataVersion() != 0L ? 1 : 0) != 0);
        int lifespanSecs = 2;
        long lifespan = TimeUnit.SECONDS.toMillis(lifespanSecs);
        long startTime = System.currentTimeMillis();
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), lifespanSecs, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
        while (System.currentTimeMillis() < startTime + lifespan - 10L) {
            HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
            Thread.sleep(50L);
        }
        this.waitNotFound(startTime, lifespan, m);
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    private void waitNotFound(long startTime, long lifespan, Method m) {
        while (System.currentTimeMillis() < startTime + lifespan + 20000L) {
            Enumeration.Value value = OperationStatus$.MODULE$.Success();
            TestGetResponse testGetResponse = this.client().assertGet(m);
            if (value != null ? !value.equals((Object)testGetResponse) : testGetResponse != null) break;
            Thread.sleep(50L);
        }
    }

    public void testRemoveBasic(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().remove(HotRodTestingUtil$.MODULE$.k(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testRemoveDoesNotExist(Method m) {
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().remove(HotRodTestingUtil$.MODULE$.k(m)), OperationStatus$.MODULE$.KeyDoesNotExist());
    }

    public void testRemoveWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().remove(HotRodTestingUtil$.MODULE$.k(m), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.KeyDoesNotExist());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        this.client().assertPut(m);
        resp = (TestResponseWithPrevious)this.client().remove(HotRodTestingUtil$.MODULE$.k(m), 1);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testRemoveIfUnmodifiedBasic(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        Assert.assertTrue((resp.dataVersion() != 0L ? 1 : 0) != 0);
        TestResponse resp2 = this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testRemoveIfUnmodifiedNotFound(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        TestResponse resp2 = this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m, "k1-"), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.KeyDoesNotExist());
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testRemoveIfUnmodifiedNotExecuted(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp, HotRodTestingUtil$.MODULE$.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
        TestGetWithVersionResponse resp3 = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(resp3, HotRodTestingUtil$.MODULE$.v(m, "v1-"), 0);
        Assert.assertTrue((resp.dataVersion() != resp3.dataVersion() ? 1 : 0) != 0);
        TestResponse resp4 = this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), resp.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp4, OperationStatus$.MODULE$.OperationNotExecuted());
        TestResponse resp5 = this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), resp3.dataVersion());
        HotRodTestingUtil$.MODULE$.assertStatus(resp5, OperationStatus$.MODULE$.Success());
    }

    public void testRemoveIfUmodifiedWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 999L, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.KeyDoesNotExist());
        Assert.assertEquals(resp.previous(), (Object)None$.MODULE$);
        this.client().assertPut(m);
        TestGetWithVersionResponse getResp = this.client().getWithVersion(HotRodTestingUtil$.MODULE$.k(m), 0);
        HotRodTestingUtil$.MODULE$.assertSuccess(getResp, HotRodTestingUtil$.MODULE$.v(m), 0);
        resp = (TestResponseWithPrevious)this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), 888L, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        Assert.assertTrue((boolean)Arrays.equals(HotRodTestingUtil$.MODULE$.v(m), (byte[])resp.previous().get()));
        resp = (TestResponseWithPrevious)this.client().removeIfUnmodified(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), getResp.dataVersion(), 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertTrue((boolean)Arrays.equals(HotRodTestingUtil$.MODULE$.v(m), (byte[])resp.previous().get()));
    }

    public void testContainsKeyBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().containsKey(HotRodTestingUtil$.MODULE$.k(m), 0), OperationStatus$.MODULE$.Success());
    }

    public void testContainsKeyDoesNotExist(Method m) {
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().containsKey(HotRodTestingUtil$.MODULE$.k(m), 0), OperationStatus$.MODULE$.KeyDoesNotExist());
    }

    public void testClear(Method m$1) {
        Predef$.MODULE$.intWrapper(1).to(5).foreach((Function1)new Serializable(this, m$1){
            public static final long serialVersionUID;
            private final HotRodFunctionalTest $outer;
            private final Method m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int v1) {
                byte[] key = HotRodTestingUtil$.MODULE$.k(this.m$1, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                byte[] value = HotRodTestingUtil$.MODULE$.v(this.m$1, new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                HotRodTestingUtil$.MODULE$.assertStatus(this.$outer.client().put(key, 0, 0, value), OperationStatus$.MODULE$.Success());
                return HotRodTestingUtil$.MODULE$.assertStatus(this.$outer.client().containsKey(key, 0), OperationStatus$.MODULE$.Success());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = method;
            }
        });
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().clear(), OperationStatus$.MODULE$.Success());
        Predef$.MODULE$.intWrapper(1).to(5).foreach((Function1)new Serializable(this, m$1){
            public static final long serialVersionUID;
            private final HotRodFunctionalTest $outer;
            private final Method m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int v1) {
                byte[] key = HotRodTestingUtil$.MODULE$.k(this.m$1, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                return HotRodTestingUtil$.MODULE$.assertStatus(this.$outer.client().containsKey(key, 0), OperationStatus$.MODULE$.KeyDoesNotExist());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = method;
            }
        });
    }

    public void testStatsDisabled(Method m) {
        Map<String, String> s = this.client().stats();
        Assert.assertEquals((String)((String)s.get((Object)"timeSinceStart").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"currentNumberOfEntries").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"totalNumberOfEntries").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"stores").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"retrievals").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"hits").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"misses").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"removeHits").get()), (String)"-1");
        Assert.assertEquals((String)((String)s.get((Object)"removeMisses").get()), (String)"-1");
    }

    public void testPing(Method m) {
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().ping(), OperationStatus$.MODULE$.Success());
    }

    public void testPingWithTopologyAwareClient(Method m) {
        TestResponse resp = this.client().ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = this.client().ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = this.client().ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = this.client().ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
    }

    public void testBulkGet(Method m$2) {
        int size = 100;
        Predef$.MODULE$.intWrapper(0).until(size).foreach((Function1)new Serializable(this, m$2){
            public static final long serialVersionUID;
            private final HotRodFunctionalTest $outer;
            private final Method m$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int v1) {
                TestResponse resp = this.$outer.client().put(HotRodTestingUtil$.MODULE$.k(this.m$2, new StringBuilder().append(v1).append((Object)"k-").toString()), 0, 0, HotRodTestingUtil$.MODULE$.v(this.m$2, new StringBuilder().append(v1).append((Object)"v-").toString()));
                return HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$2 = method;
            }
        });
        TestBulkGetResponse resp = this.client().bulkGet();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        ObjectRef bulkData$1 = new ObjectRef(resp.bulkData());
        Assert.assertEquals((int)size, (int)((Map)bulkData$1.elem).size());
        Predef$.MODULE$.intWrapper(0).until(size).foreach$mVc$sp((Function1)new Serializable(this, m$2, bulkData$1){
            public static final long serialVersionUID;
            private final Method m$2;
            private final ObjectRef bulkData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                Assert.assertTrue((boolean)Arrays.equals((byte[])((Map)this.bulkData$1.elem).get((Object)new ByteArrayKey(HotRodTestingUtil$.MODULE$.k(this.m$2, new StringBuilder().append(v1).append((Object)"k-").toString()))).get(), HotRodTestingUtil$.MODULE$.v(this.m$2, new StringBuilder().append(v1).append((Object)"v-").toString())));
            }
            {
                this.m$2 = method;
                this.bulkData$1 = objectRef;
            }
        });
        size = 50;
        resp = this.client().bulkGet(size);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        bulkData$1.elem = resp.bulkData();
        Assert.assertEquals((int)size, (int)((Map)bulkData$1.elem).size());
        Predef$.MODULE$.intWrapper(0).until(size).foreach$mVc$sp((Function1)new Serializable(this, m$2, bulkData$1){
            public static final long serialVersionUID;
            private final Method m$2;
            private final ObjectRef bulkData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                ByteArrayKey key = new ByteArrayKey(HotRodTestingUtil$.MODULE$.k(this.m$2, new StringBuilder().append(v1).append((Object)"k-").toString()));
                if (((Map)this.bulkData$1.elem).contains((Object)key)) {
                    Assert.assertTrue((boolean)Arrays.equals((byte[])((Map)this.bulkData$1.elem).get((Object)key).get(), HotRodTestingUtil$.MODULE$.v(this.m$2, new StringBuilder().append(v1).append((Object)"v-").toString())));
                }
            }
            {
                this.m$2 = method;
                this.bulkData$1 = objectRef;
            }
        });
    }

    public void testPutBigSizeKey(Method m) {
        byte[] key = TestingUtil.generateRandomString((int)0x100000).getBytes();
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().put(key, 0, 0, HotRodTestingUtil$.MODULE$.v(m)), OperationStatus$.MODULE$.Success());
    }

    public void testPutBigSizeValue(Method m) {
        byte[] value = TestingUtil.generateRandomString((int)0x100000).getBytes();
        HotRodTestingUtil$.MODULE$.assertStatus(this.client().put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, value), OperationStatus$.MODULE$.Success());
    }

    public void testStoreAsBinaryOverrideOnNamedCache(Method m) {
        EmbeddedCacheManager cm = this.createTestCacheManager();
        String cacheName = new StringBuilder().append((Object)"cache-").append((Object)m.getName()).toString();
        Configuration namedCfg = new Configuration().fluent().storeAsBinary().build();
        Assert.assertTrue((boolean)namedCfg.isStoreAsBinary());
        cm.defineConfiguration(cacheName, namedCfg);
        HotRodServer testServer = HotRodTestingUtil$.MODULE$.startHotRodServer(cm, this.server().getPort() + 33);
        try {
            Assert.assertFalse((boolean)cm.getCache(cacheName).getConfiguration().isStoreAsBinary());
            return;
        }
        finally {
            cm.stop();
            testServer.stop();
        }
    }
}

