/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.TestAddress;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.EventImpl;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.CrashedMemberDetectorListener;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.CrashedMemberDetectorTest")
@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u0017\tI2I]1tQ\u0016$W*Z7cKJ$U\r^3di>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=1\u0011\u0001\u0002;fgRL!!\u0005\b\u0003-MKgn\u001a7f\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d+fgR\u0004\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u00111bU2bY\u0006|%M[3di\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\tbH\u0001\u0013GJ,\u0017\r^3DC\u000eDW-T1oC\u001e,'\u000fF\u0001!!\t\tC%D\u0001#\u0015\t\u0019c!A\u0004nC:\fw-\u001a:\n\u0005\u0015\u0012#\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\ruKN$H)\u001a;fGR\u001c%/Y:iK\u0012lU-\u001c2feN$\u0012!\u000b\t\u0003')J!a\u000b\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0007\u00015*d'\u000f\u001e\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014aC1o]>$\u0018\r^5p]NT!A\r\u0005\u0002\rQ,7\u000f\u001e8h\u0013\t!tF\u0001\u0003UKN$\u0018AB4s_V\u00048\u000fL\u00018C\u0005A\u0014A\u00034v]\u000e$\u0018n\u001c8bY\u0006AA/Z:u\u001d\u0006lW-I\u0001<\u0003\u001d\u001aXM\u001d<fe:Bw\u000e\u001e:pI:\u001a%/Y:iK\u0012lU-\u001c2fe\u0012+G/Z2u_J$Vm\u001d;")
public class CrashedMemberDetectorTest
extends SingleCacheManagerTest
implements ScalaObject {
    public EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createLocalCacheManager((boolean)false);
    }

    public void testDetectCrashedMembers() {
        Cache cache = this.cacheManager.getCache();
        cache.put(new TestAddress(1), new ServerAddress("a", 123));
        cache.put(new TestAddress(2), new ServerAddress("b", 456));
        cache.put(new TestAddress(3), new ServerAddress("c", 789));
        CrashedMemberDetectorListener detector = new CrashedMemberDetectorListener(cache);
        ArrayList<TestAddress> oldMembers = new ArrayList<TestAddress>();
        oldMembers.add(new TestAddress(1));
        oldMembers.add(new TestAddress(3));
        oldMembers.add(new TestAddress(2));
        ArrayList<TestAddress> newMembers = new ArrayList<TestAddress>();
        newMembers.add(new TestAddress(1));
        newMembers.add(new TestAddress(2));
        EventImpl e = new EventImpl("", this.cacheManager, Event.Type.VIEW_CHANGED, newMembers, oldMembers, (Address)new TestAddress(1), 99);
        detector.detectCrashedMember((ViewChangedEvent)e);
        AssertJUnit.assertTrue((boolean)cache.containsKey(new TestAddress(1)));
        AssertJUnit.assertTrue((boolean)cache.containsKey(new TestAddress(2)));
    }
}

