/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.cluster.ClusterCacheLoader;
import org.infinispan.loaders.cluster.ClusterCacheLoaderConfig;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.Main$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013a\u0006;fgR,6/\u001a:EK\u001aLg.\u001a3US6,w.\u001e;t+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\u0003V]&$\b\"\u0002\u0014\u0001\t\u0003\t\u0013\u0001\u0006;fgRd\u0015M_=M_\u0006$Gk\u001c9pY><\u0017\u0010C\u0003)\u0001\u0011%\u0011&A\nxSRD7\t\\;ti\u0016\u0014X\rZ*feZ,'\u000f\u0006\u0002+sQ\u0011!e\u000b\u0005\u0006Y\u001d\u0002\r!L\u0001\u0007CN\u001cXM\u001d;\u0011\u000bUq\u0003G\u000e\u0012\n\u0005=2\"!\u0003$v]\u000e$\u0018n\u001c83!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0004d_:4\u0017nZ\u0005\u0003kI\u0012QbQ8oM&<WO]1uS>t\u0007CA\u000b8\u0013\tAdC\u0001\u0003M_:<\u0007\"\u0002\u001e(\u0001\u0004Y\u0014!\u00029s_B\u001c\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u0011\u0003\u0011)H/\u001b7\n\u0005\u0001k$A\u0003)s_B,'\u000f^5fg\"2\u0001A\u0011&L\u001d>\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003\u000f\"\ta\u0001^3ti:<\u0017BA%E\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\u0005a\u0015%A'\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\u0005\u0001\u0016!J:feZ,'O\f5piJ|GM\f%piJ{GmQ8oM&<WO]1uS>tG+Z:u\u0001")
public class HotRodConfigurationTest
implements ScalaObject {
    public void testUserDefinedTimeouts() {
        Properties props = new Properties();
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_LOCK_TIMEOUT(), "26000");
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_REPL_TIMEOUT(), "31000");
        this.withClusteredServer(props, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.getLockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.getSyncReplTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.isStateTransferEnabled());
                Assert.assertEquals((long)cfg.getStateRetrievalTimeout(), (long)(31000L + distSyncTimeout));
                Assert.assertNull((Object)cfg.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig());
            }
        });
    }

    public void testLazyLoadTopology() {
        Properties props = new Properties();
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_STATE_TRANSFER(), "false");
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_REPL_TIMEOUT(), "43000");
        this.withClusteredServer(props, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.getSyncReplTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.isStateTransferEnabled());
                CacheLoaderConfig clcfg = (CacheLoaderConfig)cfg.getCacheLoaders().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((String)clcfg.getCacheLoaderClassName(), (String)ClusterCacheLoader.class.getName());
                Assert.assertEquals((long)((ClusterCacheLoaderConfig)clcfg).getRemoteCallTimeout(), (long)43000L);
            }
        });
    }

    private void withClusteredServer(Properties props, Function2<Configuration, Object, BoxedUnit> function2) {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        HotRodServer server = HotRodTestingUtil$.MODULE$.startHotRodServer(cacheManager, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), props);
        try {
            Configuration cfg = cacheManager.getCache(HotRodServer$.MODULE$.ADDRESS_CACHE_NAME()).getConfiguration();
            function2.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)cacheManager.getGlobalConfiguration().getDistributedSyncTimeout()));
            return;
        }
        finally {
            server.stop();
            cacheManager.stop();
        }
    }
}

