/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.hotrod.HotRodDistributionTest")
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u0017\t1\u0002j\u001c;S_\u0012$\u0015n\u001d;sS\n,H/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0001\u0002CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005MAu\u000e\u001e*pI6+H\u000e^5O_\u0012,G+Z:u!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\u0007\u0001\u0011\u0015Y\u0002\u0001\"\u0015\u001d\u0003%\u0019\u0017m\u00195f\u001d\u0006lW-F\u0001\u001e!\tq\u0012E\u0004\u0002\u0012?%\u0011\u0001EE\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!%!)Q\u0005\u0001C)M\u0005\t2M]3bi\u0016\u001c\u0015m\u00195f\u0007>tg-[4\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0004\u0002\r\r|gNZ5h\u0013\ta\u0013FA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006]\u0001!\tfL\u0001\u0010aJ|Go\\2pYZ+'o]5p]V\t\u0001\u0007\u0005\u0002\u0012c%\u0011!G\u0005\u0002\u0005\u0005f$X\rC\u00035\u0001\u0011\u0005Q'A\u0013uKN$H)[:ue&\u0014W\u000f^3e!V$x+\u001b;i)>\u0004x\u000e\\8hs\u000eC\u0017M\\4fgR\u0011a'\u000f\t\u0003#]J!\u0001\u000f\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006uM\u0002\raO\u0001\u0002[B\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\be\u00164G.Z2u\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\tv\u0012a!T3uQ>$\u0007\"\u0002$\u0001\t\u00139\u0015aF4f]\u0016\u0014\u0018\r^3FqB,7\r^3e\u0011\u0006\u001c\b.\u00133t+\u0005A\u0005\u0003\u0002\u0010J\u0017:K!AS\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u000e\u0019&\u0011QJ\u0001\u0002\u000e'\u0016\u0014h/\u001a:BI\u0012\u0014Xm]:\u0011\u0007=;&L\u0004\u0002Q+:\u0011\u0011\u000bV\u0007\u0002%*\u00111KC\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\u0016\n\u0002\u000fA\f7m[1hK&\u0011\u0001,\u0017\u0002\u0004'\u0016\f(B\u0001,\u0013!\t\t2,\u0003\u0002]%\t\u0019\u0011J\u001c;\t\u000b\u0019\u0003A\u0011\u00020\u0015\u0005!{\u0006\"\u00021^\u0001\u0004\t\u0017!\u00035s'\u0016\u0014h/\u001a:t!\ry%\rZ\u0005\u0003Gf\u0013A\u0001T5tiB\u0011Q\"Z\u0005\u0003M\n\u0011A\u0002S8u%>$7+\u001a:wKJDc\u0001\u00015qcR,\bCA5o\u001b\u0005Q'BA6m\u0003-\tgN\\8uCRLwN\\:\u000b\u00055D\u0011A\u0002;fgRtw-\u0003\u0002pU\n!A+Z:u\u0003\u00199'o\\;qg2\n!/I\u0001t\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\na/\u0001\u0013tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000e\u001a#jgR\u0014\u0018NY;uS>tG+Z:u\u0001")
public class HotRodDistributionTest
extends HotRodMultiNodeTest
implements ScalaObject {
    @Override
    public String cacheName() {
        return "hotRodDistSync";
    }

    @Override
    public Configuration createCacheConfig() {
        return AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
    }

    @Override
    public byte protocolVersion() {
        return 10;
    }

    public void testDistributedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Map<ServerAddress, Seq<Object>> expectedHashIds = this.generateExpectedHashIds();
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), expectedHashIds);
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        expectedHashIds = this.generateExpectedHashIds();
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), expectedHashIds);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        expectedHashIds = this.generateExpectedHashIds();
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), expectedHashIds);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        boolean exceptionResult1 = false;
        this.log.trace((Object)"New client started, modify key to be v6-*");
        resp = newClient.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        TestHashDistAware10Response hashTopologyResp = (TestHashDistAware10Response)((Object)resp.topologyResponse().get());
        HotRodTestingUtil$.MODULE$.assertTopologyId(hashTopologyResp.viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        Assert.assertEquals((int)hashTopologyResp.members().size(), (int)3);
        HotRodServer hotRodServer = newServer;
        List allServers = this.servers().$colon$colon((Object)hotRodServer);
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)hashTopologyResp, (List<HotRodServer>)allServers, this.generateExpectedHashIds((List<HotRodServer>)allServers));
        this.log.trace((Object)"Get key and verify that's v6-*");
        exceptionResult1 = HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)3, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        TestHashDistAware10Response hashTopologyResp2 = (TestHashDistAware10Response)((Object)resp.topologyResponse().get());
        Assert.assertEquals((int)hashTopologyResp2.viewId(), (int)3);
        Assert.assertEquals((int)hashTopologyResp2.members().size(), (int)2);
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)hashTopologyResp2, this.servers(), this.generateExpectedHashIds());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        return;
        finally {
            newClient.stop();
            this.stopClusteredServer(newServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
    }

    private Map<ServerAddress, Seq<Object>> generateExpectedHashIds() {
        return this.generateExpectedHashIds(this.servers());
    }

    private Map<ServerAddress, Seq<Object>> generateExpectedHashIds(List<HotRodServer> hrServers$1) {
        scala.collection.mutable.Map allHashIds$1 = scala.collection.mutable.Map$.MODULE$.empty();
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(0);
        ConsistentHash consistentHash$1 = cm.getCache(this.cacheName()).getAdvancedCache().getDistributionManager().getConsistentHash();
        for (int i = 0; consistentHash$1 instanceof UnionConsistentHash && i < 10; ++i) {
            TestingUtil.sleepThread((long)1000L);
        }
        JavaConversions$.MODULE$.asScalaIterator(cm.getMembers().iterator()).foreach((Function1)new Serializable(this, hrServers$1, allHashIds$1, consistentHash$1){
            public static final long serialVersionUID;
            private final List hrServers$1;
            private final scala.collection.mutable.Map allHashIds$1;
            private final ConsistentHash consistentHash$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final scala.collection.mutable.Map<ServerAddress, Seq<Object>> apply(Address member$1) {
                java.util.List ids = this.consistentHash$1.getHashIds(member$1);
                ServerAddress serverAddr = ((HotRodServer)((IterableLike)this.hrServers$1.filter((Function1)new Serializable(this, member$1){
                    public static final long serialVersionUID;
                    private final Address member$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(HotRodServer hotRodServer) {
                        Address address = hotRodServer.getCacheManager().getAddress();
                        Address address2 = this.member$1;
                        return !(address != null ? !address.equals(address2) : address2 != null);
                    }
                    {
                        this.member$1 = address;
                    }
                })).head()).getAddress();
                return (scala.collection.mutable.Map)this.allHashIds$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)serverAddr).$minus$greater((Object)JavaConversions$.MODULE$.asScalaBuffer(ids).toSeq()));
            }
            {
                this.hrServers$1 = list;
                this.allHashIds$1 = map;
                this.consistentHash$1 = consistentHash;
            }
        });
        return ((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)allHashIds$1);
    }
}

