/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u0017\t)\u0002j\u001c;S_\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0019Aw\u000e\u001e:pI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003'!{GOU8e\u001bVdG/\u001b(pI\u0016$Vm\u001d;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"!\u0004\u0001\t\u000bm\u0001A\u0011\u000b\u000f\u0002\u0013\r\f7\r[3OC6,W#A\u000f\u0011\u0005y\tcBA\t \u0013\t\u0001##\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\u0013\u0011\u0015)\u0003\u0001\"\u0015'\u0003E\u0019'/Z1uK\u000e\u000b7\r[3D_:4\u0017nZ\u000b\u0002OA\u0011\u0001fK\u0007\u0002S)\u0011!FB\u0001\u0007G>tg-[4\n\u00051J#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003/\u0001\u0011Es&A\bqe>$xnY8m-\u0016\u00148/[8o+\u0005\u0001\u0004CA\t2\u0013\t\u0011$C\u0001\u0003CsR,\u0007\"\u0002\u001b\u0001\t\u0003)\u0014!\u0005;fgR\u0014V\r\u001d7jG\u0006$X\r\u001a)viR\u0011a'\u000f\t\u0003#]J!\u0001\u000f\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006uM\u0002\raO\u0001\u0002[B\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\be\u00164G.Z2u\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\tv\u0012a!T3uQ>$\u0007\"\u0002$\u0001\t\u00039\u0015!\u0007;fgR\u0014V\r\u001d7jG\u0006$X\r\u001a)vi&3\u0017IY:f]R$\"A\u000e%\t\u000bi*\u0005\u0019A\u001e\t\u000b)\u0003A\u0011A&\u0002+Q,7\u000f\u001e*fa2L7-\u0019;fIJ+\u0007\u000f\\1dKR\u0011a\u0007\u0014\u0005\u0006u%\u0003\ra\u000f\u0005\u0006\u001d\u0002!\taT\u0001 i\u0016\u001cH\u000fU5oO^KG\u000f\u001b+pa>dwnZ=Bo\u0006\u0014Xm\u00117jK:$X#\u0001\u001c\t\u000bE\u0003A\u0011\u0001*\u0002IQ,7\u000f\u001e*fa2L7-\u0019;fIB+HoV5uQR{\u0007o\u001c7pOf\u001c\u0005.\u00198hKN$\"AN*\t\u000bi\u0002\u0006\u0019A\u001e)\r\u0001)VLX1c!\t16,D\u0001X\u0015\tA\u0016,A\u0006b]:|G/\u0019;j_:\u001c(B\u0001.\t\u0003\u0019!Xm\u001d;oO&\u0011Al\u0016\u0002\u0005)\u0016\u001cH/\u0001\u0004he>,\bo\u001d\u0017\u0002?\u0006\n\u0001-\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0002G\u0006\u00193/\u001a:wKJt\u0003n\u001c;s_\u0012t\u0003j\u001c;S_\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UKN$\b")
public class HotRodReplicationTest
extends HotRodMultiNodeTest
implements ScalaObject {
    public String cacheName() {
        return "hotRodReplSync";
    }

    /*
     * WARNING - void declaration
     */
    public Configuration createCacheConfig() {
        void var1_1;
        Configuration config = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.REPL_SYNC);
        config.setFetchInMemoryState(true);
        return var1_1;
    }

    public byte protocolVersion() {
        return 10;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)this.clients().head()).assertGet(m));
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m));
        TestResponse resp = ((HotRodClient)this.clients().head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(((HotRodClient)((IterableLike)this.clients().tail()).head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-")), OperationStatus$.MODULE$.OperationNotExecuted());
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        ((HotRodClient)((IterableLike)this.clients().tail()).head()).assertPut(m);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)this.clients().head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)this.clients().head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
    }

    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        boolean exceptionResult1 = false;
        TestResponse resp2 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp2.topologyResponse().get()).viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        TestTopologyAwareResponse topoResp$2 = resp2.asTopologyAwareResponse();
        Assert.assertEquals((int)topoResp$2.members().size(), (int)3);
        ServerAddress serverAddress = newServer.getAddress();
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServerAddress apply(HotRodServer hotRodServer) {
                return hotRodServer.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp$2){
            public static final long serialVersionUID;
            private final TestTopologyAwareResponse topoResp$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress addr$1) {
                Assert.assertTrue((boolean)this.topoResp$2.members().exists((Function1)new Serializable(this, addr$1){
                    public static final long serialVersionUID;
                    private final ServerAddress addr$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.addr$1;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.addr$1 = serverAddress;
                    }
                }));
            }
            {
                this.topoResp$2 = testTopologyAwareResponse;
            }
        });
        exceptionResult1 = HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        ObjectRef topoResp$1 = new ObjectRef((Object)resp.asTopologyAwareResponse());
        Assert.assertEquals((int)((TestTopologyAwareResponse)((Object)topoResp$1.elem)).members().size(), (int)2);
        ((LinearSeqOptimized)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServerAddress apply(HotRodServer hotRodServer) {
                return hotRodServer.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp$1){
            public static final long serialVersionUID;
            private final ObjectRef topoResp$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress addr$2) {
                Assert.assertTrue((boolean)((TestTopologyAwareResponse)((Object)this.topoResp$1.elem)).members().exists((Function1)new Serializable(this, addr$2){
                    public static final long serialVersionUID;
                    private final ServerAddress addr$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.addr$2;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.addr$2 = serverAddress;
                    }
                }));
            }
            {
                this.topoResp$1 = objectRef;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25, true);
        addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        boolean exceptionResult2 = false;
        TestResponse resp3 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)2, 3);
        HotRodTestingUtil$.MODULE$.assertStatus(resp3, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp3.topologyResponse().get()).viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        TestTopologyAwareResponse topoResp$3 = resp3.asTopologyAwareResponse();
        Assert.assertEquals((int)topoResp$3.members().size(), (int)3);
        ServerAddress serverAddress2 = crashingServer.getAddress();
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServerAddress apply(HotRodServer hotRodServer) {
                return hotRodServer.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress2).foreach((Function1)new Serializable(this, topoResp$3){
            public static final long serialVersionUID;
            private final TestTopologyAwareResponse topoResp$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress addr$3) {
                Assert.assertTrue((boolean)this.topoResp$3.members().exists((Function1)new Serializable(this, addr$3){
                    public static final long serialVersionUID;
                    private final ServerAddress addr$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.addr$3;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.addr$3 = serverAddress;
                    }
                }));
            }
            {
                this.topoResp$3 = testTopologyAwareResponse;
            }
        });
        exceptionResult2 = HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)2, 4);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        topoResp$1.elem = resp.asTopologyAwareResponse();
        Assert.assertEquals((int)((TestTopologyAwareResponse)((Object)topoResp$1.elem)).members().size(), (int)2);
        ((LinearSeqOptimized)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServerAddress apply(HotRodServer hotRodServer) {
                return hotRodServer.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp$1){
            public static final long serialVersionUID;
            private final ObjectRef topoResp$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress addr$4) {
                Assert.assertTrue((boolean)((TestTopologyAwareResponse)((Object)this.topoResp$1.elem)).members().exists((Function1)new Serializable(this, addr$4){
                    public static final long serialVersionUID;
                    private final ServerAddress addr$4;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.addr$4;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.addr$4 = serverAddress;
                    }
                }));
            }
            {
                this.topoResp$1 = objectRef;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        TestHashDistAware10Response hashTopologyResp$1 = (TestHashDistAware10Response)((Object)resp.topologyResponse().get());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).viewId(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        Assert.assertEquals((int)hashTopologyResp$1.members().size(), (int)2);
        ((LinearSeqOptimized)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServerAddress apply(HotRodServer hotRodServer) {
                return hotRodServer.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, hashTopologyResp$1){
            public static final long serialVersionUID;
            private final TestHashDistAware10Response hashTopologyResp$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress addr$5) {
                Assert.assertTrue((boolean)this.hashTopologyResp$1.members().exists((Function1)new Serializable(this, addr$5){
                    public static final long serialVersionUID;
                    private final ServerAddress addr$5;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.addr$5;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.addr$5 = serverAddress;
                    }
                }));
            }
            {
                this.hashTopologyResp$1 = testHashDistAware10Response;
            }
        });
        Map expectedHashIds = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)((HotRodServer)this.servers().head()).getAddress()).$minus$greater((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef$.MODULE$.any2ArrowAssoc((Object)((HotRodServer)((IterableLike)this.servers().tail()).head()).getAddress()).$minus$greater((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        HotRodTestingUtil$.MODULE$.assertHashIds(hashTopologyResp$1.hashIds(), (Map<ServerAddress, Seq<Object>>)expectedHashIds);
        Assert.assertEquals((int)hashTopologyResp$1.numOwners(), (int)0);
        Assert.assertEquals((int)hashTopologyResp$1.hashFunction(), (int)0);
        Assert.assertEquals((int)hashTopologyResp$1.hashSpace(), (int)0);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
        return;
        finally {
            this.stopClusteredServer(newServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
        finally {
            this.stopClusteredServer(crashingServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
    }
}

