/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.AbstractVersionedEncoder;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.Constants;
import org.infinispan.server.hotrod.Constants$class;
import org.infinispan.server.hotrod.Encoder10$;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HashDistAwareResponse;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.Log$class;
import org.infinispan.util.ByteArrayKey;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Encoder10$
extends AbstractVersionedEncoder
implements Constants,
Log,
ScalaObject {
    public static final Encoder10$ MODULE$;
    private final JavaLog log;
    private final org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log;
    private final int MAGIC_REQ;
    private final int MAGIC_RES;
    private final byte VERSION_10;
    private final byte VERSION_11;
    private final byte DEFAULT_HASH_FUNCTION_VERSION;
    public volatile int bitmap$0;
    private volatile int bitmap$priv$0;

    static {
        new Encoder10$();
    }

    @Override
    public void writeHeader(Response r, ChannelBuffer buf, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        AbstractTopologyResponse abstractTopologyResponse;
        block8: {
            block6: {
                block7: {
                    TopologyAwareResponse topologyAwareResponse;
                    AbstractTopologyResponse topologyResp;
                    block5: {
                        topologyResp = this.getTopologyResponse(r, addressCache, server);
                        buf.writeByte((int)Predef$.MODULE$.int2Integer(this.MAGIC_RES()).byteValue());
                        ExtendedChannelBuffer$.MODULE$.writeUnsignedLong(r.messageId(), buf);
                        buf.writeByte((int)Predef$.MODULE$.int2Integer(r.operation().id()).byteValue());
                        buf.writeByte((int)Predef$.MODULE$.int2Integer(r.status().id()).byteValue());
                        if (topologyResp != null) break block5;
                        buf.writeByte(0);
                        break block6;
                    }
                    abstractTopologyResponse = topologyResp;
                    if (!(abstractTopologyResponse instanceof TopologyAwareResponse)) break block7;
                    TopologyAwareResponse t = topologyAwareResponse = (TopologyAwareResponse)abstractTopologyResponse;
                    if (r.clientIntel() == 2) {
                        this.writeTopologyHeader(this, t, buf, addressCache);
                    } else {
                        this.writeHashTopologyHeader(t, buf, addressCache);
                    }
                    break block6;
                }
                if (!(abstractTopologyResponse instanceof HashDistAwareResponse)) break block8;
                this.writeHashTopologyHeader((HashDistAwareResponse)abstractTopologyResponse, buf, r, addressCache);
            }
            return;
        }
        throw new MatchError((Object)abstractTopologyResponse);
    }

    @Override
    public void writeResponse(Response r, ChannelBuffer buf, EmbeddedCacheManager cm) {
        this.writeResponse(this, r, buf, cm);
    }

    public void writeResponse(Log log, Response r, ChannelBuffer buf$1, EmbeddedCacheManager cacheManager) {
        Response response = r;
        if (response instanceof ResponseWithPrevious) {
            ResponseWithPrevious responseWithPrevious;
            ResponseWithPrevious r2 = responseWithPrevious = (ResponseWithPrevious)response;
            Option<byte[]> option = r2.previous();
            None$ none$ = None$.MODULE$;
            if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
                ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(0, buf$1);
            } else {
                ExtendedChannelBuffer$.MODULE$.writeRangedBytes((byte[])r2.previous().get(), buf$1);
            }
        } else if (response instanceof StatsResponse) {
            StatsResponse statsResponse;
            StatsResponse s = statsResponse = (StatsResponse)response;
            ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(s.stats().size(), buf$1);
            ((IterableLike)s.stats().filter((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(buf$1){
                public static final long serialVersionUID;
                private final ChannelBuffer buf$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ExtendedChannelBuffer$.MODULE$.writeString((String)tuple22._1(), this.buf$1);
                        ExtendedChannelBuffer$.MODULE$.writeString((String)tuple22._2(), this.buf$1);
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.buf$1 = channelBuffer;
                }
            });
        } else if (response instanceof GetWithVersionResponse) {
            GetWithVersionResponse getWithVersionResponse;
            GetWithVersionResponse g = getWithVersionResponse = (GetWithVersionResponse)response;
            Enumeration.Value value = g.status();
            Enumeration.Value value2 = OperationStatus$.MODULE$.Success();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                buf$1.writeLong(g.dataVersion());
                ExtendedChannelBuffer$.MODULE$.writeRangedBytes((byte[])g.data().get(), buf$1);
            }
        } else if (response instanceof BulkGetResponse) {
            BulkGetResponse bulkGetResponse;
            BulkGetResponse g = bulkGetResponse = (BulkGetResponse)response;
            log.trace((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "About to respond to bulk get request";
                }
            });
            Enumeration.Value value = g.status();
            Enumeration.Value value3 = OperationStatus$.MODULE$.Success();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(g.cacheName(), cacheManager);
                Iterator iterator = JavaConversions$.MODULE$.asScalaIterator(cache.entrySet().iterator());
                if (g.count() != 0) {
                    log.trace((Function0)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "About to write (max) %d messages to the client";
                        }
                    }, BoxesRunTime.boxToInteger((int)g.count()));
                    iterator = iterator.take(g.count());
                }
                iterator.foreach((Function1)new Serializable(buf$1){
                    public static final long serialVersionUID;
                    private final ChannelBuffer buf$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Map.Entry<ByteArrayKey, CacheValue> entry) {
                        this.buf$1.writeByte(1);
                        ExtendedChannelBuffer$.MODULE$.writeRangedBytes(entry.getKey().getData(), this.buf$1);
                        ExtendedChannelBuffer$.MODULE$.writeRangedBytes(entry.getValue().data(), this.buf$1);
                    }
                    {
                        this.buf$1 = channelBuffer;
                    }
                });
                buf$1.writeByte(0);
            }
        } else if (response instanceof GetResponse) {
            GetResponse getResponse;
            GetResponse g = getResponse = (GetResponse)response;
            Enumeration.Value value = g.status();
            Enumeration.Value value4 = OperationStatus$.MODULE$.Success();
            if (!(value != null ? !value.equals(value4) : value4 != null)) {
                ExtendedChannelBuffer$.MODULE$.writeRangedBytes((byte[])g.data().get(), buf$1);
            }
        } else if (response instanceof ErrorResponse) {
            ExtendedChannelBuffer$.MODULE$.writeString(((ErrorResponse)response).msg(), buf$1);
        } else if (buf$1 == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Response received is unknown: ").append((Object)r).toString());
        }
    }

    public AbstractTopologyResponse getTopologyResponse(Response r, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        AbstractTopologyResponse abstractTopologyResponse;
        if (addressCache == null) {
            abstractTopologyResponse = null;
        } else {
            short s = r.clientIntel();
            switch (s) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
                }
                case 1: {
                    abstractTopologyResponse = null;
                    break;
                }
                case 2: 
                case 3: {
                    int lastViewId = server.getViewId();
                    if (r.topologyId() != lastViewId) {
                        Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(r.cacheName(), addressCache.getCacheManager());
                        Configuration config = cache.getConfiguration();
                        if (r.clientIntel() != 2 && config.getCacheMode().isDistributed()) {
                            abstractTopologyResponse = new HashDistAwareResponse(lastViewId, config.getNumOwners(), this.DEFAULT_HASH_FUNCTION_VERSION(), Integer.MAX_VALUE);
                            break;
                        }
                        abstractTopologyResponse = new TopologyAwareResponse(lastViewId);
                        break;
                    }
                    abstractTopologyResponse = null;
                }
            }
        }
        return abstractTopologyResponse;
    }

    public void writeTopologyHeader(Log log, TopologyAwareResponse t, ChannelBuffer buffer$1, Cache<Address, ServerAddress> addrCache) {
        log.trace((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Write topology change response header %s";
            }
        }, t);
        buffer$1.writeByte(1);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(t.viewId(), buffer$1);
        Collection serverAddresses = addrCache.values();
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(serverAddresses.size(), buffer$1);
        JavaConversions$.MODULE$.collectionAsScalaIterable(serverAddresses).foreach((Function1)new Serializable(buffer$1){
            public static final long serialVersionUID;
            private final ChannelBuffer buffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress address) {
                ExtendedChannelBuffer$.MODULE$.writeString(address.host(), this.buffer$1);
                ExtendedChannelBuffer$.MODULE$.writeUnsignedShort(address.port(), this.buffer$1);
            }
            {
                this.buffer$1 = channelBuffer;
            }
        });
    }

    private void writeHashTopologyHeader(TopologyAwareResponse t, ChannelBuffer buffer$3, Cache<Address, ServerAddress> addrCache) {
        this.trace((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Return limited hash distribution aware header in spite of having a hash aware client %s";
            }
        }, t);
        buffer$3.writeByte(1);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(t.viewId(), buffer$3);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedShort(0, buffer$3);
        buffer$3.writeByte(0);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(0, buffer$3);
        Collection serverAddresses = addrCache.values();
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(serverAddresses.size(), buffer$3);
        JavaConversions$.MODULE$.collectionAsScalaIterable(serverAddresses).foreach((Function1)new Serializable(buffer$3){
            public static final long serialVersionUID;
            private final ChannelBuffer buffer$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ServerAddress address) {
                ExtendedChannelBuffer$.MODULE$.writeString(address.host(), this.buffer$3);
                ExtendedChannelBuffer$.MODULE$.writeUnsignedShort(address.port(), this.buffer$3);
                this.buffer$3.writeInt(0);
            }
            {
                this.buffer$3 = channelBuffer;
            }
        });
    }

    private void writeHashTopologyHeader(HashDistAwareResponse h, ChannelBuffer buffer$2, Response r, Cache<Address, ServerAddress> addressCache$1) {
        this.trace((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Write hash distribution change response header %s";
            }
        }, h);
        buffer$2.writeByte(1);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(h.viewId(), buffer$2);
        ExtendedChannelBuffer$.MODULE$.writeUnsignedShort(h.numOwners(), buffer$2);
        buffer$2.writeByte((int)h.hashFunction());
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(h.hashSpace(), buffer$2);
        Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(r.cacheName(), addressCache$1.getCacheManager());
        int numVNodes = cache.getConfiguration().getNumVirtualNodes();
        List clusterMembers = addressCache$1.getCacheManager().getMembers();
        int totalNumServers = clusterMembers.size() * numVNodes;
        ExtendedChannelBuffer$.MODULE$.writeUnsignedInt(totalNumServers, buffer$2);
        DistributionManager distManager$1 = cache.getAdvancedCache().getDistributionManager();
        JavaConversions$.MODULE$.asScalaBuffer(clusterMembers).foreach((Function1)new Serializable(buffer$2, addressCache$1, distManager$1){
            public static final long serialVersionUID;
            public final ChannelBuffer buffer$2;
            private final Cache addressCache$1;
            private final DistributionManager distManager$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Address clusterAddr) {
                List cacheHashIds = this.distManager$1.getConsistentHash().getHashIds(clusterAddr);
                ServerAddress address$1 = (ServerAddress)this.addressCache$1.get(clusterAddr);
                JavaConversions$.MODULE$.asScalaBuffer(cacheHashIds).foreach((Function1)new Serializable(this, address$1){
                    public static final long serialVersionUID;
                    private final anonfun.writeHashTopologyHeader.4 $outer;
                    private final ServerAddress address$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Integer hashId) {
                        ExtendedChannelBuffer$.MODULE$.writeString(this.address$1.host(), this.$outer.buffer$2);
                        ExtendedChannelBuffer$.MODULE$.writeUnsignedShort(this.address$1.port(), this.$outer.buffer$2);
                        this.$outer.buffer$2.writeInt(Predef$.MODULE$.Integer2int(hashId));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.address$1 = serverAddress;
                    }
                });
            }
            {
                this.buffer$2 = channelBuffer;
                this.addressCache$1 = cache;
                this.distManager$1 = distributionManager;
            }
        });
    }

    private Encoder10$() {
        MODULE$ = this;
        Constants$class.$init$(this);
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log$class.$init$(this);
    }
}

