/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.None$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11DistributionTest")
@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u0017\tA\u0002j\u001c;S_\u0012\f\u0014\u0007R5tiJL'-\u001e;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u00025piJ|GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t\u0019\u0002j\u001c;S_\u0012lU\u000f\u001c;j\u001d>$W\rV3ti\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005RY\t\u0011bY1dQ\u0016t\u0015-\\3\u0016\u0003]\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004TiJLgn\u001a\u0005\u0006A\u0001!\t&I\u0001\u0012GJ,\u0017\r^3DC\u000eDWmQ8oM&<W#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0011AB2p]\u001aLw-\u0003\u0002(I\ti1i\u001c8gS\u001e,(/\u0019;j_:DQ!\u000b\u0001\u0005R)\nq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t!!)\u001f;f\u0011\u0015\u0011\u0004\u0001\"\u00054\u000311\u0018N\u001d;vC2tu\u000eZ3t+\u0005!\u0004C\u0001\u00176\u0013\t1TFA\u0002J]RDQ\u0001\u000f\u0001\u0005\u0002e\nQ\u0005^3ti\u0012K7\u000f\u001e:jEV$X\r\u001a)vi^KG\u000f\u001b+pa>dwnZ=DQ\u0006tw-Z:\u0015\u0005ij\u0004C\u0001\u0017<\u0013\taTF\u0001\u0003V]&$\b\"\u0002 8\u0001\u0004y\u0014!A7\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tK\u0012a\u0002:fM2,7\r^\u0005\u0003\t\u0006\u0013a!T3uQ>$\u0007F\u0002\u0001G\u001d>\u00136\u000b\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\tY\u0005\"\u0001\u0004uKN$hnZ\u0005\u0003\u001b\"\u0013A\u0001V3ti\u00061qM]8vaNd\u0013\u0001U\u0011\u0002#\u0006Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f\u0013\u0001V\u0001'g\u0016\u0014h/\u001a:/Q>$(o\u001c3/\u0011>$(k\u001c32c\u0011K7\u000f\u001e:jEV$\u0018n\u001c8UKN$\b")
public class HotRod11DistributionTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "distributedVersion11";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration createCacheConfig() {
        void var1_1;
        Configuration cfg = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        cfg.fluent().l1().disable();
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 11;
    }

    public int virtualNodes() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void testDistributedPutWithTopologyChanges(Method m) {
        HotRodClient client1 = (HotRodClient)this.clients().head();
        HotRodClient client2 = (HotRodClient)((IterableLike)this.clients().tail()).head();
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        HotRodServer hotRodServer = newServer;
        List allServers = this.servers().$colon$colon((Object)hotRodServer);
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        try {
            this.log.trace((Object)"New client started, modify key to be v6-*");
            resp = newClient.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)3, 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName(), 2, this.virtualNodes());
            this.log.trace((Object)"Get key from other client and verify that's v6-*");
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
            resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)3, 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName(), 2, this.virtualNodes());
            HotRodTestingUtil$.MODULE$.assertSuccess(newClient.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        }
        catch (Throwable throwable) {
            void var9_9;
            void var5_5;
            void var6_6;
            this.log.trace((Object)"Stopping new server");
            HotRodTestingUtil$.MODULE$.killClient((HotRodClient)var6_6);
            this.stopClusteredServer((HotRodServer)var5_5);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval((Seq<CountDownLatch>)var9_9);
            this.log.trace((Object)"New server stopped");
            throw throwable;
        }
        this.log.trace((Object)"Stopping new server");
        HotRodTestingUtil$.MODULE$.killClient(newClient);
        this.stopClusteredServer(newServer);
        HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        this.log.trace((Object)"New server stopped");
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(client1.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }
}

