/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil$;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodMagicKeyGenerator$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11StorageOnlyNodesTest")
@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u0017\ta\u0002j\u001c;S_\u0012\f\u0014g\u0015;pe\u0006<Wm\u00148ms:{G-Z:UKN$(BA\u0002\u0005\u0003\u0019Aw\u000e\u001e:pI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0014\u0011>$(k\u001c3Nk2$\u0018NT8eKR+7\u000f\u001e\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"!\u0004\u0001\t\u000bU\u0001A\u0011\u000b\f\u0002\u0013\r\f7\r[3OC6,W#A\f\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t11\u000b\u001e:j]\u001eDQ\u0001\t\u0001\u0005R\u0005\n\u0011c\u0019:fCR,7)Y2iK\u000e{gNZ5h+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u0019\u0019wN\u001c4jO&\u0011q\u0005\n\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b%\u0002A\u0011\u000b\u0016\u0002\u001fA\u0014x\u000e^8d_24VM]:j_:,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005\u0005f$X\rC\u00033\u0001\u0011E1'\u0001\u0007wSJ$X/\u00197O_\u0012,7/F\u00015!\taS'\u0003\u00027[\t\u0019\u0011J\u001c;\t\u000ba\u0002A\u0011A\u001d\u00023Q,7\u000f^!eI&twm\u0015;pe\u0006<Wm\u00148ms:{G-\u001a\u000b\u0003uu\u0002\"\u0001L\u001e\n\u0005qj#\u0001B+oSRDQAP\u001cA\u0002}\n\u0011!\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005f\tqA]3gY\u0016\u001cG/\u0003\u0002E\u0003\n1Q*\u001a;i_\u0012Dc\u0001\u0001$O\u001fJ\u001b\u0006CA$M\u001b\u0005A%BA%K\u0003-\tgN\\8uCRLwN\\:\u000b\u0005-C\u0011A\u0002;fgRtw-\u0003\u0002N\u0011\n!A+Z:u\u0003\u00199'o\\;qg2\n\u0001+I\u0001R\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\nA+\u0001\u0016tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000eZ\u00192'R|'/Y4f\u001f:d\u0017PT8eKN$Vm\u001d;")
public class HotRod11StorageOnlyNodesTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "distributed";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration createCacheConfig() {
        void var1_1;
        Configuration cfg = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        cfg.fluent().l1().disable();
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 11;
    }

    public int virtualNodes() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void testAddingStorageOnlyNode(Method m) {
        HotRodServer server1 = (HotRodServer)this.servers().head();
        HotRodServer server2 = (HotRodServer)this.servers().last();
        HotRodClient client1 = (HotRodClient)this.clients().head();
        HotRodClient client2 = (HotRodClient)this.clients().last();
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes());
        int topologyId = ((AbstractTopologyResponse)resp.topologyResponse().get()).viewId();
        EmbeddedCacheManager newCacheManager = this.addClusterEnabledCacheManager();
        try {
            newCacheManager.defineConfiguration(this.cacheName(), this.createCacheConfig());
            newCacheManager.getCache(this.cacheName());
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)true, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(1), this.manager(2)});
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName()), this.cache(2, this.cacheName())});
            this.log.trace((Object)"Check that the clients do not receive a new topology");
            byte[] key1 = HotRodMagicKeyGenerator$.MODULE$.newKey((Cache<Object, Object>)this.cache(0, this.cacheName()));
            resp = client1.put(key1, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)3, topologyId);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            Assert.assertFalse((boolean)resp.topologyResponse().isDefined());
            this.log.trace((Object)"Check that the clients can access a key for which the storage-only node is primary owner");
            byte[] key2 = HotRodMagicKeyGenerator$.MODULE$.newKey((Cache<Object, Object>)this.cache(2, this.cacheName()));
            resp = client1.put(key2, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)3, topologyId);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            Assert.assertFalse((boolean)resp.topologyResponse().isDefined());
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(key1, 0), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(key2, 0), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
            this.log.trace((Object)"Force a topology change by shutting down one of the proper HotRod servers");
            ServerTestingUtil$.MODULE$.killServer((AbstractProtocolServer)server2);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{((AbstractProtocolServer)this.servers().last()).getCacheManager()});
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(2)});
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(2, this.cacheName())});
            resp = client1.put(key1, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)3, topologyId);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HotRodServer[]{server1})), this.cacheName(), 2, this.virtualNodes());
            topologyId = ((AbstractTopologyResponse)resp.topologyResponse().get()).viewId();
        }
        catch (Throwable throwable) {
            void var8_8;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{var8_8});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{newCacheManager});
        this.log.trace((Object)"Check that only the topology id changes after the storage-only server is killed");
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)3, topologyId);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HotRodServer[]{server1})), this.cacheName(), 2, this.virtualNodes());
        HotRodTestingUtil$.MODULE$.assertSuccess(client1.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
    }
}

