/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.Properties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.LegacyLoaderConfiguration;
import org.infinispan.loaders.cluster.ClusterCacheLoader;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012a\u0006;fgR,6/\u001a:EK\u001aLg.\u001a3US6,w.\u001e;t+\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRDQa\t\u0001\u0005\u0002m\tA\u0003^3ti2\u000b'0\u001f'pC\u0012$v\u000e]8m_\u001eL\b\"B\u0013\u0001\t\u00131\u0013aE<ji\"\u001cE.^:uKJ,GmU3sm\u0016\u0014HCA\u00149)\ta\u0002\u0006C\u0003*I\u0001\u0007!&\u0001\u0004bgN,'\u000f\u001e\t\u0006;-jS\u0007H\u0005\u0003Yy\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!B2bG\",'B\u0001\u001a\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011Ag\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005u1\u0014BA\u001c\u001f\u0005\u0011auN\\4\t\u000be\"\u0003\u0019\u0001\u001e\u0002\u000bA\u0014x\u000e]:\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0002\u0012\u0001B;uS2L!a\u0010\u001f\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u000b\u0004\u0001\u0003&SUJ\u0014\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b1\"\u00198o_R\fG/[8og*\u0011a\tC\u0001\u0007i\u0016\u001cHO\\4\n\u0005!\u001b%\u0001\u0002+fgR\faa\u001a:pkB\u001cH&A&\"\u00031\u000b!BZ;oGRLwN\\1m\u0003!!Xm\u001d;OC6,\u0017%A(\u0002KM,'O^3s]!|GO]8e]!{GOU8e\u0007>tg-[4ve\u0006$\u0018n\u001c8UKN$\b")
public class HotRodConfigurationTest {
    public void testUserDefinedTimeouts() {
        Properties props = new Properties();
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_LOCK_TIMEOUT(), "26000");
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_REPL_TIMEOUT(), "31000");
        this.withClusteredServer(props, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.loaders().cacheLoaders().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        Properties props = new Properties();
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_STATE_TRANSFER(), "false");
        props.setProperty(Main$.MODULE$.PROP_KEY_TOPOLOGY_REPL_TIMEOUT(), "43000");
        this.withClusteredServer(props, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                LegacyLoaderConfiguration clcfg = (LegacyLoaderConfiguration)cfg.loaders().cacheLoaders().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((String)clcfg.cacheLoader().getClass().getName(), (String)ClusterCacheLoader.class.getName());
                Assert.assertEquals(clcfg.properties().get("remoteCallTimeout"), (Object)"43000");
            }
        });
    }

    private void withClusteredServer(Properties props, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager(), (Function1)new Serializable(this, props, function2){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;
            public final Function2 assert$1;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.props$1), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$withClusteredServer$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(AbstractProtocolServer server) {
                        Configuration cfg = this.cm$1.getCache(HotRodServer$.MODULE$.ADDRESS_CACHE_NAME()).getCacheConfiguration();
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.props$1 = props$1;
                this.assert$1 = assert$1;
            }
        });
    }
}

