/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.None$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.HotRodDistributionTest")
@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u0017\t1\u0002j\u001c;S_\u0012$\u0015n\u001d;sS\n,H/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003'!{GOU8e\u001bVdG/\u001b(pI\u0016$Vm\u001d;\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002CA\u0007\u0001\u0011\u0015)\u0002\u0001\"\u0015\u0017\u0003%\u0019\u0017m\u00195f\u001d\u0006lW-F\u0001\u0018!\tAbD\u0004\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u001b\u0011\u0015\u0011\u0003\u0001\"\u0015$\u0003E\u0019'/Z1uK\u000e\u000b7\r[3D_:4\u0017nZ\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\u0011qEB\u0001\u0007G>tg-[4\n\u0005%2#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003,\u0001\u0011EC&A\bqe>$xnY8m-\u0016\u00148/[8o+\u0005i\u0003CA\r/\u0013\ty#D\u0001\u0003CsR,\u0007\"B\u0019\u0001\t\u0003\u0011\u0014!\n;fgR$\u0015n\u001d;sS\n,H/\u001a3QkR<\u0016\u000e\u001e5U_B|Gn\\4z\u0007\"\fgnZ3t)\t\u0019d\u0007\u0005\u0002\u001ai%\u0011QG\u0007\u0002\u0005+:LG\u000fC\u00038a\u0001\u0007\u0001(A\u0001n!\tI\u0004)D\u0001;\u0015\tYD(A\u0004sK\u001adWm\u0019;\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002Bu\t1Q*\u001a;i_\u0012Dc\u0001A\"L\u0019>\u0003\u0006C\u0001#J\u001b\u0005)%B\u0001$H\u0003-\tgN\\8uCRLwN\\:\u000b\u0005!C\u0011A\u0002;fgRtw-\u0003\u0002K\u000b\n!A+Z:u\u0003\u00199'o\\;qg2\nQ*I\u0001O\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\n\u0011+\u0001\u0013tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000e\u001a#jgR\u0014\u0018NY;uS>tG+Z:u\u0001")
public class HotRodDistributionTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodDistSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration createCacheConfig() {
        void var1_1;
        Configuration cfg = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        cfg.fluent().l1().disable();
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    public void testDistributedPutWithTopologyChanges(Method m) {
        HotRodClient client1 = (HotRodClient)this.clients().head();
        HotRodClient client2 = (HotRodClient)((IterableLike)this.clients().tail()).head();
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)3, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        HotRodServer hotRodServer = newServer;
        List allServers = this.servers().$colon$colon((Object)hotRodServer);
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        try {
            this.log.trace((Object)"New client started, modify key to be v6-*");
            resp = newClient.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)3, 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName());
            this.log.trace((Object)"Get key and verify that's v6-*");
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
            resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)3, 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName());
            HotRodTestingUtil$.MODULE$.assertSuccess(newClient.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        }
        catch (Throwable throwable) {
            void var9_9;
            void var5_5;
            void var6_6;
            this.log.trace((Object)"Stopping new server");
            HotRodTestingUtil$.MODULE$.killClient((HotRodClient)var6_6);
            this.stopClusteredServer((HotRodServer)var5_5);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval((Seq<CountDownLatch>)var9_9);
            this.log.trace((Object)"New server stopped");
            throw throwable;
        }
        this.log.trace((Object)"Stopping new server");
        HotRodTestingUtil$.MODULE$.killClient(newClient);
        this.stopClusteredServer(newServer);
        HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        this.log.trace((Object)"New server stopped");
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology10Received((AbstractTopologyResponse)resp.topologyResponse().get(), this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(client1.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }
}

