/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.None$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0017\t)\u0002j\u001c;S_\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0019Aw\u000e\u001e:pI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0014\u0011>$(k\u001c3Nk2$\u0018NT8eKR+7\u000f\u001e\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"!\u0004\u0001\t\u000bU\u0001A\u0011\u000b\f\u0002\u0013\r\f7\r[3OC6,W#A\f\u0011\u0005aqbBA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\u0012A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!\b\u000e\t\u000b\t\u0002A\u0011K\u0012\u0002#\r\u0014X-\u0019;f\u0007\u0006\u001c\u0007.Z\"p]\u001aLw-F\u0001%!\t)#&D\u0001'\u0015\t9\u0003&A\u0003dC\u000eDWM\u0003\u0002*\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\u000b\u0014\u0003)\r{gNZ5hkJ\fG/[8o\u0005VLG\u000eZ3s\u0011\u0015i\u0003\u0001\"\u0015/\u0003=\u0001(o\u001c;pG>dg+\u001a:tS>tW#A\u0018\u0011\u0005e\u0001\u0014BA\u0019\u001b\u0005\u0011\u0011\u0015\u0010^3\t\u000bM\u0002A\u0011\u0001\u001b\u0002#Q,7\u000f\u001e*fa2L7-\u0019;fIB+H\u000f\u0006\u00026qA\u0011\u0011DN\u0005\u0003oi\u0011A!\u00168ji\")\u0011H\ra\u0001u\u0005\tQ\u000e\u0005\u0002<\u00056\tAH\u0003\u0002>}\u00059!/\u001a4mK\u000e$(BA A\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\u000bAA[1wC&\u00111\t\u0010\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000b\u0015\u0003A\u0011\u0001$\u00023Q,7\u000f\u001e*fa2L7-\u0019;fIB+H/\u00134BEN,g\u000e\u001e\u000b\u0003k\u001dCQ!\u000f#A\u0002iBQ!\u0013\u0001\u0005\u0002)\u000bQ\u0003^3tiJ+\u0007\u000f\\5dCR,GMU3qY\u0006\u001cW\r\u0006\u00026\u0017\")\u0011\b\u0013a\u0001u!)Q\n\u0001C\u0001\u001d\u0006yB/Z:u!&twmV5uQR{\u0007o\u001c7pOf\fu/\u0019:f\u00072LWM\u001c;\u0015\u0003UBQ\u0001\u0015\u0001\u0005\u0002E\u000bA\u0005^3tiJ+\u0007\u000f\\5dCR,G\rU;u/&$\b\u000eV8q_2|w-_\"iC:<Wm\u001d\u000b\u0003kICQ!O(A\u0002iBc\u0001\u0001+];\u0002\f\u0007CA+[\u001b\u00051&BA,Y\u0003-\tgN\\8uCRLwN\\:\u000b\u0005eC\u0011A\u0002;fgRtw-\u0003\u0002\\-\n!A+Z:u\u0003\u00199'o\\;qg2\na,I\u0001`\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\n!-A\u0012tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000e\u001a*fa2L7-\u0019;j_:$Vm\u001d;")
public class HotRodReplicationTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodReplSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder config = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 10;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)this.clients().head()).assertGet(m));
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m));
        TestResponse resp = ((HotRodClient)this.clients().head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(((HotRodClient)((IterableLike)this.clients().tail()).head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-")), OperationStatus$.MODULE$.OperationNotExecuted());
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        ((HotRodClient)((IterableLike)this.clients().tail()).head()).assertPut(m);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)this.clients().head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)this.clients().head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.cacheName(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.cacheName(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        void var4_4;
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.cacheName(), this.servers());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTopologyResponse)resp.topologyResponse().get(), this.cacheName(), this.servers());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        Seq<CountDownLatch> addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        try {
            TestResponse resp2 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)2, 1);
            HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp2.topologyResponse().get()).topologyId(), this.cacheName(), (EmbeddedCacheManager)this.cacheManagers.get(0));
            TestTopologyAwareResponse topoResp = resp2.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp.members().size(), (int)3);
            ServerAddress serverAddress = newServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$1) {
                    return x$1.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp){
                public static final long serialVersionUID = 0L;
                private final TestTopologyAwareResponse topoResp$2;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)this.topoResp$2.members().exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$1;

                        public final boolean apply(ServerAddress x$3) {
                            ServerAddress serverAddress = x$3;
                            ServerAddress serverAddress2 = this.addr$1;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$1 = addr$1;
                        }
                    }));
                }
                {
                    this.topoResp$2 = topoResp$2;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
            this.stopClusteredServer(newServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
        catch (Throwable throwable) {
            void var3_3;
            this.stopClusteredServer((HotRodServer)var3_3);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval((Seq<CountDownLatch>)var4_4);
            throw throwable;
        }
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).topologyId(), this.cacheName(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        ObjectRef topoResp = new ObjectRef((Object)resp.asTopologyAwareResponse());
        Assert.assertEquals((int)((TestTopologyAwareResponse)((Object)topoResp.elem)).members().size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$4) {
                return x$4.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)((TestTopologyAwareResponse)((Object)this.topoResp$1.elem)).members().exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$2;

                    public final boolean apply(ServerAddress x$5) {
                        ServerAddress serverAddress = x$5;
                        ServerAddress serverAddress2 = this.addr$2;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$2 = addr$2;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25, true);
        addressRemovalLatches = HotRodTestingUtil$.MODULE$.getAddressCacheRemovalLatches(this.servers());
        try {
            TestResponse resp3 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)2, 3);
            HotRodTestingUtil$.MODULE$.assertStatus(resp3, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp3.topologyResponse().get()).topologyId(), this.cacheName(), (EmbeddedCacheManager)this.cacheManagers.get(0));
            TestTopologyAwareResponse topoResp2 = resp3.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp2.members().size(), (int)3);
            ServerAddress serverAddress = crashingServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$6) {
                    return x$6.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp2){
                public static final long serialVersionUID = 0L;
                private final TestTopologyAwareResponse topoResp$3;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)this.topoResp$3.members().exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$3;

                        public final boolean apply(ServerAddress x$8) {
                            ServerAddress serverAddress = x$8;
                            ServerAddress serverAddress2 = this.addr$3;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$3 = addr$3;
                        }
                    }));
                }
                {
                    this.topoResp$3 = topoResp$3;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
            this.stopClusteredServer(crashingServer);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval(addressRemovalLatches);
        }
        catch (Throwable throwable) {
            void var10_9;
            this.stopClusteredServer((HotRodServer)var10_9);
            HotRodTestingUtil$.MODULE$.waitAddressCacheRemoval((Seq<CountDownLatch>)var4_4);
            throw throwable;
        }
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)2, 4);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).topologyId(), this.cacheName(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        topoResp.elem = resp.asTopologyAwareResponse();
        Assert.assertEquals((int)((TestTopologyAwareResponse)((Object)topoResp.elem)).members().size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$9) {
                return x$9.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)((TestTopologyAwareResponse)((Object)this.topoResp$1.elem)).members().exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$4;

                    public final boolean apply(ServerAddress x$10) {
                        ServerAddress serverAddress = x$10;
                        ServerAddress serverAddress2 = this.addr$4;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$4 = addr$4;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        TestHashDistAware10Response hashTopologyResp = (TestHashDistAware10Response)((Object)resp.topologyResponse().get());
        HotRodTestingUtil$.MODULE$.assertTopologyId(((AbstractTopologyResponse)resp.topologyResponse().get()).topologyId(), this.cacheName(), (EmbeddedCacheManager)this.cacheManagers.get(0));
        Assert.assertEquals((int)hashTopologyResp.members().size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$11) {
                return x$11.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, hashTopologyResp){
            public static final long serialVersionUID = 0L;
            private final TestHashDistAware10Response hashTopologyResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)this.hashTopologyResp$1.members().exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$5;

                    public final boolean apply(ServerAddress x$12) {
                        ServerAddress serverAddress = x$12;
                        ServerAddress serverAddress2 = this.addr$5;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$5 = addr$5;
                    }
                }));
            }
            {
                this.hashTopologyResp$1 = hashTopologyResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertReplicatedHashIds(hashTopologyResp.hashIds(), this.servers(), this.cacheName());
        Assert.assertEquals((int)hashTopologyResp.numOwners(), (int)0);
        Assert.assertEquals((int)hashTopologyResp.hashFunction(), (int)0);
        Assert.assertEquals((int)hashTopologyResp.hashSpace(), (int)0);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }
}

