/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.None$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001-\u0011Q\u0003S8u%>$'+\u001a9mS\u000e\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003'!{GOU8e\u001bVdG/\u001b(pI\u0016$Vm\u001d;\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002CA\u0007\u0001\u0011\u0015)\u0002\u0001\"\u0015\u0017\u0003%\u0019\u0017m\u00195f\u001d\u0006lW-F\u0001\u0018!\tAbD\u0004\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u001b\u0011\u0015\u0011\u0003\u0001\"\u0015$\u0003E\u0019'/Z1uK\u000e\u000b7\r[3D_:4\u0017nZ\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003S\u0019\tQbY8oM&<WO]1uS>t\u0017BA\u0016'\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\")Q\u0006\u0001C)]\u0005y\u0001O]8u_\u000e|GNV3sg&|g.F\u00010!\tI\u0002'\u0003\u000225\t!!)\u001f;f\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003E!Xm\u001d;SKBd\u0017nY1uK\u0012\u0004V\u000f\u001e\u000b\u0003ka\u0002\"!\u0007\u001c\n\u0005]R\"\u0001B+oSRDQ!\u000f\u001aA\u0002i\n\u0011!\u001c\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\nqA]3gY\u0016\u001cGO\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011\u001f\u0003\r5+G\u000f[8e\u0011\u0015)\u0005\u0001\"\u0001G\u0003e!Xm\u001d;SKBd\u0017nY1uK\u0012\u0004V\u000f^%g\u0003\n\u001cXM\u001c;\u0015\u0005U:\u0005\"B\u001dE\u0001\u0004Q\u0004\"B%\u0001\t\u0003Q\u0015!\u0006;fgR\u0014V\r\u001d7jG\u0006$X\r\u001a*fa2\f7-\u001a\u000b\u0003k-CQ!\u000f%A\u0002iBQ!\u0014\u0001\u0005\u00029\u000bq\u0004^3tiBKgnZ,ji\"$v\u000e]8m_\u001eL\u0018i^1sK\u000ec\u0017.\u001a8u)\u0005)\u0004\"\u0002)\u0001\t\u0003\t\u0016\u0001\n;fgR\u0014V\r\u001d7jG\u0006$X\r\u001a)vi^KG\u000f\u001b+pa>dwnZ=DQ\u0006tw-Z:\u0015\u0005U\u0012\u0006\"B\u001dP\u0001\u0004Q\u0004\"\u0002+\u0001\t#)\u0016!F2iK\u000e\\Gk\u001c9pY><\u0017PU3dK&4X\r\u001a\u000b\u0005kYsv\u000eC\u0003X'\u0002\u0007\u0001,\u0001\u0005u_B|'+Z:q!\tIF,D\u0001[\u0015\tY&!\u0001\u0003uKN$\u0018BA/[\u0005\u0005\n%m\u001d;sC\u000e$H+Z:u)>\u0004x\u000e\\8hs\u0006;\u0018M]3SKN\u0004xN\\:f\u0011\u0015y6\u000b1\u0001a\u0003\u001d\u0019XM\u001d<feN\u00042!Y5m\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002f\u0015\u00051AH]8pizJ\u0011aG\u0005\u0003Qj\tq\u0001]1dW\u0006<W-\u0003\u0002kW\n!A*[:u\u0015\tA'\u0004\u0005\u0002\u000e[&\u0011aN\u0001\u0002\r\u0011>$(k\u001c3TKJ4XM\u001d\u0005\u0006+M\u0003\ra\u0006\u0015\u0005'FL(\u0010\u0005\u0002so6\t1O\u0003\u0002uk\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\t1\b\"\u0001\u0004uKN$hnZ\u0005\u0003qN\u0014A\u0001V3ti\u00069QM\\1cY\u0016$\u0017$\u0001\u0001)\u0011\u0001\tH0`A\u0001\u0003\u0007\taa\u001a:pkB\u001cH&\u0001@\"\u0003}\f!BZ;oGRLwN\\1m\u0003!!Xm\u001d;OC6,\u0017EAA\u0003\u0003\r\u001aXM\u001d<fe:Bw\u000e\u001e:pI:Bu\u000e\u001e*pIJ+\u0007\u000f\\5dCRLwN\u001c+fgR\u0004")
public class HotRodReplicationTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodReplSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder config = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 10;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)this.clients().head()).assertGet(m));
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m));
        TestResponse resp = ((HotRodClient)this.clients().head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(((HotRodClient)((IterableLike)this.clients().tail()).head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-")), OperationStatus$.MODULE$.OperationNotExecuted());
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.OperationNotExecuted());
        ((HotRodClient)((IterableLike)this.clients().tail()).head()).assertPut(m);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)this.clients().head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        resp = ((HotRodClient)this.clients().head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        try {
            TestResponse resp2 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)2, 1);
            HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus$.MODULE$.Success());
            Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)resp2.topologyResponse().get()).topologyId(), (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp = resp2.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp.members().size(), (int)3);
            ServerAddress serverAddress = newServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$1) {
                    return x$1.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$2;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)this.topoResp$2.members().exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$1;

                        public final boolean apply(ServerAddress x$3) {
                            ServerAddress serverAddress = x$3;
                            ServerAddress serverAddress2 = this.addr$1;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$1 = addr$1;
                        }
                    }));
                }
                {
                    this.topoResp$2 = topoResp$2;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
            this.stopClusteredServer(newServer);
        }
        catch (Throwable throwable) {
            void var3_3;
            this.stopClusteredServer((HotRodServer)var3_3);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)2, 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)resp.topologyResponse().get()).topologyId(), (int)this.currentServerTopologyId());
        ObjectRef topoResp = new ObjectRef((Object)resp.asTopologyAwareResponse());
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members().size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$4) {
                return x$4.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members().exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$2;

                    public final boolean apply(ServerAddress x$5) {
                        ServerAddress serverAddress = x$5;
                        ServerAddress serverAddress2 = this.addr$2;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$2 = addr$2;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25, true);
        try {
            TestResponse resp3 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)2, 3);
            HotRodTestingUtil$.MODULE$.assertStatus(resp3, OperationStatus$.MODULE$.Success());
            Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)resp3.topologyResponse().get()).topologyId(), (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp2 = resp3.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp2.members().size(), (int)3);
            ServerAddress serverAddress = crashingServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$6) {
                    return x$6.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp2){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$3;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)this.topoResp$3.members().exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$3;

                        public final boolean apply(ServerAddress x$8) {
                            ServerAddress serverAddress = x$8;
                            ServerAddress serverAddress2 = this.addr$3;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$3 = addr$3;
                        }
                    }));
                }
                {
                    this.topoResp$3 = topoResp$3;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
            this.stopClusteredServer(crashingServer);
        }
        catch (Throwable throwable) {
            void var9_8;
            this.stopClusteredServer((HotRodServer)var9_8);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)2, 4);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)resp.topologyResponse().get()).topologyId(), (int)this.currentServerTopologyId());
        topoResp.elem = resp.asTopologyAwareResponse();
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members().size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$9) {
                return x$9.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members().exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$4;

                    public final boolean apply(ServerAddress x$10) {
                        ServerAddress serverAddress = x$10;
                        ServerAddress serverAddress2 = this.addr$4;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$4 = addr$4;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        this.checkTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }

    @Test(enabled=false)
    public void checkTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName) {
        HotRodTestingUtil$.MODULE$.assertNoHashTopologyReceived(topoResp, servers, cacheName, this.currentServerTopologyId());
    }
}

