/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil$;
import org.infinispan.server.hotrod.Constants$;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodMagicKeyGenerator$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11StorageOnlyNodesTest")
@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u0017\ta\u0002j\u001c;S_\u0012\f\u0014g\u0015;pe\u0006<Wm\u00148ms:{G-Z:UKN$(BA\u0002\u0005\u0003\u0019Aw\u000e\u001e:pI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0014\u0011>$(k\u001c3Nk2$\u0018NT8eKR+7\u000f\u001e\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"!\u0004\u0001\t\u000bU\u0001A\u0011\u000b\f\u0002\u0013\r\f7\r[3OC6,W#A\f\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t11\u000b\u001e:j]\u001eDQ\u0001\t\u0001\u0005R\u0005\n\u0011c\u0019:fCR,7)Y2iK\u000e{gNZ5h+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019\u0017m\u00195f\u0015\t9c!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003S\u0011\u0012AcQ8oM&<WO]1uS>t')^5mI\u0016\u0014\b\"B\u0016\u0001\t#b\u0013a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012AAQ=uK\")A\u0007\u0001C\tk\u0005aa/\u001b:uk\u0006dgj\u001c3fgV\ta\u0007\u0005\u0002/o%\u0011\u0001h\f\u0002\u0004\u0013:$\b\"\u0002\u001e\u0001\t\u0003Y\u0014!\u0007;fgR\fE\rZ5oON#xN]1hK>sG.\u001f(pI\u0016$\"\u0001P \u0011\u00059j\u0014B\u0001 0\u0005\u0011)f.\u001b;\t\u000b\u0001K\u0004\u0019A!\u0002\u00035\u0004\"AQ#\u000e\u0003\rS!\u0001R\r\u0002\u000fI,g\r\\3di&\u0011ai\u0011\u0002\u0007\u001b\u0016$\bn\u001c3)\r\u0001A\u0005+\u0015+V!\tIe*D\u0001K\u0015\tYE*A\u0006b]:|G/\u0019;j_:\u001c(BA'\t\u0003\u0019!Xm\u001d;oO&\u0011qJ\u0013\u0002\u0005)\u0016\u001cH/\u0001\u0004he>,\bo\u001d\u0017\u0002%\u0006\n1+\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0002-\u0006Q3/\u001a:wKJt\u0003n\u001c;s_\u0012t\u0003j\u001c;S_\u0012\f\u0014g\u0015;pe\u0006<Wm\u00148ms:{G-Z:UKN$\b")
public class HotRod11StorageOnlyNodesTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "distributed";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder cfg = HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfg.clustering().l1().disable();
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 11;
    }

    public int virtualNodes() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void testAddingStorageOnlyNode(Method m) {
        HotRodServer server1 = (HotRodServer)this.servers().head();
        HotRodServer server2 = (HotRodServer)this.servers().last();
        HotRodClient client1 = (HotRodClient)this.clients().head();
        HotRodClient client2 = (HotRodClient)this.clients().last();
        int initialTopologyId = this.currentServerTopologyId();
        TestResponse resp = client1.ping(Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes(), initialTopologyId);
        EmbeddedCacheManager newCacheManager = this.addClusterEnabledCacheManager();
        None$ leaveTopologyId = None$.MODULE$;
        try {
            newCacheManager.defineConfiguration(this.cacheName(), this.createCacheConfig().build());
            newCacheManager.getCache(this.cacheName());
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)true, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(1), this.manager(2)});
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName()), this.cache(2, this.cacheName())});
            int joinTopologyId = this.currentServerTopologyId();
            byte[] key1 = HotRodMagicKeyGenerator$.MODULE$.newKey((Cache<Object, Object>)this.cache(0, this.cacheName()));
            resp = client1.put(key1, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), initialTopologyId);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), 2, this.virtualNodes(), joinTopologyId - 1);
            this.log.trace((Object)"Check that the clients do not receive a new topology");
            resp = client1.put(key1, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), joinTopologyId - 1);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            Assert.assertFalse((boolean)resp.topologyResponse().isDefined());
            this.log.trace((Object)"Check that the clients can access a key for which the storage-only node is primary owner");
            byte[] key2 = HotRodMagicKeyGenerator$.MODULE$.newKey((Cache<Object, Object>)this.cache(2, this.cacheName()));
            resp = client1.put(key2, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), joinTopologyId - 1);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            Assert.assertFalse((boolean)resp.topologyResponse().isDefined());
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(key1, 0), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(key2, 0), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
            this.log.trace((Object)"Force a topology change by shutting down one of the proper HotRod servers");
            ServerTestingUtil$.MODULE$.killServer((AbstractProtocolServer)server2);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{((AbstractProtocolServer)this.servers().last()).getCacheManager()});
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(2)});
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(2, this.cacheName())});
            leaveTopologyId = new Some((Object)BoxesRunTime.boxToInteger((int)this.currentServerTopologyId()));
            resp = client1.put(key1, 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), joinTopologyId - 1);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), (List<HotRodServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HotRodServer[]{server1})), this.cacheName(), 2, this.virtualNodes(), BoxesRunTime.unboxToInt((Object)leaveTopologyId.get()) - 1);
        }
        catch (Throwable throwable) {
            void var8_8;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{var8_8});
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0)});
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName())});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{newCacheManager});
        TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0)});
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName())});
        int storageOnlyLeaveTopologyId = this.currentServerTopologyId();
        this.log.trace((Object)"Check that only the topology id changes after the storage-only server is killed");
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), BoxesRunTime.unboxToInt((Object)leaveTopologyId.get()) - 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), (List<HotRodServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HotRodServer[]{server1})), this.cacheName(), 2, 1, storageOnlyLeaveTopologyId);
        HotRodTestingUtil$.MODULE$.assertSuccess(client1.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
    }
}

