/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.configuration.cache.ClusterCacheLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012a\u0006;fgR,6/\u001a:EK\u001aLg.\u001a3US6,w.\u001e;t)\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRDQa\t\u0001\u0005\u0002m\tA\u0003^3ti2\u000b'0\u001f'pC\u0012$v\u000e]8m_\u001eL\b\"B\u0013\u0001\t\u00131\u0013aE<ji\"\u001cE.^:uKJ,GmU3sm\u0016\u0014HCA\u00149)\ta\u0002\u0006C\u0003*I\u0001\u0007!&\u0001\u0004bgN,'\u000f\u001e\t\u0006;-jS\u0007H\u0005\u0003Yy\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!B2bG\",'B\u0001\u001a\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011Ag\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005u1\u0014BA\u001c\u001f\u0005\u0011auN\\4\t\u000be\"\u0003\u0019\u0001\u001e\u0002\u000f\t,\u0018\u000e\u001c3feB\u00111(P\u0007\u0002y)\u0011!GA\u0005\u0003}q\u0012\u0001\u0005S8u%>$7+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\"2\u0001\u0001\u0011%J\u00196\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003\u000b\"\ta\u0001^3ti:<\u0017BA$C\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\u0005Q\u0015%A&\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\u0005q\u0015!J:feZ,'O\f5piJ|GM\f%piJ{GmQ8oM&<WO]1uS>tG+Z:u\u0001")
public class HotRodConfigurationTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.loaders().cacheLoaders().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                ClusterCacheLoaderConfiguration clcfg = (ClusterCacheLoaderConfiguration)cfg.loaders().cacheLoaders().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
            }
        });
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration()), (Function1)new Serializable(this, builder, function2){
            public static final long serialVersionUID = 0L;
            private final HotRodServerConfigurationBuilder builder$1;
            public final Function2 assert$1;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.builder$1), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$withClusteredServer$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(HotRodServer server) {
                        Configuration cfg = this.cm$1.getCache("___hotRodTopologyCache").getCacheConfiguration();
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
                this.assert$1 = assert$1;
            }
        });
    }
}

