/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestHashDistAware11Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestResponseWithPrevious;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ByteArrayEquivalence;
import org.infinispan.util.Util;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.testng.Assert;
import org.testng.AssertJUnit;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class HotRodTestingUtil$
implements Log {
    public static final HotRodTestingUtil$ MODULE$;
    private final byte EXPECTED_HASH_FUNCTION_VERSION;
    private final org.infinispan.server.hotrod.logging.JavaLog log;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile byte bitmap$0;

    static {
        new HotRodTestingUtil$();
    }

    private org.infinispan.server.hotrod.logging.JavaLog log$lzycompute() {
        HotRodTestingUtil$ hotRodTestingUtil$ = this;
        synchronized (hotRodTestingUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Log.class.log((Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.log;
        }
    }

    public org.infinispan.server.hotrod.logging.JavaLog log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    public void logViewNullWhileDetectingCrashedMember() {
        Log.class.logViewNullWhileDetectingCrashedMember((Log)this);
    }

    public void logUnableToUpdateView() {
        Log.class.logUnableToUpdateView((Log)this);
    }

    public void logErrorDetectingCrashedMember(Throwable t) {
        Log.class.logErrorDetectingCrashedMember((Log)this, (Throwable)t);
    }

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        HotRodTestingUtil$ hotRodTestingUtil$ = this;
        synchronized (hotRodTestingUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log.class.org$infinispan$server$core$logging$Log$$log((org.infinispan.server.core.logging.Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$infinispan$server$core$logging$Log$$log$lzycompute() : this.org$infinispan$server$core$logging$Log$$log;
    }

    public void info(Function0<String> msg) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void info(Function0<String> msg, Object param1) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void error(Function0<String> msg, Throwable t) {
        Log.class.error((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void warn(Function0<String> msg, Throwable t) {
        Log.class.warn((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void debug(Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void debug(Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void debug(Throwable t, Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg);
    }

    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg, (Object)param1);
    }

    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log.class.debugf((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public void trace(Function0<String> msg) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void trace(Function0<String> msg, Object param1) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2, (Object)param3);
    }

    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log.class.tracef((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Log.class.isDebugEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public boolean isTraceEnabled() {
        return Log.class.isTraceEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public void logStartWithArgs(String args) {
        Log.class.logStartWithArgs((org.infinispan.server.core.logging.Log)this, (String)args);
    }

    public void logPostingShutdownRequest() {
        Log.class.logPostingShutdownRequest((org.infinispan.server.core.logging.Log)this);
    }

    public void logExceptionReported(Throwable t) {
        Log.class.logExceptionReported((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logServerDidNotUnbind() {
        Log.class.logServerDidNotUnbind((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log.class.logChannelStillBound((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logServerDidNotClose() {
        Log.class.logServerDidNotClose((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log.class.logChannelStillConnected((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logSettingMasterThreadsNotSupported() {
        Log.class.logSettingMasterThreadsNotSupported((org.infinispan.server.core.logging.Log)this);
    }

    public void logErrorBeforeReadingRequest(Throwable t) {
        Log.class.logErrorBeforeReadingRequest((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public byte EXPECTED_HASH_FUNCTION_VERSION() {
        return this.EXPECTED_HASH_FUNCTION_VERSION;
    }

    public String host() {
        return "127.0.0.1";
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager) {
        return this.startHotRodServer(manager, Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())));
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), 0, proxyHost, proxyPort);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port) {
        return this.startHotRodServer(manager, port, 0);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, port, 0, proxyHost, proxyPort);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout) {
        return this.startHotRodServer(manager, port, idleTimeout, this.host(), port);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, port, idleTimeout, proxyHost, proxyPort, -1L);
    }

    public HotRodServer startHotRodServerWithDelay(EmbeddedCacheManager manager, int port, long delay) {
        return this.startHotRodServer(manager, port, 0, this.host(), port, delay);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort, long delay) {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.proxyHost(proxyHost).proxyPort(proxyPort).idleTimeout(idleTimeout);
        return this.startHotRodServer(manager, port, delay, builder);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, HotRodServerConfigurationBuilder builder) {
        return this.startHotRodServer(manager, port, 0L, builder);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, long delay, HotRodServerConfigurationBuilder builder) {
        this.info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Start server in port %d";
            }
        }, BoxesRunTime.boxToInteger((int)port));
        HotRodServer server = new HotRodServer(delay){
            private final long delay$1;

            /*
             * WARNING - void declaration
             */
            public ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
                void var3_2;
                if (this.delay$1 > 0L) {
                    Thread.sleep(this.delay$1);
                }
                ConfigurationBuilder cfg = super.createTopologyCacheConfig(distSyncTimeout);
                cfg.transaction().syncCommitPhase(false).syncRollbackPhase(false);
                return var3_2;
            }
            {
                this.delay$1 = delay$1;
            }
        };
        ((ProtocolServerConfigurationBuilder)((ProtocolServerConfigurationBuilder)builder.host(this.host())).port(port)).workerThreads(2);
        server.start(builder.build(), manager);
        return server;
    }

    /*
     * WARNING - void declaration
     */
    public HotRodServer startCrashingHotRodServer(EmbeddedCacheManager manager, int port) {
        void var3_3;
        HotRodServer server = new HotRodServer(){

            /*
             * WARNING - void declaration
             */
            public ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
                void var3_2;
                ConfigurationBuilder cfg = super.createTopologyCacheConfig(distSyncTimeout);
                cfg.transaction().syncCommitPhase(false).syncRollbackPhase(false);
                return var3_2;
            }
        };
        server.start(((HotRodServerConfigurationBuilder)((ProtocolServerConfigurationBuilder)((ProtocolServerConfigurationBuilder)new HotRodServerConfigurationBuilder().proxyHost(this.host()).proxyPort(port).host(this.host())).port(port)).idleTimeout(0)).build(), manager);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] k(Method m, String prefix) {
        void var3_3;
        byte[] bytes = new StringBuilder().append((Object)prefix).append((Object)m.getName()).toString().getBytes();
        this.trace((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "String %s is converted to %s bytes";
            }
        }, new StringBuilder().append((Object)prefix).append((Object)m.getName()).toString(), Util.printArray((byte[])bytes, (boolean)true));
        return var3_3;
    }

    public byte[] v(Method m, String prefix) {
        return this.k(m, prefix);
    }

    public byte[] k(Method m) {
        return this.k(m, "k-");
    }

    public byte[] v(Method m) {
        return this.v(m, "v-");
    }

    public boolean assertStatus(TestResponse resp, Enumeration.Value expected) {
        Enumeration.Value status;
        Enumeration.Value value = status = resp.status();
        Enumeration.Value value2 = expected;
        boolean isSuccess = !(value != null ? !value.equals(value2) : value2 != null);
        TestResponse testResponse = resp;
        if (testResponse instanceof TestErrorResponse) {
            TestErrorResponse x2 = (TestErrorResponse)testResponse;
            Assert.assertTrue((boolean)isSuccess, (String)new StringOps(Predef$.MODULE$.augmentString("Status should have been '%s' but instead was: '%s', and the error message was: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, status, x2.msg()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Assert.assertTrue((boolean)isSuccess, (String)new StringOps(Predef$.MODULE$.augmentString("Status should have been '%s' but instead was: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, status})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return isSuccess;
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertSuccess(TestGetResponse resp, byte[] expected) {
        void var3_3;
        this.assertStatus(resp, OperationStatus$.MODULE$.Success());
        boolean isArrayEquals = Arrays.equals(expected, (byte[])resp.data().get());
        Assert.assertTrue((boolean)isArrayEquals, (String)new StringBuilder().append((Object)"Retrieved data should have contained ").append((Object)Util.printArray((byte[])expected, (boolean)true)).append((Object)" (").append((Object)new String(expected)).append((Object)"), but instead we received ").append((Object)Util.printArray((byte[])((byte[])resp.data().get()), (boolean)true)).append((Object)" (").append((Object)new String((byte[])resp.data().get())).append((Object)")").toString());
        return (boolean)var3_3;
    }

    public boolean assertSuccess(TestGetWithVersionResponse resp, byte[] expected, int expectedVersion) {
        Assert.assertTrue((resp.version() != expectedVersion ? 1 : 0) != 0);
        return this.assertSuccess(resp, expected);
    }

    public boolean assertSuccess(TestGetWithMetadataResponse resp, byte[] expected, int expectedLifespan, int expectedMaxIdle) {
        AssertJUnit.assertEquals((int)resp.lifespan(), (int)expectedLifespan);
        AssertJUnit.assertEquals((int)resp.maxIdle(), (int)expectedMaxIdle);
        return this.assertSuccess(resp, expected);
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertSuccess(TestResponseWithPrevious resp, byte[] expected) {
        void var3_3;
        this.assertStatus(resp, OperationStatus$.MODULE$.Success());
        boolean isSuccess = Arrays.equals(expected, (byte[])resp.previous().get());
        Assert.assertTrue((boolean)isSuccess);
        return (boolean)var3_3;
    }

    public boolean assertKeyDoesNotExist(TestGetResponse resp) {
        Enumeration.Value status;
        Enumeration.Value value = status = resp.status();
        Enumeration.Value value2 = OperationStatus$.MODULE$.KeyDoesNotExist();
        Assert.assertTrue((!(value != null ? !value.equals(value2) : value2 != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Status should have been 'KeyDoesNotExist' but instead was: ").append((Object)status).toString());
        AssertJUnit.assertEquals(resp.data(), (Object)None$.MODULE$);
        Enumeration.Value value3 = status;
        Enumeration.Value value4 = OperationStatus$.MODULE$.KeyDoesNotExist();
        return !(value3 != null ? !value3.equals(value4) : value4 != null);
    }

    public void assertTopologyReceived(AbstractTestTopologyAwareResponse resp, List<HotRodServer> servers, int expectedTopologyId) {
        AbstractTestTopologyAwareResponse abstractTestTopologyAwareResponse;
        block5: {
            block3: {
                block4: {
                    block2: {
                        AssertJUnit.assertEquals((int)resp.topologyId(), (int)expectedTopologyId);
                        abstractTestTopologyAwareResponse = resp;
                        if (!(abstractTestTopologyAwareResponse instanceof TestHashDistAware10Response)) break block2;
                        TestHashDistAware10Response x2 = (TestHashDistAware10Response)abstractTestTopologyAwareResponse;
                        AssertJUnit.assertEquals((int)x2.members().size(), (int)servers.size());
                        AssertJUnit.assertEquals((Object)x2.members().toSet(), (Object)((TraversableOnce)servers.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final ServerAddress apply(HotRodServer x$1) {
                                return x$1.getAddress();
                            }
                        }, List$.MODULE$.canBuildFrom())).toSet());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(abstractTestTopologyAwareResponse instanceof TestHashDistAware11Response)) break block4;
                    TestHashDistAware11Response x3 = (TestHashDistAware11Response)abstractTestTopologyAwareResponse;
                    AssertJUnit.assertEquals((int)x3.membersToHash().size(), (int)servers.size());
                    AssertJUnit.assertEquals((Object)x3.membersToHash().keySet(), (Object)((TraversableOnce)servers.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final ServerAddress apply(HotRodServer x$2) {
                            return x$2.getAddress();
                        }
                    }, List$.MODULE$.canBuildFrom())).toSet());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(abstractTestTopologyAwareResponse instanceof TestTopologyAwareResponse)) break block5;
                TestTopologyAwareResponse x4 = (TestTopologyAwareResponse)abstractTestTopologyAwareResponse;
                AssertJUnit.assertEquals((int)x4.members().size(), (int)servers.size());
                AssertJUnit.assertEquals((Object)x4.members().toSet(), (Object)((TraversableOnce)servers.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ServerAddress apply(HotRodServer x$3) {
                        return x$3.getAddress();
                    }
                }, List$.MODULE$.canBuildFrom())).toSet());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)abstractTestTopologyAwareResponse);
    }

    public void assertHashTopology10Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        this.assertHashTopology10Received(topoResp, servers, cacheName, 2, this.EXPECTED_HASH_FUNCTION_VERSION(), Integer.MAX_VALUE, expectedTopologyId);
    }

    public void assertNoHashTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        this.assertHashTopology10Received(topoResp, servers, cacheName, 0, 0, 0, expectedTopologyId);
    }

    public void assertHashTopology10Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedNumOwners, int expectedHashFct, int expectedHashSpace, int expectedTopologyId) {
        TestHashDistAware10Response hashTopologyResp = (TestHashDistAware10Response)topoResp;
        AssertJUnit.assertEquals((int)hashTopologyResp.topologyId(), (int)expectedTopologyId);
        AssertJUnit.assertEquals((int)hashTopologyResp.members().size(), (int)servers.size());
        hashTopologyResp.members().foreach((Function1)new Serializable(servers){
            public static final long serialVersionUID = 0L;
            private final List servers$2;

            public final boolean apply(ServerAddress member) {
                return ((LinearSeqOptimized)this.servers$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ServerAddress apply(HotRodServer x$4) {
                        return x$4.getAddress();
                    }
                }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress member$1;

                    public final boolean apply(ServerAddress x$5) {
                        ServerAddress serverAddress = x$5;
                        ServerAddress serverAddress2 = this.member$1;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.member$1 = member$1;
                    }
                });
            }
            {
                this.servers$2 = servers$2;
            }
        });
        AssertJUnit.assertEquals((int)hashTopologyResp.numOwners(), (int)expectedNumOwners);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashFunction(), (int)expectedHashFct);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashSpace(), (int)expectedHashSpace);
        if (expectedNumOwners != 0) {
            this.assertHashIds(hashTopologyResp.hashIds(), servers, cacheName);
        }
    }

    public void assertHashTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedNumOwners, int expectedVirtualNodes, int expectedTopologyId) {
        TestHashDistAware11Response hashTopologyResp = (TestHashDistAware11Response)topoResp;
        AssertJUnit.assertEquals((int)hashTopologyResp.topologyId(), (int)expectedTopologyId);
        AssertJUnit.assertEquals((int)hashTopologyResp.membersToHash().size(), (int)servers.size());
        hashTopologyResp.membersToHash().foreach((Function1)new Serializable(servers){
            public static final long serialVersionUID = 0L;
            private final List servers$1;

            public final boolean apply(Tuple2<ServerAddress, Object> member) {
                return ((LinearSeqOptimized)this.servers$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ServerAddress apply(HotRodServer x$6) {
                        return x$6.getAddress();
                    }
                }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 member$2;

                    public final boolean apply(ServerAddress x$7) {
                        ServerAddress serverAddress = x$7;
                        Tuple2 tuple2 = this.member$2;
                        return !(serverAddress != null ? !serverAddress.equals(tuple2) : tuple2 != null);
                    }
                    {
                        this.member$2 = member$2;
                    }
                });
            }
            {
                this.servers$1 = servers$1;
            }
        });
        AssertJUnit.assertEquals((int)hashTopologyResp.numOwners(), (int)expectedNumOwners);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashFunction(), (int)(expectedNumOwners != 0 ? this.EXPECTED_HASH_FUNCTION_VERSION() : (byte)0));
        AssertJUnit.assertEquals((int)hashTopologyResp.hashSpace(), (int)(expectedNumOwners != 0 ? Integer.MAX_VALUE : 0));
        AssertJUnit.assertEquals((int)hashTopologyResp.numVirtualNodes(), (int)expectedVirtualNodes);
    }

    public void assertHashIds(Map<ServerAddress, Seq<Object>> hashIds, List<HotRodServer> servers, String cacheName) {
        Cache cache = ((AbstractProtocolServer)servers.head()).getCacheManager().getCache(cacheName);
        StateTransferManager stateTransferManager = (StateTransferManager)TestingUtil.extractComponent((Cache)cache, StateTransferManager.class);
        ConsistentHash consistentHash = stateTransferManager.getCacheTopology().getCurrentCH();
        int numSegments = consistentHash.getNumSegments();
        int numOwners = consistentHash.getNumOwners();
        AssertJUnit.assertEquals((int)hashIds.size(), (int)servers.size());
        int segmentSize = (int)package$.MODULE$.ceil((double)Integer.MAX_VALUE / (double)numSegments);
        scala.collection.mutable.Map[] owners = new scala.collection.mutable.Map[numSegments];
        hashIds.foreach((Function1)new Serializable(numSegments, segmentSize, owners){
            public static final long serialVersionUID = 0L;
            public final int numSegments$1;
            public final int segmentSize$1;
            public final scala.collection.mutable.Map[] owners$1;

            public final void apply(Tuple2<ServerAddress, Seq<Object>> x$8) {
                Tuple2<ServerAddress, Seq<Object>> tuple2 = x$8;
                if (tuple2 != null) {
                    ServerAddress serverAddress = (ServerAddress)tuple2._1();
                    Seq serverHashIds = (Seq)tuple2._2();
                    serverHashIds.foreach((Function1)new Serializable(this, serverAddress){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.assertHashIds.2 $outer;
                        private final ServerAddress serverAddress$1;

                        public final scala.collection.mutable.Map<Object, ServerAddress> apply(int hashId) {
                            int segmentIdx = (hashId / this.$outer.segmentSize$1 + this.$outer.numSegments$1 - 1) % this.$outer.numSegments$1;
                            int ownerIdx = hashId % this.$outer.segmentSize$1;
                            if (this.$outer.owners$1[segmentIdx] == null) {
                                this.$outer.owners$1[segmentIdx] = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                            return (scala.collection.mutable.Map)this.$outer.owners$1[segmentIdx].$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ownerIdx)), (Object)this.serverAddress$1));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.serverAddress$1 = serverAddress$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.numSegments$1 = numSegments$1;
                this.segmentSize$1 = segmentSize$1;
                this.owners$1 = owners$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(servers, consistentHash, numOwners, owners){
            public static final long serialVersionUID = 0L;
            public final List servers$3;
            private final ConsistentHash consistentHash$1;
            private final int numOwners$1;
            private final scala.collection.mutable.Map[] owners$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                List segmentOwners = (List)((TraversableLike)this.owners$1[v1].toList().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, ServerAddress> x$9) {
                        return x$9._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ServerAddress apply(Tuple2<Object, ServerAddress> x$10) {
                        return (ServerAddress)x$10._2();
                    }
                }, List$.MODULE$.canBuildFrom());
                AssertJUnit.assertEquals((int)segmentOwners.size(), (int)this.numOwners$1);
                Buffer chOwners = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.consistentHash$1.locateOwnersForSegment(v1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assertHashIds.1 $outer;

                    public final ServerAddress apply(Address a) {
                        return HotRodTestingUtil$.MODULE$.clusterAddressToServerAddress((List<HotRodServer>)this.$outer.servers$3, a);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                AssertJUnit.assertEquals((Object)segmentOwners, (Object)chOwners);
            }
            {
                this.servers$3 = servers$3;
                this.consistentHash$1 = consistentHash$1;
                this.numOwners$1 = numOwners$1;
                this.owners$1 = owners$1;
            }
        });
    }

    public void assertReplicatedHashIds(Map<ServerAddress, Seq<Object>> hashIds, List<HotRodServer> servers, String cacheName) {
        Cache cache = ((AbstractProtocolServer)servers.head()).getCacheManager().getCache(cacheName);
        StateTransferManager stateTransferManager = (StateTransferManager)TestingUtil.extractComponent((Cache)cache, StateTransferManager.class);
        ConsistentHash consistentHash = stateTransferManager.getCacheTopology().getCurrentCH();
        int numSegments = consistentHash.getNumSegments();
        int numOwners = consistentHash.getNumOwners();
        AssertJUnit.assertEquals((int)hashIds.size(), (int)servers.size());
        AssertJUnit.assertEquals((int)numSegments, (int)1);
        hashIds.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<ServerAddress, Seq<Object>> x$11) {
                Tuple2<ServerAddress, Seq<Object>> tuple2 = x$11;
                if (tuple2 != null) {
                    ServerAddress serverAddress = (ServerAddress)tuple2._1();
                    Seq serverHashIds = (Seq)tuple2._2();
                    AssertJUnit.assertEquals((int)serverHashIds.size(), (int)1);
                    AssertJUnit.assertEquals((int)BoxesRunTime.unboxToInt((Object)serverHashIds.apply(0)), (int)0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public ServerAddress clusterAddressToServerAddress(List<HotRodServer> servers, Address clusterAddress) {
        return ((HotRodServer)servers.find((Function1)new Serializable(clusterAddress){
            public static final long serialVersionUID = 0L;
            private final Address clusterAddress$1;

            public final boolean apply(HotRodServer x$12) {
                Address address = x$12.getCacheManager().getAddress();
                Address address2 = this.clusterAddress$1;
                return !(address != null ? !address.equals(address2) : address2 != null);
            }
            {
                this.clusterAddress$1 = clusterAddress$1;
            }
        }).get()).getAddress();
    }

    public int getServerTopologyId(EmbeddedCacheManager cm, String cacheName) {
        return cm.getCache(cacheName).getAdvancedCache().getRpcManager().getTopologyId();
    }

    public ChannelFuture killClient(HotRodClient client) {
        Object object;
        try {
            object = client == null ? null : client.stop();
        }
        catch (Throwable throwable) {
            this.error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error stopping client";
                }
            }, throwable);
            object = null;
        }
        return object;
    }

    public ConfigurationBuilder hotRodCacheConfiguration() {
        return this.hotRodCacheConfiguration(new ConfigurationBuilder());
    }

    public ConfigurationBuilder hotRodCacheConfiguration(ConfigurationBuilder base) {
        base.dataContainer().keyEquivalence(ByteArrayEquivalence.INSTANCE);
        return base;
    }

    public InternalCacheEntry assertHotRodEquals(EmbeddedCacheManager cm, byte[] key, byte[] expectedValue) {
        return this.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(), key, expectedValue);
    }

    public InternalCacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String key, String expectedValue) {
        return this.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(), this.marshall(key), this.marshall(expectedValue));
    }

    public InternalCacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String cacheName, String key, String expectedValue) {
        return this.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(cacheName), this.marshall(key), this.marshall(expectedValue));
    }

    private InternalCacheEntry assertHotRodEquals(EmbeddedCacheManager cm, Cache<byte[], byte[]> cache, byte[] key, byte[] expectedValue) {
        InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().get((Object)key);
        if (expectedValue == null) {
            Assert.assertNull((Object)entry);
        } else {
            byte[] value = entry == null ? (byte[])cache.get((Object)key) : (byte[])entry.getValue();
            AssertJUnit.assertEquals((byte[])expectedValue, (byte[])value);
        }
        return entry;
    }

    public byte[] marshall(String obj) {
        return obj == null ? null : new JBossMarshaller().objectToByteBuffer((Object)obj, 64);
    }

    public <T> T unmarshall(byte[] key) {
        return (T)new JBossMarshaller().objectFromByteBuffer(key);
    }

    private HotRodTestingUtil$() {
        MODULE$ = this;
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log.class.$init$((Log)this);
        this.EXPECTED_HASH_FUNCTION_VERSION = (byte)2;
    }
}

