/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.configuration.Builder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;

public class HotRodServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<HotRodServerConfiguration, HotRodServerConfigurationBuilder>
implements Builder<HotRodServerConfiguration> {
    private String proxyHost;
    private int proxyPort = -1;
    private long topologyLockTimeout = 10000L;
    private long topologyReplTimeout = 10000L;
    private boolean topologyStateTransfer = true;

    public HotRodServerConfigurationBuilder() {
        super(11222);
    }

    public HotRodServerConfigurationBuilder self() {
        return this;
    }

    public HotRodServerConfigurationBuilder proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public HotRodServerConfigurationBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public HotRodServerConfigurationBuilder topologyLockTimeout(long topologyLockTimeout) {
        this.topologyLockTimeout = topologyLockTimeout;
        return this;
    }

    public HotRodServerConfigurationBuilder topologyReplTimeout(long topologyReplTimeout) {
        this.topologyReplTimeout = topologyReplTimeout;
        return this;
    }

    public HotRodServerConfigurationBuilder topologyStateTransfer(boolean topologyStateTransfer) {
        this.topologyStateTransfer = topologyStateTransfer;
        return this;
    }

    public HotRodServerConfiguration create() {
        return new HotRodServerConfiguration(this.proxyHost, this.proxyPort, this.topologyLockTimeout, this.topologyReplTimeout, this.topologyStateTransfer, this.name, this.host, this.port, this.idleTimeout, this.recvBufSize, this.sendBufSize, this.ssl.create(), this.tcpNoDelay, this.workerThreads);
    }

    public HotRodServerConfigurationBuilder read(HotRodServerConfiguration template) {
        super.read((ProtocolServerConfiguration)template);
        this.proxyHost = template.proxyHost();
        this.proxyPort = template.proxyPort();
        this.topologyLockTimeout = template.topologyLockTimeout();
        this.topologyReplTimeout = template.topologyReplTimeout();
        this.topologyStateTransfer = template.topologyStateTransfer();
        return this;
    }

    public void validate() {
        super.validate();
        if (this.proxyHost == null) {
            this.proxyHost = this.host;
        }
        if (this.proxyPort < 0) {
            this.proxyPort = this.port;
        }
    }

    public HotRodServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodServerConfiguration build() {
        return this.build(true);
    }
}

