/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;

public final class BulkUtil {
    public static final int DEFAULT_SCOPE = 0;
    public static final int GLOBAL_SCOPE = 1;
    public static final int LOCAL_SCOPE = 2;

    public static final Set<byte[]> getAllKeys(Cache<byte[], byte[]> cache, int scope) {
        boolean keysAreLocal;
        CacheMode cacheMode = cache.getAdvancedCache().getCacheConfiguration().clustering().cacheMode();
        boolean bl = keysAreLocal = !cacheMode.isClustered() || cacheMode.isReplicated();
        if (keysAreLocal || scope == 2) {
            return cache.keySet();
        }
        MapReduceTask task = new MapReduceTask(cache).mappedWith((Mapper)new KeyMapper()).reducedWith((Reducer)new KeyReducer());
        return (Set)task.execute((Collator)new KeysCollator());
    }

    static class KeysCollator
    implements Collator<byte[], Object, Set<byte[]>> {
        KeysCollator() {
        }

        public Set<byte[]> collate(Map<byte[], Object> reducedResults) {
            return reducedResults.keySet();
        }
    }

    static class KeyReducer
    implements Reducer<byte[], Object> {
        private static final long serialVersionUID = -8199097945001793869L;

        KeyReducer() {
        }

        public Boolean reduce(byte[] reducedKey, Iterator<Object> iter) {
            return iter.hasNext();
        }
    }

    static class KeyMapper
    implements Mapper<byte[], byte[], byte[], Object> {
        private static final long serialVersionUID = -5054573988280497412L;

        KeyMapper() {
        }

        public void map(byte[] key, byte[] value, Collector<byte[], Object> collector) {
            collector.emit((Object)key, null);
        }
    }
}

