/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.RequestParameters;
import org.infinispan.server.core.ServerConstants;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.security.InetAddressPrincipal;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.server.core.transport.ExtendedByteBuf$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.AuthMechListResponse;
import org.infinispan.server.hotrod.AuthResponse;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.OperationResponse$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ProtocolFlag$;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.Log$class;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.TimeoutException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Decoder2x$
extends AbstractVersionedDecoder
implements ServerConstants,
Log {
    public static final Decoder2x$ MODULE$;
    private final boolean isTrace;
    private final JavaLog log;
    private final org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log;
    private final int EXPIRATION_NONE;
    private final int EXPIRATION_DEFAULT;
    private final Subject ANONYMOUS;
    private volatile byte bitmap$0;

    static {
        new Decoder2x$();
    }

    private JavaLog log$lzycompute() {
        Decoder2x$ decoder2x$ = this;
        synchronized (decoder2x$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.log;
        }
    }

    @Override
    public JavaLog log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public void logViewNullWhileDetectingCrashedMember() {
        Log$class.logViewNullWhileDetectingCrashedMember(this);
    }

    @Override
    public void logUnableToUpdateView() {
        Log$class.logUnableToUpdateView(this);
    }

    @Override
    public void logErrorDetectingCrashedMember(Throwable t) {
        Log$class.logErrorDetectingCrashedMember(this, t);
    }

    @Override
    public IllegalStateException unexpectedEvent(Event<byte[], byte[]> e) {
        return Log$class.unexpectedEvent(this, e);
    }

    @Override
    public void warnConditionalOperationNonTransactional(String op) {
        Log$class.warnConditionalOperationNonTransactional(this, op);
    }

    @Override
    public void warnForceReturnPreviousNonTransactional(String op) {
        Log$class.warnForceReturnPreviousNonTransactional(this, op);
    }

    private org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        Decoder2x$ decoder2x$ = this;
        synchronized (decoder2x$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log.class.org$infinispan$server$core$logging$Log$$log((org.infinispan.server.core.logging.Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    public org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$infinispan$server$core$logging$Log$$log$lzycompute() : this.org$infinispan$server$core$logging$Log$$log;
    }

    public void info(Function0<String> msg) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void info(Function0<String> msg, Object param1) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void error(Function0<String> msg, Throwable t) {
        Log.class.error((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void warn(Function0<String> msg, Throwable t) {
        Log.class.warn((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void debug(Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void debug(Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void debug(Throwable t, Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg);
    }

    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg, (Object)param1);
    }

    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log.class.debugf((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public void trace(Function0<String> msg) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void trace(Function0<String> msg, Object param1) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2, (Object)param3);
    }

    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log.class.tracef((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Log.class.isDebugEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public boolean isTraceEnabled() {
        return Log.class.isTraceEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public void logStartWithArgs(String args) {
        Log.class.logStartWithArgs((org.infinispan.server.core.logging.Log)this, (String)args);
    }

    public void logPostingShutdownRequest() {
        Log.class.logPostingShutdownRequest((org.infinispan.server.core.logging.Log)this);
    }

    public void logExceptionReported(Throwable t) {
        Log.class.logExceptionReported((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logServerDidNotUnbind() {
        Log.class.logServerDidNotUnbind((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log.class.logChannelStillBound((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logServerDidNotClose() {
        Log.class.logServerDidNotClose((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log.class.logChannelStillConnected((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logSettingMasterThreadsNotSupported() {
        Log.class.logSettingMasterThreadsNotSupported((org.infinispan.server.core.logging.Log)this);
    }

    public void logErrorBeforeReadingRequest(Throwable t) {
        Log.class.logErrorBeforeReadingRequest((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public int EXPIRATION_NONE() {
        return this.EXPIRATION_NONE;
    }

    public int EXPIRATION_DEFAULT() {
        return this.EXPIRATION_DEFAULT;
    }

    public Subject ANONYMOUS() {
        return this.ANONYMOUS;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_NONE_$eq(int x$1) {
        this.EXPIRATION_NONE = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_DEFAULT_$eq(int x$1) {
        this.EXPIRATION_DEFAULT = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$ANONYMOUS_$eq(Subject x$1) {
        this.ANONYMOUS = x$1;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    @Override
    public boolean readHeader(ByteBuf buffer, byte version, long messageId, HotRodHeader header) {
        Tuple2 tuple2;
        short streamOp;
        short s = streamOp = buffer.readUnsignedByte();
        switch (s) {
            default: {
                throw new HotRodUnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)BoxesRunTime.boxToShort((short)streamOp)).toString(), version, messageId);
            }
            case 39: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.RemoveClientListenerRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 37: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AddClientListenerRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 35: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AuthRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 33: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AuthMechListRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 31: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.QueryRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 29: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.BulkGetKeysRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 27: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.GetWithMetadataRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 25: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.BulkGetRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 23: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.PingRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 21: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.StatsRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 19: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.ClearRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 17: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.GetWithVersionRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 15: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.ContainsKeyRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 13: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 11: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.RemoveRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 9: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.ReplaceIfUnmodifiedRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 7: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.ReplaceRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 5: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.PutIfAbsentRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 3: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.GetRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 1: {
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)Operation$.MODULE$.PutRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            Enumeration.Value op = (Enumeration.Value)tuple2._1();
            boolean endOfOp = tuple2._2$mcZ$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)op, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
            Enumeration.Value op2 = (Enumeration.Value)tuple24._1();
            boolean endOfOp2 = tuple24._2$mcZ$sp();
            if (this.isTrace()) {
                this.trace((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Operation code: %d has been matched to %s";
                    }
                }, BoxesRunTime.boxToShort((short)streamOp), op2);
            }
            String cacheName = ExtendedByteBuf$.MODULE$.readString(buffer);
            int flag = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
            short clientIntelligence = buffer.readUnsignedByte();
            int topologyId = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
            header.op_$eq(op2);
            header.version_$eq(version);
            header.messageId_$eq(messageId);
            header.cacheName_$eq(cacheName);
            header.flag_$eq(flag);
            header.clientIntel_$eq(clientIntelligence);
            header.topologyId_$eq(topologyId);
            header.decoder_$eq(this);
            return endOfOp2;
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Tuple2<byte[], Object> readKey(HotRodHeader h, ByteBuf buffer) {
        byte[] k = this.readKey(buffer);
        Enumeration.Value value = h.op();
        Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
        Enumeration.Value value3 = value;
        Tuple2 tuple2 = !(value2 != null ? !value2.equals(value3) : value3 != null) ? new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return tuple2;
    }

    private byte[] readKey(ByteBuf buffer) {
        return ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
    }

    @Override
    public Tuple2<RequestParameters, Object> readParameters(HotRodHeader header, ByteBuf buffer) {
        Tuple2 tuple2;
        Enumeration.Value value = header.op();
        Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            Enumeration.Value value4 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)new RequestParameters(-1, -1, -1, buffer.readLong()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                Enumeration.Value value6 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    int lifespan = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultLifespan()));
                    int maxIdle = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultMaxIdle()));
                    long version = buffer.readLong();
                    int valueLength = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                    tuple2 = new Tuple2((Object)new RequestParameters(valueLength, lifespan, maxIdle, version), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    int lifespan = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultLifespan()));
                    int maxIdle = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultMaxIdle()));
                    int valueLength = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                    tuple2 = new Tuple2((Object)new RequestParameters(valueLength, lifespan, maxIdle, -1L), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            }
        }
        return tuple2;
    }

    private boolean hasFlag(HotRodHeader h, Enumeration.Value f) {
        return (h.flag() & f.id()) == f.id();
    }

    private int readLifespanOrMaxIdle(ByteBuf buffer, boolean useDefault) {
        int stream = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
        return stream <= 0 ? (useDefault ? this.EXPIRATION_DEFAULT() : this.EXPIRATION_NONE()) : stream;
    }

    @Override
    public Object createSuccessResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.Success(), prev);
    }

    @Override
    public Object createNotExecutedResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.OperationNotExecuted(), prev);
    }

    @Override
    public Object createNotExistResponse(HotRodHeader header) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.KeyDoesNotExist(), null);
    }

    private Object createResponse(HotRodHeader h, Enumeration.Value op, Enumeration.Value st, byte[] prev) {
        return this.hasFlag(h, ProtocolFlag$.MODULE$.ForceReturnPreviousValue()) ? new ResponseWithPrevious(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), op, st, h.topologyId(), (Option<byte[]>)(prev == null ? None$.MODULE$ : new Some((Object)prev))) : new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), op, st, h.topologyId());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object createGetResponse(HotRodHeader h, CacheEntry<byte[], byte[]> entry) {
        GetResponse getResponse;
        Enumeration.Value op = h.op();
        if (entry != null) {
            Enumeration.Value value = op;
            Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                getResponse = new GetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)((byte[])entry.getValue())));
                return getResponse;
            }
        }
        if (entry != null) {
            Enumeration.Value value = op;
            Enumeration.Value value3 = Operation$.MODULE$.GetWithVersionRequest();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                long version = ((NumericVersion)entry.getMetadata().version()).getVersion();
                getResponse = new GetWithVersionResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)((byte[])entry.getValue())), version);
                return getResponse;
            }
        }
        Enumeration.Value value = op;
        Enumeration.Value value4 = Operation$.MODULE$.GetRequest();
        if (!(value != null ? !value.equals(value4) : value4 != null)) {
            getResponse = new GetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$);
            return getResponse;
        }
        getResponse = new GetWithVersionResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$, 0L);
        return getResponse;
    }

    @Override
    public Object customReadHeader(HotRodHeader h, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache, HotRodServer server, ChannelHandlerContext ctx) {
        Enumeration.Value value;
        block14: {
            Response response;
            block11: {
                Response response2;
                block13: {
                    block12: {
                        block10: {
                            value = h.op();
                            Enumeration.Value value2 = HotRodOperation$.MODULE$.ClearRequest();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block10;
                            cache.clear();
                            response = new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ClearResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                            break block11;
                        }
                        Enumeration.Value value4 = HotRodOperation$.MODULE$.PingRequest();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block12;
                        response = new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.PingResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                        break block11;
                    }
                    Enumeration.Value value6 = HotRodOperation$.MODULE$.AuthMechListRequest();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block13;
                    response = new AuthMechListResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(((HotRodServerConfiguration)server.getConfiguration()).authentication().allowedMechs()).asScala()).toSet(), h.topologyId());
                    break block11;
                }
                Enumeration.Value value8 = HotRodOperation$.MODULE$.AuthRequest();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block14;
                if (((HotRodServerConfiguration)server.getConfiguration()).authentication().enabled()) {
                    HotRodDecoder decoder = (HotRodDecoder)ctx.pipeline().get("decoder");
                    String mech = ExtendedByteBuf$.MODULE$.readString(buffer);
                    if (decoder.saslServer() == null) {
                        AuthenticationConfiguration authConf = ((HotRodServerConfiguration)server.getConfiguration()).authentication();
                        ServerAuthenticationProvider sap = authConf.serverAuthenticationProvider();
                        HashMap<String, String> mechProperties = new HashMap<String, String>(((HotRodServerConfiguration)server.getConfiguration()).authentication().mechProperties());
                        decoder.callbackHandler_$eq(sap.getCallbackHandler(mech, mechProperties));
                        SaslServerFactory ssf = server.getSaslServerFactory(mech);
                        decoder.saslServer_$eq(authConf.serverSubject() == null ? ssf.createSaslServer(mech, "hotrod", ((HotRodServerConfiguration)server.getConfiguration()).authentication().serverName(), mechProperties, (CallbackHandler)decoder.callbackHandler()) : Subject.doAs(authConf.serverSubject(), new PrivilegedAction<SaslServer>(server, decoder, mech, mechProperties, ssf){
                            private final HotRodServer server$1;
                            private final HotRodDecoder decoder$1;
                            private final String mech$1;
                            private final HashMap mechProperties$1;
                            private final SaslServerFactory ssf$1;

                            public SaslServer run() {
                                return this.ssf$1.createSaslServer(this.mech$1, "hotrod", ((HotRodServerConfiguration)this.server$1.getConfiguration()).authentication().serverName(), this.mechProperties$1, (CallbackHandler)this.decoder$1.callbackHandler());
                            }
                            {
                                this.server$1 = server$1;
                                this.decoder$1 = decoder$1;
                                this.mech$1 = mech$1;
                                this.mechProperties$1 = mechProperties$1;
                                this.ssf$1 = ssf$1;
                            }
                        }));
                    }
                    byte[] clientResponse = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                    byte[] serverChallenge = decoder.saslServer().evaluateResponse(clientResponse);
                    if (decoder.saslServer().isComplete()) {
                        BoxedUnit boxedUnit;
                        ctx.channel().writeAndFlush((Object)new AuthResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), serverChallenge, h.topologyId()));
                        ArrayList<Object> extraPrincipals = new ArrayList<Object>();
                        String id = this.normalizeAuthorizationId(decoder.saslServer().getAuthorizationID());
                        extraPrincipals.add(new SimpleUserPrincipal(id));
                        extraPrincipals.add(new InetAddressPrincipal(((InetSocketAddress)ctx.channel().remoteAddress()).getAddress()));
                        SslHandler sslHandler = (SslHandler)ctx.pipeline().get("ssl");
                        Object object = sslHandler == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)extraPrincipals.add(sslHandler.engine().getSession().getPeerPrincipal()));
                        decoder.subject_$eq(decoder.callbackHandler().getSubjectUserInfo(extraPrincipals).getSubject());
                        String qop = (String)decoder.saslServer().getNegotiatedProperty("javax.security.sasl.qop");
                        if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                            SaslQopHandler qopHandler = new SaslQopHandler(decoder.saslServer());
                            boxedUnit = ctx.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
                        } else {
                            decoder.saslServer().dispose();
                            decoder.callbackHandler_$eq(null);
                            decoder.saslServer_$eq(null);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        response2 = None$.MODULE$;
                    } else {
                        response2 = new AuthResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), serverChallenge, h.topologyId());
                    }
                } else {
                    response2 = this.createErrorResponse(h, this.log().invalidOperation());
                }
                response = response2;
            }
            return response;
        }
        throw new MatchError((Object)value);
    }

    @Override
    public Object customReadKey(HotRodHeader h, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache, HotRodServer server, Channel ch) {
        Enumeration.Value value;
        block15: {
            Object object;
            block8: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            Object object2;
                                            value = h.op();
                                            Enumeration.Value value2 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                                            Enumeration.Value value3 = value;
                                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block7;
                                            byte[] k = this.readKey(buffer);
                                            RequestParameters params = (RequestParameters)this.readParameters(h, buffer)._1();
                                            CacheEntry entry = cache.getCacheEntry((Object)k);
                                            if (entry == null) {
                                                object2 = this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), null);
                                            } else {
                                                boolean removed;
                                                byte[] prev = (byte[])entry.getValue();
                                                NumericVersion streamVersion = new NumericVersion(params.streamVersion());
                                                EntryVersion entryVersion = entry.getMetadata().version();
                                                NumericVersion numericVersion = streamVersion;
                                                object2 = !(entryVersion != null ? !entryVersion.equals(numericVersion) : numericVersion != null) ? ((removed = cache.remove((Object)k, (Object)prev)) ? this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.Success(), prev) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev)) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev);
                                            }
                                            object = object2;
                                            break block8;
                                        }
                                        Enumeration.Value value4 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                                        Enumeration.Value value5 = value;
                                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block9;
                                        byte[] k = this.readKey(buffer);
                                        object = cache.containsKey((Object)k) ? new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.Success(), h.topologyId()) : new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId());
                                        break block8;
                                    }
                                    Enumeration.Value value6 = HotRodOperation$.MODULE$.BulkGetRequest();
                                    Enumeration.Value value7 = value;
                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block10;
                                    int count = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                                    if (this.isTrace()) {
                                        this.trace((Function0<String>)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "About to create bulk response, count = %d";
                                            }
                                        }, BoxesRunTime.boxToInteger((int)count));
                                    }
                                    object = new BulkGetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.BulkGetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), count);
                                    break block8;
                                }
                                Enumeration.Value value8 = HotRodOperation$.MODULE$.BulkGetKeysRequest();
                                Enumeration.Value value9 = value;
                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block11;
                                int scope = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                                if (this.isTrace()) {
                                    this.trace((Function0<String>)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "About to create bulk get keys response, scope = %d";
                                        }
                                    }, BoxesRunTime.boxToInteger((int)scope));
                                }
                                object = new BulkGetKeysResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.BulkGetKeysResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), scope);
                                break block8;
                            }
                            Enumeration.Value value10 = HotRodOperation$.MODULE$.GetWithMetadataRequest();
                            Enumeration.Value value11 = value;
                            if (value10 != null ? !value10.equals(value11) : value11 != null) break block12;
                            byte[] k = this.readKey(buffer);
                            object = this.getKeyMetadata(h, k, cache);
                            break block8;
                        }
                        Enumeration.Value value12 = HotRodOperation$.MODULE$.QueryRequest();
                        Enumeration.Value value13 = value;
                        if (value12 != null ? !value12.equals(value13) : value13 != null) break block13;
                        byte[] query = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                        byte[] result = ((QueryFacade)server.getQueryFacades().head()).query(cache, query);
                        object = new QueryResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), result);
                        break block8;
                    }
                    Enumeration.Value value14 = HotRodOperation$.MODULE$.AddClientListenerRequest();
                    Enumeration.Value value15 = value;
                    if (value14 != null ? !value14.equals(value15) : value15 != null) break block14;
                    byte[] listenerId = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                    Option<Tuple2<String, List<byte[]>>> filterFactoryInfo = this.readNamedFactory(buffer);
                    Option<Tuple2<String, List<byte[]>>> converterFactoryInfo = this.readNamedFactory(buffer);
                    ClientListenerRegistry reg = server.getClientListenerRegistry();
                    reg.addClientListener(ch, h, listenerId, cache, filterFactoryInfo, converterFactoryInfo);
                    object = this.createSuccessResponse(h, null);
                    break block8;
                }
                Enumeration.Value value16 = HotRodOperation$.MODULE$.RemoveClientListenerRequest();
                Enumeration.Value value17 = value;
                if (value16 != null ? !value16.equals(value17) : value17 != null) break block15;
                byte[] listenerId = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                ClientListenerRegistry reg = server.getClientListenerRegistry();
                boolean removed = reg.removeClientListener(listenerId, cache);
                object = removed ? this.createSuccessResponse(h, null) : this.createNotExecutedResponse(h, null);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Option<Tuple2<String, List<byte[]>>> readNamedFactory(ByteBuf buffer) {
        return this.readOptionalString(buffer).map((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuf buffer$1;

            public final Tuple2<String, List<byte[]>> apply(String factoryName) {
                return new Tuple2((Object)factoryName, Decoder2x$.MODULE$.org$infinispan$server$hotrod$Decoder2x$$readOptionalParams(this.buffer$1));
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
    }

    private Option<String> readOptionalString(ByteBuf buffer) {
        String string = ExtendedByteBuf$.MODULE$.readString(buffer);
        return string.isEmpty() ? None$.MODULE$ : new Some((Object)string);
    }

    public List<byte[]> org$infinispan$server$hotrod$Decoder2x$$readOptionalParams(ByteBuf buffer) {
        List list;
        byte numParams = buffer.readByte();
        if (numParams > 0) {
            ObjectRef params = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)numParams).foreach((Function1)new Serializable(buffer, params){
                public static final long serialVersionUID = 0L;
                private final ByteBuf buffer$2;
                private final ObjectRef params$1;

                public final ListBuffer<byte[]> apply(int i) {
                    return ((ListBuffer)this.params$1.elem).$plus$eq((Object)ExtendedByteBuf$.MODULE$.readRangedBytes(this.buffer$2));
                }
                {
                    this.buffer$2 = buffer$2;
                    this.params$1 = params$1;
                }
            });
            list = ((ListBuffer)params.elem).toList();
        } else {
            list = List$.MODULE$.empty();
        }
        return list;
    }

    public GetWithMetadataResponse getKeyMetadata(HotRodHeader h, byte[] k, AdvancedCache<byte[], byte[]> cache) {
        GetWithMetadataResponse getWithMetadataResponse;
        CacheEntry ce = cache.getCacheEntry((Object)k);
        if (ce == null) {
            getWithMetadataResponse = new GetWithMetadataResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithMetadataResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$, 0L, -1L, -1, -1L, -1);
        } else {
            InternalCacheEntry ice = (InternalCacheEntry)ce;
            NumericVersion entryVersion = (NumericVersion)ice.getMetadata().version();
            byte[] v = (byte[])ce.getValue();
            int lifespan = ice.getLifespan() < 0L ? -1 : (int)(ice.getLifespan() / 1000L);
            int maxIdle = ice.getMaxIdle() < 0L ? -1 : (int)(ice.getMaxIdle() / 1000L);
            getWithMetadataResponse = new GetWithMetadataResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithMetadataResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)v), entryVersion.getVersion(), ice.getCreated(), lifespan, ice.getLastUsed(), maxIdle);
        }
        return getWithMetadataResponse;
    }

    @Override
    public Object customReadValue(HotRodHeader header, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache) {
        return null;
    }

    @Override
    public Object createStatsResponse(HotRodHeader h, Stats cacheStats, NettyTransport t) {
        Map stats = Map$.MODULE$.empty();
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"timeSinceStart"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTimeSinceStart())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"currentNumberOfEntries"), (Object)((Object)BoxesRunTime.boxToInteger((int)cacheStats.getCurrentNumberOfEntries())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"totalNumberOfEntries"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTotalNumberOfEntries())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"stores"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getStores())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"retrievals"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRetrievals())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"hits"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getHits())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"misses"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getMisses())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"removeHits"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveHits())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"removeMisses"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveMisses())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"totalBytesRead"), (Object)t.getTotalBytesRead()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"totalBytesWritten"), (Object)t.getTotalBytesWritten()));
        return new StatsResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), (scala.collection.immutable.Map<String, String>)((MapLike)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)stats), h.topologyId());
    }

    @Override
    public ErrorResponse createErrorResponse(HotRodHeader h, Throwable t) {
        Throwable throwable;
        block5: {
            ErrorResponse errorResponse;
            block3: {
                block4: {
                    block2: {
                        throwable = t;
                        if (!(throwable instanceof IOException)) break block2;
                        IOException iOException = (IOException)throwable;
                        errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ParseError(), h.topologyId(), iOException.toString());
                        break block3;
                    }
                    if (!(throwable instanceof TimeoutException)) break block4;
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.OperationTimedOut(), h.topologyId(), timeoutException.toString());
                    break block3;
                }
                if (throwable == null) break block5;
                Throwable throwable2 = throwable;
                errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ServerError(), h.topologyId(), throwable2.toString());
            }
            return errorResponse;
        }
        throw new MatchError((Object)throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AdvancedCache<byte[], byte[]> getOptimizedCache(HotRodHeader h, AdvancedCache<byte[], byte[]> c) {
        void var3_3;
        boolean bl;
        AdvancedCache optCache = c;
        Enumeration.Value value = h.op();
        Enumeration.Value value2 = Operation$.MODULE$.PutIfAbsentRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value8 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                    Enumeration.Value value9 = value;
                    bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
                }
            }
        }
        if (bl && !this.isCacheTransactional(optCache)) {
            this.warnConditionalOperationNonTransactional(h.op().toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (this.hasFlag(h, ProtocolFlag$.MODULE$.SkipCacheLoader())) {
            boolean bl2;
            Enumeration.Value value10 = h.op();
            Enumeration.Value value11 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value13 = Operation$.MODULE$.GetRequest();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    bl2 = true;
                } else {
                    Enumeration.Value value15 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        bl2 = true;
                    } else {
                        Enumeration.Value value17 = Operation$.MODULE$.RemoveRequest();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            bl2 = true;
                        } else {
                            Enumeration.Value value19 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                            Enumeration.Value value20 = value10;
                            if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                bl2 = true;
                            } else {
                                Enumeration.Value value21 = HotRodOperation$.MODULE$.BulkGetRequest();
                                Enumeration.Value value22 = value10;
                                if (!(value21 != null ? !value21.equals(value22) : value22 != null)) {
                                    bl2 = true;
                                } else {
                                    Enumeration.Value value23 = HotRodOperation$.MODULE$.GetWithMetadataRequest();
                                    Enumeration.Value value24 = value10;
                                    if (!(value23 != null ? !value23.equals(value24) : value24 != null)) {
                                        bl2 = true;
                                    } else {
                                        Enumeration.Value value25 = HotRodOperation$.MODULE$.BulkGetKeysRequest();
                                        Enumeration.Value value26 = value10;
                                        bl2 = !(value25 != null ? !value25.equals(value26) : value26 != null);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl2) {
                optCache = optCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (this.hasFlag(h, ProtocolFlag$.MODULE$.ForceReturnPreviousValue())) {
            if (!this.isCacheTransactional(optCache)) {
                this.warnForceReturnPreviousNonTransactional(h.op().toString());
            }
        } else {
            boolean bl3;
            Enumeration.Value value27 = h.op();
            Enumeration.Value value28 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value29 = value27;
            if (!(value28 != null ? !value28.equals(value29) : value29 != null)) {
                bl3 = true;
            } else {
                Enumeration.Value value30 = Operation$.MODULE$.PutIfAbsentRequest();
                Enumeration.Value value31 = value27;
                bl3 = !(value30 != null ? !value30.equals(value31) : value31 != null);
            }
            if (bl3) {
                optCache = optCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return var3_3;
    }

    private boolean isCacheTransactional(AdvancedCache<byte[], byte[]> c) {
        return SecurityActions.getCacheConfiguration(c).transaction().transactionMode().isTransactional();
    }

    public String normalizeAuthorizationId(String id) {
        int realm = id.indexOf(64);
        return realm >= 0 ? id.substring(0, realm) : id;
    }

    private Decoder2x$() {
        MODULE$ = this;
        ServerConstants.class.$init$((ServerConstants)this);
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log$class.$init$(this);
        this.isTrace = this.isTraceEnabled();
    }
}

