/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.RequestParameters;
import org.infinispan.server.core.ServerConstants;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.security.InetAddressPrincipal;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.server.core.transport.ExtendedByteBuf$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.AuthMechListResponse;
import org.infinispan.server.hotrod.AuthResponse;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.OperationResponse$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ProtocolFlag$;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.SizeResponse;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.Log$class;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.TimeoutException;
import org.jgroups.SuspectedException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Decoder2x$
extends AbstractVersionedDecoder
implements ServerConstants,
Log {
    public static final Decoder2x$ MODULE$;
    private final boolean isTrace;
    private final JavaLog log;
    private final org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log;
    private final int EXPIRATION_NONE;
    private final int EXPIRATION_DEFAULT;
    private final Subject ANONYMOUS;
    private volatile byte bitmap$0;

    static {
        new Decoder2x$();
    }

    private JavaLog log$lzycompute() {
        Decoder2x$ decoder2x$ = this;
        synchronized (decoder2x$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.log;
        }
    }

    @Override
    public JavaLog log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public void logViewNullWhileDetectingCrashedMember() {
        Log$class.logViewNullWhileDetectingCrashedMember(this);
    }

    @Override
    public void logUnableToUpdateView() {
        Log$class.logUnableToUpdateView(this);
    }

    @Override
    public void logErrorDetectingCrashedMember(Throwable t) {
        Log$class.logErrorDetectingCrashedMember(this, t);
    }

    @Override
    public IllegalStateException unexpectedEvent(Event<?, ?> e) {
        return Log$class.unexpectedEvent(this, e);
    }

    @Override
    public void warnConditionalOperationNonTransactional(String op) {
        Log$class.warnConditionalOperationNonTransactional(this, op);
    }

    @Override
    public void warnForceReturnPreviousNonTransactional(String op) {
        Log$class.warnForceReturnPreviousNonTransactional(this, op);
    }

    @Override
    public void warnMarshallerAlreadySet(Marshaller existingMarshaller, Marshaller newMarshaller) {
        Log$class.warnMarshallerAlreadySet(this, existingMarshaller, newMarshaller);
    }

    private org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        Decoder2x$ decoder2x$ = this;
        synchronized (decoder2x$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log.class.org$infinispan$server$core$logging$Log$$log((org.infinispan.server.core.logging.Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    public org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$infinispan$server$core$logging$Log$$log$lzycompute() : this.org$infinispan$server$core$logging$Log$$log;
    }

    public void info(Function0<String> msg) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void info(Function0<String> msg, Object param1) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void error(Function0<String> msg, Throwable t) {
        Log.class.error((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void warn(Function0<String> msg, Throwable t) {
        Log.class.warn((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void debug(Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void debug(Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void debug(Throwable t, Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg);
    }

    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg, (Object)param1);
    }

    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log.class.debugf((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public void trace(Function0<String> msg) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void trace(Function0<String> msg, Object param1) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2, (Object)param3);
    }

    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log.class.tracef((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Log.class.isDebugEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public boolean isTraceEnabled() {
        return Log.class.isTraceEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public void logStartWithArgs(String args) {
        Log.class.logStartWithArgs((org.infinispan.server.core.logging.Log)this, (String)args);
    }

    public void logPostingShutdownRequest() {
        Log.class.logPostingShutdownRequest((org.infinispan.server.core.logging.Log)this);
    }

    public void logExceptionReported(Throwable t) {
        Log.class.logExceptionReported((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logServerDidNotUnbind() {
        Log.class.logServerDidNotUnbind((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log.class.logChannelStillBound((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logServerDidNotClose() {
        Log.class.logServerDidNotClose((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log.class.logChannelStillConnected((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logSettingMasterThreadsNotSupported() {
        Log.class.logSettingMasterThreadsNotSupported((org.infinispan.server.core.logging.Log)this);
    }

    public void logErrorBeforeReadingRequest(Throwable t) {
        Log.class.logErrorBeforeReadingRequest((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public int EXPIRATION_NONE() {
        return this.EXPIRATION_NONE;
    }

    public int EXPIRATION_DEFAULT() {
        return this.EXPIRATION_DEFAULT;
    }

    public Subject ANONYMOUS() {
        return this.ANONYMOUS;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_NONE_$eq(int x$1) {
        this.EXPIRATION_NONE = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_DEFAULT_$eq(int x$1) {
        this.EXPIRATION_DEFAULT = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$ANONYMOUS_$eq(Subject x$1) {
        this.ANONYMOUS = x$1;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    @Override
    public boolean readHeader(ByteBuf buffer, byte version, long messageId, HotRodHeader header) {
        Tuple2 tuple2;
        short streamOp;
        short s = streamOp = buffer.readUnsignedByte();
        switch (s) {
            default: {
                throw new HotRodUnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)BoxesRunTime.boxToShort((short)streamOp)).toString(), version, messageId);
            }
            case 41: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.SizeRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 39: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.RemoveClientListenerRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 37: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AddClientListenerRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 35: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AuthRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 33: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.AuthMechListRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 31: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.QueryRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 29: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.BulkGetKeysRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 27: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.GetWithMetadataRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 25: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.BulkGetRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 23: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.PingRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 21: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.StatsRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 19: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.ClearRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            case 17: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.GetWithVersionRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 15: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.ContainsKeyRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 13: {
                Tuple2 tuple22 = new Tuple2((Object)HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 11: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.RemoveRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 9: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.ReplaceIfUnmodifiedRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 7: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.ReplaceRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 5: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.PutIfAbsentRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 3: {
                Tuple2 tuple22 = new Tuple2((Object)Operation$.MODULE$.GetRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            case 1: {
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)Operation$.MODULE$.PutRequest(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            Enumeration.Value op = (Enumeration.Value)tuple2._1();
            boolean endOfOp = tuple2._2$mcZ$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)op, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
            Enumeration.Value op2 = (Enumeration.Value)tuple24._1();
            boolean endOfOp2 = tuple24._2$mcZ$sp();
            if (this.isTrace()) {
                this.trace((Function0<String>)new Serializable(){

                    public final String apply() {
                        return "Operation code: %d has been matched to %s";
                    }
                }, BoxesRunTime.boxToShort((short)streamOp), op2);
            }
            String cacheName = ExtendedByteBuf$.MODULE$.readString(buffer);
            int flag = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
            short clientIntelligence = buffer.readUnsignedByte();
            int topologyId = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
            header.op_$eq(op2);
            header.version_$eq(version);
            header.messageId_$eq(messageId);
            header.cacheName_$eq(cacheName);
            header.flag_$eq(flag);
            header.clientIntel_$eq(clientIntelligence);
            header.topologyId_$eq(topologyId);
            header.decoder_$eq(this);
            return endOfOp2;
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Tuple2<byte[], Object> readKey(HotRodHeader h, ByteBuf buffer) {
        byte[] k = this.readKey(buffer);
        Enumeration.Value value = h.op();
        Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
        Enumeration.Value value3 = value;
        Tuple2 tuple2 = !(value2 != null ? !value2.equals(value3) : value3 != null) ? new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return tuple2;
    }

    private byte[] readKey(ByteBuf buffer) {
        return ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
    }

    @Override
    public Tuple2<RequestParameters, Object> readParameters(HotRodHeader header, ByteBuf buffer) {
        Tuple2 tuple2;
        Enumeration.Value value = header.op();
        Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            Enumeration.Value value4 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)new RequestParameters(-1, -1, -1, buffer.readLong()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                Enumeration.Value value6 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    int lifespan = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultLifespan()));
                    int maxIdle = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultMaxIdle()));
                    long version = buffer.readLong();
                    int valueLength = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                    tuple2 = new Tuple2((Object)new RequestParameters(valueLength, lifespan, maxIdle, version), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    int lifespan = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultLifespan()));
                    int maxIdle = this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag$.MODULE$.DefaultMaxIdle()));
                    int valueLength = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                    tuple2 = new Tuple2((Object)new RequestParameters(valueLength, lifespan, maxIdle, -1L), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            }
        }
        return tuple2;
    }

    private boolean hasFlag(HotRodHeader h, Enumeration.Value f) {
        return (h.flag() & f.id()) == f.id();
    }

    private int readLifespanOrMaxIdle(ByteBuf buffer, boolean useDefault) {
        int stream = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
        return stream <= 0 ? (useDefault ? this.EXPIRATION_DEFAULT() : this.EXPIRATION_NONE()) : stream;
    }

    @Override
    public Object createSuccessResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.Success(), prev);
    }

    @Override
    public Object createNotExecutedResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.OperationNotExecuted(), prev);
    }

    @Override
    public Object createNotExistResponse(HotRodHeader header) {
        return this.createResponse(header, OperationResponse$.MODULE$.toResponse(header.op()), OperationStatus$.MODULE$.KeyDoesNotExist(), null);
    }

    /*
     * Unable to fully structure code
     */
    private Object createResponse(HotRodHeader h, Enumeration.Value op, Enumeration.Value st, byte[] prev) {
        block13: {
            block4: {
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                if (!this.hasFlag(h, ProtocolFlag$.MODULE$.ForceReturnPreviousValue())) break block4;
                                                var6_5 = new Tuple2((Object)h.op(), (Object)st);
                                                if (var6_5 == null) break block5;
                                                var7_6 = (Enumeration.Value)var6_5._1();
                                                var8_7 = (Enumeration.Value)var6_5._2();
                                                v0 = Operation$.MODULE$.PutRequest();
                                                var9_8 = var7_6;
                                                if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) break block5;
                                                v1 = OperationStatus$.MODULE$.Success();
                                                var10_9 = var8_7;
                                                if (v1 != null ? v1.equals(var10_9) == false : var10_9 != null) break block5;
                                                var11_10 = OperationStatus$.MODULE$.SuccessWithPrevious();
                                                break block6;
                                            }
                                            if (var6_5 == null) break block7;
                                            var12_11 = (Enumeration.Value)var6_5._1();
                                            var13_12 = (Enumeration.Value)var6_5._2();
                                            v2 = Operation$.MODULE$.PutIfAbsentRequest();
                                            var14_13 = var12_11;
                                            if (v2 != null ? v2.equals(var14_13) == false : var14_13 != null) break block7;
                                            v3 = OperationStatus$.MODULE$.OperationNotExecuted();
                                            var15_14 = var13_12;
                                            if (v3 != null ? v3.equals(var15_14) == false : var15_14 != null) break block7;
                                            var11_10 = OperationStatus$.MODULE$.NotExecutedWithPrevious();
                                            break block6;
                                        }
                                        if (var6_5 == null) break block8;
                                        var16_15 = (Enumeration.Value)var6_5._1();
                                        var17_16 = (Enumeration.Value)var6_5._2();
                                        v4 = Operation$.MODULE$.ReplaceRequest();
                                        var18_17 = var16_15;
                                        if (v4 != null ? v4.equals(var18_17) == false : var18_17 != null) break block8;
                                        v5 = OperationStatus$.MODULE$.Success();
                                        var19_18 = var17_16;
                                        if (v5 != null ? v5.equals(var19_18) == false : var19_18 != null) break block8;
                                        var11_10 = OperationStatus$.MODULE$.SuccessWithPrevious();
                                        break block6;
                                    }
                                    if (var6_5 == null) break block9;
                                    var20_19 = (Enumeration.Value)var6_5._1();
                                    var21_20 = (Enumeration.Value)var6_5._2();
                                    v6 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                                    var22_21 = var20_19;
                                    if (v6 != null ? v6.equals(var22_21) == false : var22_21 != null) break block9;
                                    v7 = OperationStatus$.MODULE$.Success();
                                    var23_22 = var21_20;
                                    if (v7 != null ? v7.equals(var23_22) == false : var23_22 != null) break block9;
                                    var11_10 = OperationStatus$.MODULE$.SuccessWithPrevious();
                                    break block6;
                                }
                                if (var6_5 == null) break block10;
                                var24_23 = (Enumeration.Value)var6_5._1();
                                var25_24 = (Enumeration.Value)var6_5._2();
                                v8 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                                var26_25 = var24_23;
                                if (v8 != null ? v8.equals(var26_25) == false : var26_25 != null) break block10;
                                v9 = OperationStatus$.MODULE$.OperationNotExecuted();
                                var27_26 = var25_24;
                                if (v9 != null ? v9.equals(var27_26) == false : var27_26 != null) break block10;
                                var11_10 = OperationStatus$.MODULE$.NotExecutedWithPrevious();
                                break block6;
                            }
                            if (var6_5 == null) break block11;
                            var28_27 = (Enumeration.Value)var6_5._1();
                            var29_28 = (Enumeration.Value)var6_5._2();
                            v10 = Operation$.MODULE$.RemoveRequest();
                            var30_29 = var28_27;
                            if (v10 != null ? v10.equals(var30_29) == false : var30_29 != null) break block11;
                            v11 = OperationStatus$.MODULE$.Success();
                            var31_30 = var29_28;
                            if (v11 != null ? v11.equals(var31_30) == false : var31_30 != null) break block11;
                            var11_10 = OperationStatus$.MODULE$.SuccessWithPrevious();
                            break block6;
                        }
                        if (var6_5 == null) break block12;
                        var32_31 = (Enumeration.Value)var6_5._1();
                        var33_32 = (Enumeration.Value)var6_5._2();
                        v12 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                        var34_33 = var32_31;
                        if (v12 != null ? v12.equals(var34_33) == false : var34_33 != null) break block12;
                        v13 = OperationStatus$.MODULE$.Success();
                        var35_34 = var33_32;
                        if (v13 != null ? v13.equals(var35_34) == false : var35_34 != null) break block12;
                        var11_10 = OperationStatus$.MODULE$.SuccessWithPrevious();
                        break block6;
                    }
                    if (var6_5 == null) ** GOTO lbl-1000
                    var36_35 = (Enumeration.Value)var6_5._1();
                    var37_36 = (Enumeration.Value)var6_5._2();
                    v14 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                    var38_37 = var36_35;
                    if (v14 != null ? v14.equals(var38_37) == false : var38_37 != null) ** GOTO lbl-1000
                    v15 = OperationStatus$.MODULE$.OperationNotExecuted();
                    var39_38 = var37_36;
                    if (!(v15 != null ? v15.equals(var39_38) == false : var39_38 != null)) {
                        var11_10 = OperationStatus$.MODULE$.NotExecutedWithPrevious();
                    } else lbl-1000:
                    // 3 sources

                    {
                        var11_10 = st;
                    }
                }
                var40_40 = adjustedStatus = var11_10;
                v16 = OperationStatus$.MODULE$.SuccessWithPrevious();
                var41_41 = var40_40;
                if (!(v16 != null ? v16.equals(var41_41) == false : var41_41 != null)) {
                    var42_42 = true;
                } else {
                    v17 = OperationStatus$.MODULE$.NotExecutedWithPrevious();
                    var43_43 = var40_40;
                    var42_42 = !(v17 != null ? v17.equals(var43_43) == false : var43_43 != null);
                }
                var44_44 = var42_42 != false ? new ResponseWithPrevious(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), op, adjustedStatus, h.topologyId(), (Option<byte[]>)(prev == null ? None$.MODULE$ : new Some((Object)prev))) : new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), op, adjustedStatus, h.topologyId());
                v18 = var44_44;
                break block13;
            }
            v18 = new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), op, st, h.topologyId());
        }
        return v18;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object createGetResponse(HotRodHeader h, CacheEntry<byte[], byte[]> entry) {
        GetResponse getResponse;
        Enumeration.Value op = h.op();
        if (entry != null) {
            Enumeration.Value value = op;
            Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                getResponse = new GetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)((byte[])entry.getValue())));
                return getResponse;
            }
        }
        if (entry != null) {
            Enumeration.Value value = op;
            Enumeration.Value value3 = Operation$.MODULE$.GetWithVersionRequest();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                long version = ((NumericVersion)entry.getMetadata().version()).getVersion();
                getResponse = new GetWithVersionResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)((byte[])entry.getValue())), version);
                return getResponse;
            }
        }
        Enumeration.Value value = op;
        Enumeration.Value value4 = Operation$.MODULE$.GetRequest();
        if (!(value != null ? !value.equals(value4) : value4 != null)) {
            getResponse = new GetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$);
            return getResponse;
        }
        getResponse = new GetWithVersionResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$, 0L);
        return getResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object customReadHeader(HotRodHeader h, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache, HotRodServer server, ChannelHandlerContext ctx) {
        BoxedUnit boxedUnit;
        Response response;
        ArrayList<Object> extraPrincipals;
        HotRodDecoder decoder;
        block18: {
            Enumeration.Value value;
            block19: {
                block20: {
                    value = h.op();
                    Enumeration.Value value2 = HotRodOperation$.MODULE$.ClearRequest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        cache.clear();
                        return new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ClearResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                    }
                    Enumeration.Value value4 = HotRodOperation$.MODULE$.PingRequest();
                    Enumeration.Value value5 = value;
                    if (value4 == null) {
                        if (value5 == null) return new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.PingResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                    } else if (value4.equals(value5)) {
                        return new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.PingResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                    }
                    Enumeration.Value value6 = HotRodOperation$.MODULE$.AuthMechListRequest();
                    Enumeration.Value value7 = value;
                    if (value6 == null) {
                        if (value7 == null) return new AuthMechListResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(((HotRodServerConfiguration)server.getConfiguration()).authentication().allowedMechs()).asScala()).toSet(), h.topologyId());
                    } else if (value6.equals(value7)) {
                        return new AuthMechListResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(((HotRodServerConfiguration)server.getConfiguration()).authentication().allowedMechs()).asScala()).toSet(), h.topologyId());
                    }
                    Enumeration.Value value8 = HotRodOperation$.MODULE$.AuthRequest();
                    Enumeration.Value value9 = value;
                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block19;
                    if (!((HotRodServerConfiguration)server.getConfiguration()).authentication().enabled()) break block20;
                    decoder = (HotRodDecoder)ctx.pipeline().get("decoder");
                    String mech = ExtendedByteBuf$.MODULE$.readString(buffer);
                    if (decoder.saslServer() == null) {
                        AuthenticationConfiguration authConf = ((HotRodServerConfiguration)server.getConfiguration()).authentication();
                        ServerAuthenticationProvider sap = authConf.serverAuthenticationProvider();
                        HashMap<String, String> mechProperties = new HashMap<String, String>(((HotRodServerConfiguration)server.getConfiguration()).authentication().mechProperties());
                        decoder.callbackHandler_$eq(sap.getCallbackHandler(mech, mechProperties));
                        SaslServerFactory ssf = server.getSaslServerFactory(mech);
                        decoder.saslServer_$eq(authConf.serverSubject() == null ? ssf.createSaslServer(mech, "hotrod", ((HotRodServerConfiguration)server.getConfiguration()).authentication().serverName(), mechProperties, (CallbackHandler)decoder.callbackHandler()) : Subject.doAs(authConf.serverSubject(), new PrivilegedAction<SaslServer>(server, decoder, mech, mechProperties, ssf){
                            private final HotRodServer server$1;
                            private final HotRodDecoder decoder$1;
                            private final String mech$1;
                            private final HashMap mechProperties$1;
                            private final SaslServerFactory ssf$1;

                            public SaslServer run() {
                                return this.ssf$1.createSaslServer(this.mech$1, "hotrod", ((HotRodServerConfiguration)this.server$1.getConfiguration()).authentication().serverName(), this.mechProperties$1, (CallbackHandler)this.decoder$1.callbackHandler());
                            }
                            {
                                this.server$1 = server$1;
                                this.decoder$1 = decoder$1;
                                this.mech$1 = mech$1;
                                this.mechProperties$1 = mechProperties$1;
                                this.ssf$1 = ssf$1;
                            }
                        }));
                    }
                    byte[] clientResponse = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                    byte[] serverChallenge = decoder.saslServer().evaluateResponse(clientResponse);
                    if (decoder.saslServer().isComplete()) {
                        Object object;
                        ctx.channel().writeAndFlush((Object)new AuthResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), serverChallenge, h.topologyId()));
                        extraPrincipals = new ArrayList<Object>();
                        String id = this.normalizeAuthorizationId(decoder.saslServer().getAuthorizationID());
                        extraPrincipals.add(new SimpleUserPrincipal(id));
                        extraPrincipals.add(new InetAddressPrincipal(((InetSocketAddress)ctx.channel().remoteAddress()).getAddress()));
                        SslHandler sslHandler = (SslHandler)ctx.pipeline().get("ssl");
                        try {
                            if (sslHandler == null) {
                                object = BoxedUnit.UNIT;
                                break block18;
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)extraPrincipals.add(sslHandler.engine().getSession().getPeerPrincipal()));
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            object = BoxedUnit.UNIT;
                        }
                        break block18;
                    } else {
                        response = new AuthResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), serverChallenge, h.topologyId());
                        return response;
                    }
                }
                response = this.createErrorResponse(h, this.log().invalidOperation());
                return response;
            }
            Enumeration.Value value9 = HotRodOperation$.MODULE$.SizeRequest();
            Enumeration.Value value11 = value;
            if (value9 == null) {
                if (value11 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value9.equals(value11)) throw new MatchError((Object)value);
            int size = cache.size();
            return new SizeResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), size);
        }
        decoder.subject_$eq(decoder.callbackHandler().getSubjectUserInfo(extraPrincipals).getSubject());
        String qop = (String)decoder.saslServer().getNegotiatedProperty("javax.security.sasl.qop");
        if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
            SaslQopHandler qopHandler = new SaslQopHandler(decoder.saslServer());
            boxedUnit = ctx.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
        } else {
            decoder.saslServer().dispose();
            decoder.callbackHandler_$eq(null);
            decoder.saslServer_$eq(null);
            boxedUnit = BoxedUnit.UNIT;
        }
        response = None$.MODULE$;
        return response;
    }

    @Override
    public Object customReadKey(HotRodHeader h, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache, HotRodServer server, Channel ch) {
        Enumeration.Value value;
        block15: {
            Object object;
            block8: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            Object object2;
                                            value = h.op();
                                            Enumeration.Value value2 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                                            Enumeration.Value value3 = value;
                                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block7;
                                            byte[] k = this.readKey(buffer);
                                            RequestParameters params = (RequestParameters)this.readParameters(h, buffer)._1();
                                            CacheEntry entry = cache.getCacheEntry((Object)k);
                                            if (entry == null) {
                                                object2 = this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), null);
                                            } else {
                                                boolean removed;
                                                byte[] prev = (byte[])entry.getValue();
                                                NumericVersion streamVersion = new NumericVersion(params.streamVersion());
                                                EntryVersion entryVersion = entry.getMetadata().version();
                                                NumericVersion numericVersion = streamVersion;
                                                object2 = !(entryVersion != null ? !entryVersion.equals(numericVersion) : numericVersion != null) ? ((removed = cache.remove((Object)k, (Object)prev)) ? this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.Success(), prev) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev)) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev);
                                            }
                                            object = object2;
                                            break block8;
                                        }
                                        Enumeration.Value value4 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                                        Enumeration.Value value5 = value;
                                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block9;
                                        byte[] k = this.readKey(buffer);
                                        object = cache.containsKey((Object)k) ? new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.Success(), h.topologyId()) : new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId());
                                        break block8;
                                    }
                                    Enumeration.Value value6 = HotRodOperation$.MODULE$.BulkGetRequest();
                                    Enumeration.Value value7 = value;
                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block10;
                                    int count = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                                    if (this.isTrace()) {
                                        this.trace((Function0<String>)new Serializable(){

                                            public final String apply() {
                                                return "About to create bulk response, count = %d";
                                            }
                                        }, BoxesRunTime.boxToInteger((int)count));
                                    }
                                    object = new BulkGetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.BulkGetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), count);
                                    break block8;
                                }
                                Enumeration.Value value8 = HotRodOperation$.MODULE$.BulkGetKeysRequest();
                                Enumeration.Value value9 = value;
                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block11;
                                int scope = ExtendedByteBuf$.MODULE$.readUnsignedInt(buffer);
                                if (this.isTrace()) {
                                    this.trace((Function0<String>)new Serializable(){

                                        public final String apply() {
                                            return "About to create bulk get keys response, scope = %d";
                                        }
                                    }, BoxesRunTime.boxToInteger((int)scope));
                                }
                                object = new BulkGetKeysResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.BulkGetKeysResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), scope);
                                break block8;
                            }
                            Enumeration.Value value10 = HotRodOperation$.MODULE$.GetWithMetadataRequest();
                            Enumeration.Value value11 = value;
                            if (value10 != null ? !value10.equals(value11) : value11 != null) break block12;
                            byte[] k = this.readKey(buffer);
                            object = this.getKeyMetadata(h, k, cache);
                            break block8;
                        }
                        Enumeration.Value value12 = HotRodOperation$.MODULE$.QueryRequest();
                        Enumeration.Value value13 = value;
                        if (value12 != null ? !value12.equals(value13) : value13 != null) break block13;
                        byte[] query = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                        byte[] result = ((QueryFacade)server.getQueryFacades().head()).query(cache, query);
                        object = new QueryResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), result);
                        break block8;
                    }
                    Enumeration.Value value14 = HotRodOperation$.MODULE$.AddClientListenerRequest();
                    Enumeration.Value value15 = value;
                    if (value14 != null ? !value14.equals(value15) : value15 != null) break block14;
                    byte[] listenerId = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                    boolean includeState = buffer.readByte() != 0;
                    Option<Tuple2<String, List<byte[]>>> filterFactoryInfo = this.readNamedFactory(buffer);
                    Option<Tuple2<String, List<byte[]>>> converterFactoryInfo = this.readNamedFactory(buffer);
                    ClientListenerRegistry reg = server.getClientListenerRegistry();
                    reg.addClientListener(ch, h, listenerId, cache, includeState, filterFactoryInfo, converterFactoryInfo);
                    object = this.createSuccessResponse(h, null);
                    break block8;
                }
                Enumeration.Value value16 = HotRodOperation$.MODULE$.RemoveClientListenerRequest();
                Enumeration.Value value17 = value;
                if (value16 != null ? !value16.equals(value17) : value17 != null) break block15;
                byte[] listenerId = ExtendedByteBuf$.MODULE$.readRangedBytes(buffer);
                ClientListenerRegistry reg = server.getClientListenerRegistry();
                boolean removed = reg.removeClientListener(listenerId, cache);
                object = removed ? this.createSuccessResponse(h, null) : this.createNotExecutedResponse(h, null);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Option<Tuple2<String, List<byte[]>>> readNamedFactory(ByteBuf buffer) {
        return this.readOptionalString(buffer).map((Function1)new Serializable(buffer){
            private final ByteBuf buffer$1;

            public final Tuple2<String, List<byte[]>> apply(String factoryName) {
                return new Tuple2((Object)factoryName, Decoder2x$.MODULE$.org$infinispan$server$hotrod$Decoder2x$$readOptionalParams(this.buffer$1));
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
    }

    private Option<String> readOptionalString(ByteBuf buffer) {
        String string = ExtendedByteBuf$.MODULE$.readString(buffer);
        return string.isEmpty() ? None$.MODULE$ : new Some((Object)string);
    }

    public List<byte[]> org$infinispan$server$hotrod$Decoder2x$$readOptionalParams(ByteBuf buffer) {
        List list;
        byte numParams = buffer.readByte();
        if (numParams > 0) {
            ObjectRef params = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)numParams).foreach((Function1)new Serializable(buffer, params){
                private final ByteBuf buffer$2;
                private final ObjectRef params$1;

                public final ListBuffer<byte[]> apply(int i) {
                    return ((ListBuffer)this.params$1.elem).$plus$eq((Object)ExtendedByteBuf$.MODULE$.readRangedBytes(this.buffer$2));
                }
                {
                    this.buffer$2 = buffer$2;
                    this.params$1 = params$1;
                }
            });
            list = ((ListBuffer)params.elem).toList();
        } else {
            list = List$.MODULE$.empty();
        }
        return list;
    }

    public GetWithMetadataResponse getKeyMetadata(HotRodHeader h, byte[] k, AdvancedCache<byte[], byte[]> cache) {
        GetWithMetadataResponse getWithMetadataResponse;
        CacheEntry ce = cache.getCacheEntry((Object)k);
        if (ce == null) {
            getWithMetadataResponse = new GetWithMetadataResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithMetadataResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$, 0L, -1L, -1, -1L, -1);
        } else {
            InternalCacheEntry ice = (InternalCacheEntry)ce;
            NumericVersion entryVersion = (NumericVersion)ice.getMetadata().version();
            byte[] v = (byte[])ce.getValue();
            int lifespan = ice.getLifespan() < 0L ? -1 : (int)(ice.getLifespan() / 1000L);
            int maxIdle = ice.getMaxIdle() < 0L ? -1 : (int)(ice.getMaxIdle() / 1000L);
            getWithMetadataResponse = new GetWithMetadataResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithMetadataResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)v), entryVersion.getVersion(), ice.getCreated(), lifespan, ice.getLastUsed(), maxIdle);
        }
        return getWithMetadataResponse;
    }

    @Override
    public Object customReadValue(HotRodHeader header, ByteBuf buffer, AdvancedCache<byte[], byte[]> cache) {
        return null;
    }

    @Override
    public Object createStatsResponse(HotRodHeader h, Stats cacheStats, NettyTransport t) {
        Map stats = Map$.MODULE$.empty();
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeSinceStart"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTimeSinceStart())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentNumberOfEntries"), (Object)((Object)BoxesRunTime.boxToInteger((int)cacheStats.getCurrentNumberOfEntries())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalNumberOfEntries"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTotalNumberOfEntries())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stores"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getStores())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retrievals"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRetrievals())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hits"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getHits())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"misses"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getMisses())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"removeHits"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveHits())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"removeMisses"), (Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveMisses())).toString()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesRead"), (Object)t.getTotalBytesRead()));
        stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWritten"), (Object)t.getTotalBytesWritten()));
        return new StatsResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), (scala.collection.immutable.Map<String, String>)((MapLike)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)stats), h.topologyId());
    }

    @Override
    public ErrorResponse createErrorResponse(HotRodHeader h, Throwable t) {
        Throwable throwable;
        block8: {
            ErrorResponse errorResponse;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    throwable = t;
                                    if (!(throwable instanceof SuspectException)) break block2;
                                    errorResponse = this.createNodeSuspectedErrorResponse(h, t);
                                    break block3;
                                }
                                if (!(throwable instanceof IllegalLifecycleStateException)) break block4;
                                errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.IllegalLifecycleState(), h.topologyId(), t.toString());
                                break block3;
                            }
                            if (!(throwable instanceof IOException)) break block5;
                            IOException iOException = (IOException)throwable;
                            errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ParseError(), h.topologyId(), iOException.toString());
                            break block3;
                        }
                        if (!(throwable instanceof TimeoutException)) break block6;
                        TimeoutException timeoutException = (TimeoutException)throwable;
                        errorResponse = new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.OperationTimedOut(), h.topologyId(), timeoutException.toString());
                        break block3;
                    }
                    if (!(throwable instanceof CacheException)) break block7;
                    CacheException cacheException = (CacheException)throwable;
                    Throwable throwable2 = cacheException.getCause();
                    ErrorResponse errorResponse2 = throwable2 instanceof SuspectedException ? this.createNodeSuspectedErrorResponse(h, t) : this.createServerErrorResponse(h, t);
                    errorResponse = errorResponse2;
                    break block3;
                }
                if (throwable == null) break block8;
                Throwable throwable3 = throwable;
                errorResponse = this.createServerErrorResponse(h, throwable3);
            }
            return errorResponse;
        }
        throw new MatchError((Object)throwable);
    }

    private ErrorResponse createNodeSuspectedErrorResponse(HotRodHeader h, Throwable t) {
        return new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.NodeSuspected(), h.topologyId(), t.toString());
    }

    private ErrorResponse createServerErrorResponse(HotRodHeader h, Throwable t) {
        return new ErrorResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ServerError(), h.topologyId(), t.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AdvancedCache<byte[], byte[]> getOptimizedCache(HotRodHeader h, AdvancedCache<byte[], byte[]> c) {
        void var3_3;
        boolean bl;
        AdvancedCache optCache = c;
        Enumeration.Value value = h.op();
        Enumeration.Value value2 = Operation$.MODULE$.PutIfAbsentRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value8 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                    Enumeration.Value value9 = value;
                    bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
                }
            }
        }
        if (bl && !this.isCacheTransactional(optCache)) {
            this.warnConditionalOperationNonTransactional(h.op().toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (this.hasFlag(h, ProtocolFlag$.MODULE$.SkipCacheLoader())) {
            boolean bl2;
            Enumeration.Value value10 = h.op();
            Enumeration.Value value11 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value13 = Operation$.MODULE$.GetRequest();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    bl2 = true;
                } else {
                    Enumeration.Value value15 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        bl2 = true;
                    } else {
                        Enumeration.Value value17 = Operation$.MODULE$.RemoveRequest();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            bl2 = true;
                        } else {
                            Enumeration.Value value19 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                            Enumeration.Value value20 = value10;
                            if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                bl2 = true;
                            } else {
                                Enumeration.Value value21 = HotRodOperation$.MODULE$.BulkGetRequest();
                                Enumeration.Value value22 = value10;
                                if (!(value21 != null ? !value21.equals(value22) : value22 != null)) {
                                    bl2 = true;
                                } else {
                                    Enumeration.Value value23 = HotRodOperation$.MODULE$.GetWithMetadataRequest();
                                    Enumeration.Value value24 = value10;
                                    if (!(value23 != null ? !value23.equals(value24) : value24 != null)) {
                                        bl2 = true;
                                    } else {
                                        Enumeration.Value value25 = HotRodOperation$.MODULE$.BulkGetKeysRequest();
                                        Enumeration.Value value26 = value10;
                                        bl2 = !(value25 != null ? !value25.equals(value26) : value26 != null);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl2) {
                optCache = optCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (this.hasFlag(h, ProtocolFlag$.MODULE$.SkipIndexing())) {
            boolean bl3;
            Enumeration.Value value27 = h.op();
            Enumeration.Value value28 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value29 = value27;
            if (!(value28 != null ? !value28.equals(value29) : value29 != null)) {
                bl3 = true;
            } else {
                Enumeration.Value value30 = Operation$.MODULE$.PutIfAbsentRequest();
                Enumeration.Value value31 = value27;
                if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
                    bl3 = true;
                } else {
                    Enumeration.Value value32 = Operation$.MODULE$.RemoveRequest();
                    Enumeration.Value value33 = value27;
                    if (!(value32 != null ? !value32.equals(value33) : value33 != null)) {
                        bl3 = true;
                    } else {
                        Enumeration.Value value34 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                        Enumeration.Value value35 = value27;
                        if (!(value34 != null ? !value34.equals(value35) : value35 != null)) {
                            bl3 = true;
                        } else {
                            Enumeration.Value value36 = Operation$.MODULE$.ReplaceRequest();
                            Enumeration.Value value37 = value27;
                            if (!(value36 != null ? !value36.equals(value37) : value37 != null)) {
                                bl3 = true;
                            } else {
                                Enumeration.Value value38 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                                Enumeration.Value value39 = value27;
                                bl3 = !(value38 != null ? !value38.equals(value39) : value39 != null);
                            }
                        }
                    }
                }
            }
            if (bl3) {
                optCache = optCache.withFlags(new Flag[]{Flag.SKIP_INDEXING});
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (this.hasFlag(h, ProtocolFlag$.MODULE$.ForceReturnPreviousValue())) {
            if (!this.isCacheTransactional(optCache)) {
                this.warnForceReturnPreviousNonTransactional(h.op().toString());
            }
        } else {
            boolean bl4;
            Enumeration.Value value40 = h.op();
            Enumeration.Value value41 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value42 = value40;
            if (!(value41 != null ? !value41.equals(value42) : value42 != null)) {
                bl4 = true;
            } else {
                Enumeration.Value value43 = Operation$.MODULE$.PutIfAbsentRequest();
                Enumeration.Value value44 = value40;
                bl4 = !(value43 != null ? !value43.equals(value44) : value44 != null);
            }
            if (bl4) {
                optCache = optCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return var3_3;
    }

    private boolean isCacheTransactional(AdvancedCache<byte[], byte[]> c) {
        return SecurityActions.getCacheConfiguration(c).transaction().transactionMode().isTransactional();
    }

    public String normalizeAuthorizationId(String id) {
        int realm = id.indexOf(64);
        return realm >= 0 ? id.substring(0, realm) : id;
    }

    private Decoder2x$() {
        MODULE$ = this;
        ServerConstants.class.$init$((ServerConstants)this);
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log$class.$init$(this);
        this.isTrace = this.isTraceEnabled();
    }
}

