/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!)\u0001\u0004\u0001C\u00013\u00059B/Z:u+N,'\u000fR3gS:,G\rV5nK>,Ho\u001d\u000b\u00025A\u0011QbG\u0005\u000399\u0011A!\u00168ji\")a\u0004\u0001C\u00013\u0005!B/Z:u\u0019\u0006T\u0018\u0010T8bIR{\u0007o\u001c7pOfDQ\u0001\t\u0001\u0005\u0002e\t!\u0006^3tiJ+\u0007/Z1uC\ndWMU3bI&\u001bx\u000e\\1uS>tG*\u001a<fYZ\u000bG.\u001b3bi&|g\u000e\u000b\u0003 E)Z\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003-\tgN\\8uCRLwN\\:\u000b\u0005\u001dB\u0011A\u0002;fgRtw-\u0003\u0002*I\t!A+Z:u\u0003I)\u0007\u0010]3di\u0016$W\t_2faRLwN\\:-\u00031\u001a\u0013!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\tqaY8n[>t7/\u0003\u00023_\tY2)Y2iK\u000e{gNZ5hkJ\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001\u000e\u0001\u0005\u0002e\t\u0001\u0006^3tiN+'/[1mSj\f'\r\\3Jg>d\u0017\r^5p]2+g/\u001a7WC2LG-\u0019;j_:DCa\r\u0012+m1\nA\u0006C\u00039\u0001\u0011%\u0011(A\nxSRD7\t\\;ti\u0016\u0014X\rZ*feZ,'\u000f\u0006\u0002;\u0017R\u0011!d\u000f\u0005\u0006y]\u0002\r!P\u0001\u0007CN\u001cXM\u001d;\u0011\u000b5q\u0004\t\u0013\u000e\n\u0005}r!!\u0003$v]\u000e$\u0018n\u001c83!\t\te)D\u0001C\u0015\t\u0019E)A\u0003dC\u000eDWM\u0003\u0002F\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\u0012\"\u0003\u001b\r{gNZ5hkJ\fG/[8o!\ti\u0011*\u0003\u0002K\u001d\t!Aj\u001c8h\u0011\u0015au\u00071\u0001N\u0003\u001d\u0011W/\u001b7eKJ\u0004\"A\u0014)\u000e\u0003=S!!\u0012\u0002\n\u0005E{%\u0001\t%piJ{GmU3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0014U/\u001b7eKJDQa\u0015\u0001\u0005\nQ\u000baC^1mS\u0012\fG/Z%t_2\fG/[8o\u0019\u00164X\r\u001c\u000b\u00035UCQA\u0016*A\u0002]\u000ba\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000e\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005q3\u0011\u0001B;uS2L!AX-\u0003\u001d%\u001bx\u000e\\1uS>tG*\u001a<fY\"2\u0001A\t1bI\u0016\faa\u001a:pkB\u001cH&\u00012\"\u0003\r\f!BZ;oGRLwN\\1m\u0003!!Xm\u001d;OC6,\u0017%\u00014\u0002KM,'O^3s]!|GO]8e]!{GOU8e\u0007>tg-[4ve\u0006$\u0018n\u001c8UKN$\b")
public class HotRodConfigurationTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.persistence().stores().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                ClusterLoaderConfiguration clcfg = (ClusterLoaderConfiguration)cfg.persistence().stores().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testRepeatableReadIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.REPEATABLE_READ);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSerializableIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.SERIALIZABLE);
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration()), (Function1)new Serializable(this, builder, function2){
            public static final long serialVersionUID = 0L;
            private final HotRodServerConfigurationBuilder builder$1;
            public final Function2 assert$1;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.builder$1), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$withClusteredServer$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(HotRodServer server) {
                        Configuration cfg = this.cm$1.getCache("___hotRodTopologyCache").getCacheConfiguration();
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
                this.assert$1 = assert$1;
            }
        });
    }

    private void validateIsolationLevel(IsolationLevel isolationLevel) {
        HotRodServerConfigurationBuilder hotRodBuilder = new HotRodServerConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().isolationLevel(isolationLevel);
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(builder)), (Function1)new Serializable(this, hotRodBuilder){
            public static final long serialVersionUID = 0L;
            private final HotRodServerConfigurationBuilder hotRodBuilder$1;

            public final void apply(EmbeddedCacheManager cm) {
                HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.hotRodBuilder$1);
            }
            {
                this.hotRodBuilder$1 = hotRodBuilder$1;
            }
        });
    }
}

