/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.server.hotrod.DecoderRequirements;

public enum HotRodOperation {
    PutRequest(true, true, DecoderRequirements.VALUE, true),
    PutIfAbsentRequest(true, true, DecoderRequirements.VALUE, true),
    ReplaceRequest(true, true, DecoderRequirements.VALUE, true),
    ReplaceIfUnmodifiedRequest(true, true, DecoderRequirements.VALUE, true),
    ContainsKeyRequest(true, false, DecoderRequirements.KEY, true),
    GetRequest(true, false, DecoderRequirements.KEY, true),
    GetWithVersionRequest(true, false, DecoderRequirements.KEY, true),
    GetWithMetadataRequest(true, false, DecoderRequirements.KEY, true),
    RemoveRequest(true, false, DecoderRequirements.KEY, true),
    RemoveIfUnmodifiedRequest(true, false, DecoderRequirements.PARAMETERS, true),
    PingRequest(false, false, DecoderRequirements.HEADER, false),
    StatsRequest(false, false, DecoderRequirements.HEADER, true),
    ClearRequest(false, false, DecoderRequirements.HEADER, true),
    SizeRequest(false, false, DecoderRequirements.HEADER, true),
    AuthMechListRequest(false, false, DecoderRequirements.HEADER, false),
    AuthRequest(false, false, DecoderRequirements.HEADER_CUSTOM, false),
    ExecRequest(false, false, DecoderRequirements.HEADER_CUSTOM, true),
    BulkGetRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    BulkGetKeysRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    QueryRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    AddClientListenerRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    RemoveClientListenerRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    IterationStartRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    IterationNextRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    IterationEndRequest(false, false, DecoderRequirements.KEY_CUSTOM, true),
    PutAllRequest(false, false, DecoderRequirements.VALUE_CUSTOM, true),
    GetAllRequest(false, false, DecoderRequirements.VALUE_CUSTOM, true);

    private final boolean requiresKey;
    private final boolean requiresValue;
    private final DecoderRequirements decodeRequirements;
    private final boolean requiresAuthentication;

    private HotRodOperation(boolean requiresKey, boolean requiresValue, DecoderRequirements decodeRequirements, boolean requiresAuthentication) {
        this.requiresKey = requiresKey;
        this.requiresValue = requiresValue;
        this.decodeRequirements = decodeRequirements;
        this.requiresAuthentication = requiresAuthentication;
    }

    DecoderRequirements getDecoderRequirements() {
        return this.decodeRequirements;
    }

    boolean requiresKey() {
        return this.requiresKey;
    }

    boolean requireValue() {
        return this.requiresValue;
    }

    boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    boolean canSkipIndexing() {
        switch (this) {
            case PutRequest: 
            case RemoveRequest: 
            case PutIfAbsentRequest: 
            case RemoveIfUnmodifiedRequest: 
            case ReplaceRequest: 
            case ReplaceIfUnmodifiedRequest: 
            case PutAllRequest: {
                return true;
            }
        }
        return false;
    }

    boolean canSkipCacheLoading() {
        switch (this) {
            case PutRequest: 
            case RemoveRequest: 
            case PutAllRequest: 
            case GetRequest: 
            case GetWithVersionRequest: 
            case ContainsKeyRequest: 
            case BulkGetRequest: 
            case GetWithMetadataRequest: 
            case BulkGetKeysRequest: {
                return true;
            }
        }
        return false;
    }

    boolean isNotConditionalAndCanReturnPrevious() {
        return this == PutRequest;
    }

    boolean canReturnPreviousValue() {
        switch (this) {
            case PutRequest: 
            case RemoveRequest: 
            case PutIfAbsentRequest: 
            case RemoveIfUnmodifiedRequest: 
            case ReplaceRequest: 
            case ReplaceIfUnmodifiedRequest: {
                return true;
            }
        }
        return false;
    }

    boolean isConditional() {
        switch (this) {
            case PutIfAbsentRequest: 
            case RemoveIfUnmodifiedRequest: 
            case ReplaceRequest: 
            case ReplaceIfUnmodifiedRequest: {
                return true;
            }
        }
        return false;
    }
}

