/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

public class Constants {
    public static final short MAGIC_REQ = 160;
    public static final short MAGIC_RES = 161;
    public static final byte VERSION_10 = 10;
    public static final byte VERSION_11 = 11;
    public static final byte VERSION_12 = 12;
    public static final byte VERSION_13 = 13;
    public static final byte VERSION_20 = 20;
    public static final byte VERSION_21 = 21;
    public static final byte VERSION_22 = 22;
    public static final byte VERSION_23 = 23;
    public static final byte VERSION_24 = 24;
    public static final byte VERSION_25 = 25;
    public static final byte DEFAULT_CONSISTENT_HASH_VERSION_1x = 2;
    public static final byte DEFAULT_CONSISTENT_HASH_VERSION = 3;
    public static final byte INTELLIGENCE_BASIC = 1;
    public static final byte INTELLIGENCE_TOPOLOGY_AWARE = 2;
    public static final byte INTELLIGENCE_HASH_DISTRIBUTION_AWARE = 3;
    public static final byte INFINITE_LIFESPAN = 1;
    public static final byte INFINITE_MAXIDLE = 2;
    public static final int DEFAULT_TOPOLOGY_ID = -1;

    private Constants() {
    }

    public static final boolean isVersion10(byte v) {
        return v == 10;
    }

    public static final boolean isVersion11(byte v) {
        return v == 11;
    }

    public static final boolean isVersion12(byte v) {
        return v == 12;
    }

    public static final boolean isVersion13(byte v) {
        return v == 13;
    }

    public static final boolean isVersion1x(byte v) {
        return v >= 10 && v <= 13;
    }

    public static final boolean isVersion2x(byte v) {
        return v >= 20 && v <= 25;
    }

    public static final boolean isVersionKnown(byte v) {
        return Constants.isVersion1x(v) || Constants.isVersion2x(v);
    }

    public static boolean isVersionPre22(byte v) {
        return Constants.isVersion1x(v) || v == 20 || v == 21;
    }

    public static boolean isVersionPre24(byte v) {
        return Constants.isVersion1x(v) || v >= 20 && v <= 23;
    }

    public static boolean isVersionPost20(byte v) {
        return v >= 21 && v <= 25;
    }

    public static boolean isVersionPost24(byte v) {
        return v > 24;
    }
}

