/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001-\u0011q\u0003S8u%>$\u0017\u0007\r*fa2L7-\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u00025piJ|GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t\u0019\u0002j\u001c;S_\u0012lU\u000f\u001c;j\u001d>$W\rV3ti\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005RY\t\u0011bY1dQ\u0016t\u0015-\\3\u0016\u0003]\u0001\"\u0001\u0007\u0010\u000f\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;iAQA\t\u0001\u0005R\r\n\u0011c\u0019:fCR,7)Y2iK\u000e{gNZ5h+\u0005!\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015\u0019\u0017m\u00195f\u0015\tIc!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003W\u0019\u0012AcQ8oM&<WO]1uS>t')^5mI\u0016\u0014\b\"B\u0017\u0001\t#r\u0013a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0016\u0003=\u0002\"!\u0007\u0019\n\u0005ER\"\u0001\u0002\"zi\u0016DQa\r\u0001\u0005\u0002Q\n\u0011\u0003^3tiJ+\u0007\u000f\\5dCR,G\rU;u)\t)\u0004\b\u0005\u0002\u001am%\u0011qG\u0007\u0002\u0005+:LG\u000fC\u0003:e\u0001\u0007!(A\u0001n!\tY$)D\u0001=\u0015\tid(A\u0004sK\u001adWm\u0019;\u000b\u0005}\u0002\u0015\u0001\u00027b]\u001eT\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002Dy\t1Q*\u001a;i_\u0012DQ!\u0012\u0001\u0005\u0002\u0019\u000b\u0011\u0004^3tiJ+\u0007\u000f\\5dCR,G\rU;u\u0013\u001a\f%m]3oiR\u0011Qg\u0012\u0005\u0006s\u0011\u0003\rA\u000f\u0005\u0006\u0013\u0002!\tAS\u0001\u0016i\u0016\u001cHOU3qY&\u001c\u0017\r^3e%\u0016\u0004H.Y2f)\t)4\nC\u0003:\u0011\u0002\u0007!\bC\u0003N\u0001\u0011\u0005a*A\u0010uKN$\b+\u001b8h/&$\b\u000eV8q_2|w-_!xCJ,7\t\\5f]R$\u0012!\u000e\u0005\u0006!\u0002!\t!U\u0001%i\u0016\u001cHOU3qY&\u001c\u0017\r^3e!V$x+\u001b;i)>\u0004x\u000e\\8hs\u000eC\u0017M\\4fgR\u0011QG\u0015\u0005\u0006s=\u0003\rA\u000f\u0005\u0006)\u0002!\t\"V\u0001\u0016G\",7m\u001b+pa>dwnZ=SK\u000e,\u0017N^3e)\u0011)dKX8\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u0011Q|\u0007o\u001c*fgB\u0004\"!\u0017/\u000e\u0003iS!a\u0017\u0002\u0002\tQ,7\u000f^\u0005\u0003;j\u0013\u0011%\u00112tiJ\f7\r\u001e+fgR$v\u000e]8m_\u001eL\u0018i^1sKJ+7\u000f]8og\u0016DQaX*A\u0002\u0001\fqa]3sm\u0016\u00148\u000fE\u0002bS2t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015T\u0011A\u0002\u001fs_>$h(C\u0001\u001c\u0013\tA'$A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'\u0001\u0002'jgRT!\u0001\u001b\u000e\u0011\u00055i\u0017B\u00018\u0003\u00051Au\u000e\u001e*pIN+'O^3s\u0011\u0015)2\u000b1\u0001\u0018Q\u0011\u0019\u0016/\u001f>\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018aC1o]>$\u0018\r^5p]NT!A\u001e\u0005\u0002\rQ,7\u000f\u001e8h\u0013\tA8O\u0001\u0003UKN$\u0018aB3oC\ndW\rZ\r\u0002\u0001!B\u0001!\u001d?~\u0003\u0003\t\u0019!\u0001\u0004he>,\bo\u001d\u0017\u0002}\u0006\nq0\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0003\u0003\u000b\t1e]3sm\u0016\u0014h\u0006[8ue>$g\u0006S8u%>$'+\u001a9mS\u000e\fG/[8o)\u0016\u001cH\u000f")
public class HotRod10ReplicationTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodReplSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder config = HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return var1_1;
    }

    @Override
    public byte protocolVersion() {
        return 10;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)this.clients().head()).assertGet(m));
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m));
        TestResponse resp = ((HotRodClient)this.clients().head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(((HotRodClient)((IterableLike)this.clients().tail()).head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-")), OperationStatus.OperationNotExecuted);
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.OperationNotExecuted);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.OperationNotExecuted);
        ((HotRodClient)((IterableLike)this.clients().tail()).head()).assertPut(m);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)this.clients().head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = ((HotRodClient)this.clients().head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 1 + this.nodeCount());
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
    }

    /*
     * WARNING - void declaration
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1 + this.nodeCount());
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        try {
            TestResponse resp2 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)2, 1 + this.nodeCount());
            HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus.Success);
            Assert.assertEquals((int)resp2.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp = resp2.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp.members.size(), (int)(this.nodeCount() + 1));
            ServerAddress serverAddress = newServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$1) {
                    return x$1.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$2;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(this.topoResp$2.members).exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$1;

                        public final boolean apply(ServerAddress x$3) {
                            ServerAddress serverAddress = x$3;
                            ServerAddress serverAddress2 = this.addr$1;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$1 = addr$1;
                        }
                    }));
                }
                {
                    this.topoResp$2 = topoResp$2;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        }
        catch (Throwable throwable) {
            void var3_3;
            this.stopClusteredServer((HotRodServer)var3_3);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(newServer);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)2, 1 + this.nodeCount() + 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        ObjectRef topoResp = ObjectRef.create((Object)resp.asTopologyAwareResponse());
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members.size(), (int)this.nodeCount());
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$4) {
                return x$4.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members).exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$2;

                    public final boolean apply(ServerAddress x$5) {
                        ServerAddress serverAddress = x$5;
                        ServerAddress serverAddress2 = this.addr$2;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$2 = addr$2;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25, true);
        try {
            TestResponse resp3 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)2, 1 + this.nodeCount() + 2);
            HotRodTestingUtil$.MODULE$.assertStatus(resp3, OperationStatus.Success);
            Assert.assertEquals((int)resp3.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp2 = resp3.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp2.members.size(), (int)(this.nodeCount() + 1));
            ServerAddress serverAddress = crashingServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$6) {
                    return x$6.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp2){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$3;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(this.topoResp$3.members).exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$3;

                        public final boolean apply(ServerAddress x$8) {
                            ServerAddress serverAddress = x$8;
                            ServerAddress serverAddress2 = this.addr$3;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$3 = addr$3;
                        }
                    }));
                }
                {
                    this.topoResp$3 = topoResp$3;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
        }
        catch (Throwable throwable) {
            void var9_8;
            this.stopClusteredServer((HotRodServer)var9_8);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(crashingServer);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)2, 1 + this.nodeCount() + 3);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        topoResp.elem = resp.asTopologyAwareResponse();
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members.size(), (int)this.nodeCount());
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$9) {
                return x$9.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members).exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$4;

                    public final boolean apply(ServerAddress x$10) {
                        ServerAddress serverAddress = x$10;
                        ServerAddress serverAddress2 = this.addr$4;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$4 = addr$4;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 1 + this.nodeCount());
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        this.checkTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }

    @Test(enabled=false)
    public void checkTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName) {
        HotRodTestingUtil$.MODULE$.assertNoHashTopologyReceived(topoResp, servers, cacheName, this.currentServerTopologyId());
    }
}

