/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.function.Consumer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\u0007\u0003\u0011!Xm\u001d;\n\u0005Eq!AF!cgR\u0014\u0018m\u0019;J]\u001aLg.[:qC:$Vm\u001d;\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012a\u0006;fgR,6/\u001a:EK\u001aLg.\u001a3US6,w.\u001e;t)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0001\u0005\u0002e\tA\u0003^3ti2\u000b'0\u001f'pC\u0012$v\u000e]8m_\u001eL\b\"B\u0012\u0001\t\u0003I\u0012A\u000b;fgR\u0014V\r]3bi\u0006\u0014G.\u001a*fC\u0012L5o\u001c7bi&|g\u000eT3wK24\u0016\r\\5eCRLwN\u001c\u0015\u0005E\u0015jc\u0006\u0005\u0002'W5\tqE\u0003\u0002)S\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\tQ\u0003\"\u0001\u0004uKN$hnZ\u0005\u0003Y\u001d\u0012A\u0001V3ti\u0006\u0011R\r\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8tY\u0005y3%\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M2\u0011aB2p[6|gn]\u0005\u0003kI\u00121dQ1dQ\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t\u0007\"B\u001c\u0001\t\u0003I\u0012\u0001\u000b;fgR\u001cVM]5bY&T\u0018M\u00197f\u0013N|G.\u0019;j_:dUM^3m-\u0006d\u0017\u000eZ1uS>t\u0007\u0006\u0002\u001c&[eb\u0013a\f\u0005\u0006w\u0001!\t!G\u00018i\u0016\u001cHOU3qK\u0006$\u0018M\u00197f%\u0016\fG-S:pY\u0006$\u0018n\u001c8MKZ,GnV5uQN[Wm^\"iK\u000e\\g+\u00197jI\u0006$\u0018n\u001c8\t\u000bu\u0002A\u0011\u0002 \u0002']LG\u000f[\"mkN$XM]3e'\u0016\u0014h/\u001a:\u0015\u0005}\u0002FC\u0001\u000eA\u0011\u0015\tE\b1\u0001C\u0003\u0019\t7o]3siB)1dQ#N5%\u0011A\t\b\u0002\n\rVt7\r^5p]J\u0002\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u000b\r\f7\r[3\u000b\u0005)3\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002M\u000f\ni1i\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u0007(\n\u0005=c\"\u0001\u0002'p]\u001eDQ!\u0015\u001fA\u0002I\u000bqAY;jY\u0012,'\u000f\u0005\u0002T+6\tAK\u0003\u0002K\u0005%\u0011a\u000b\u0016\u0002!\u0011>$(k\u001c3TKJ4XM]\"p]\u001aLw-\u001e:bi&|gNQ;jY\u0012,'\u000fC\u0003Y\u0001\u0011%\u0011,\u0001\fwC2LG-\u0019;f\u0013N|G.\u0019;j_:dUM^3m)\rQ\"\f\u001a\u0005\u00067^\u0003\r\u0001X\u0001\u000fSN|G.\u0019;j_:dUM^3m!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0019\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003Gz\u0013a\"S:pY\u0006$\u0018n\u001c8MKZ,G\u000eC\u0003f/\u0002\u0007a-A\u0005xe&$XmU6foB\u00111dZ\u0005\u0003Qr\u0011qAQ8pY\u0016\fg\u000e\u000b\u0004\u0001K)\\gn\\\u0001\u0007OJ|W\u000f]:-\u00031\f\u0013!\\\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0003A\fQe]3sm\u0016\u0014h\u0006[8ue>$g\u0006S8u%>$7i\u001c8gS\u001e,(/\u0019;j_:$Vm\u001d;")
public class HotRodConfigurationTest
extends AbstractInfinispanTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().remoteTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.persistence().stores().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().remoteTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                ClusterLoaderConfiguration clcfg = (ClusterLoaderConfiguration)cfg.persistence().stores().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testRepeatableReadIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.REPEATABLE_READ, false);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSerializableIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.SERIALIZABLE, false);
    }

    public void testRepeatableReadIsolationLevelWithSkewCheckValidation() {
        this.validateIsolationLevel(IsolationLevel.REPEATABLE_READ, true);
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration()), (Consumer)new Consumer<EmbeddedCacheManager>(this, builder, function2){
            private final HotRodServerConfigurationBuilder builder$1;
            public final Function2 assert$1;

            public void accept(EmbeddedCacheManager cm) {
                Stoppable.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.builder$1), (Consumer)new Consumer<HotRodServer>(this, cm){
                    private final /* synthetic */ $anon$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public void accept(HotRodServer server) {
                        Configuration cfg = this.cm$1.getCache("___hotRodTopologyCache").getCacheConfiguration();
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
                this.assert$1 = assert$1;
            }
        });
    }

    private void validateIsolationLevel(IsolationLevel isolationLevel, boolean writeSkew) {
        HotRodServerConfigurationBuilder hotRodBuilder = new HotRodServerConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().isolationLevel(isolationLevel).writeSkewCheck(writeSkew);
        Object object = writeSkew ? builder.versioning().enable().scheme(VersioningScheme.SIMPLE) : BoxedUnit.UNIT;
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(builder)), (Consumer)new Consumer<EmbeddedCacheManager>(this, hotRodBuilder){
            private final HotRodServerConfigurationBuilder hotRodBuilder$1;

            public void accept(EmbeddedCacheManager cm) {
                Stoppable.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.hotRodBuilder$1), (Consumer)new Consumer<HotRodServer>(this){

                    public void accept(HotRodServer server) {
                    }
                });
            }
            {
                this.hotRodBuilder$1 = hotRodBuilder$1;
            }
        });
    }
}

