/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011Q\u0003S8u%>$'+\u001a9mS\u000e\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003'!{GOU8e\u001bVdG/\u001b(pI\u0016$Vm\u001d;\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002CA\u0007\u0001\u0011\u0015)\u0002\u0001\"\u0015\u0017\u0003%\u0019\u0017m\u00195f\u001d\u0006lW-F\u0001\u0018!\tAbD\u0004\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u001b\u0011\u0015\u0011\u0003\u0001\"\u0015$\u0003E\u0019'/Z1uK\u000e\u000b7\r[3D_:4\u0017nZ\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003S\u0019\tQbY8oM&<WO]1uS>t\u0017BA\u0016'\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\")Q\u0006\u0001C\u0001]\u0005\tB/Z:u%\u0016\u0004H.[2bi\u0016$\u0007+\u001e;\u0015\u0005=\u0012\u0004CA\r1\u0013\t\t$D\u0001\u0003V]&$\b\"B\u001a-\u0001\u0004!\u0014!A7\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014a\u0002:fM2,7\r\u001e\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f7\u0005\u0019iU\r\u001e5pI\")q\b\u0001C\u0001\u0001\u0006IB/Z:u%\u0016\u0004H.[2bi\u0016$\u0007+\u001e;JM\u0006\u00137/\u001a8u)\ty\u0013\tC\u00034}\u0001\u0007A\u0007C\u0003D\u0001\u0011\u0005A)A\u000buKN$(+\u001a9mS\u000e\fG/\u001a3SKBd\u0017mY3\u0015\u0005=*\u0005\"B\u001aC\u0001\u0004!\u0004\"B$\u0001\t\u0003A\u0015a\b;fgR\u0004\u0016N\\4XSRDGk\u001c9pY><\u00170Q<be\u0016\u001cE.[3oiR\tq\u0006C\u0003K\u0001\u0011\u00051*\u0001\u0013uKN$(+\u001a9mS\u000e\fG/\u001a3QkR<\u0016\u000e\u001e5U_B|Gn\\4z\u0007\"\fgnZ3t)\tyC\nC\u00034\u0013\u0002\u0007A\u0007C\u0003O\u0001\u0011\u0005q*\u0001\u0005uKN$8+\u001b>f)\ty\u0003\u000bC\u00034\u001b\u0002\u0007A\u0007C\u0003S\u0001\u0011E1+A\u000bdQ\u0016\u001c7\u000eV8q_2|w-\u001f*fG\u0016Lg/\u001a3\u0015\t=\"F,\u001c\u0005\u0006+F\u0003\rAV\u0001\ti>\u0004xNU3taB\u0011qKW\u0007\u00021*\u0011\u0011LA\u0001\u0005i\u0016\u001cH/\u0003\u0002\\1\n\t\u0013IY:ue\u0006\u001cG\u000fV3tiR{\u0007o\u001c7pOf\fu/\u0019:f%\u0016\u001c\bo\u001c8tK\")Q,\u0015a\u0001=\u000691/\u001a:wKJ\u001c\bcA0hU:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G*\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005\u0019T\u0012a\u00029bG.\fw-Z\u0005\u0003Q&\u0014A\u0001T5ti*\u0011aM\u0007\t\u0003\u001b-L!\u0001\u001c\u0002\u0003\u0019!{GOU8e'\u0016\u0014h/\u001a:\t\u000bU\t\u0006\u0019A\f)\tE{w\u000f\u001f\t\u0003aVl\u0011!\u001d\u0006\u0003eN\f1\"\u00198o_R\fG/[8og*\u0011A\u000fC\u0001\u0007i\u0016\u001cHO\\4\n\u0005Y\f(\u0001\u0002+fgR\fq!\u001a8bE2,G-G\u0001\u0001Q\u0019\u0001qN_>\u007f\u007f\u00061qM]8vaNd\u0013\u0001`\u0011\u0002{\u0006Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#!!\u0001\u0002GM,'O^3s]!|GO]8e]!{GOU8e%\u0016\u0004H.[2bi&|g\u000eV3ti\u0002")
public class HotRodReplicationTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodReplSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder config = HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return var1_1;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)this.clients().head()).assertGet(m));
        HotRodTestingUtil$.MODULE$.assertKeyDoesNotExist(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m));
        TestResponse resp = ((HotRodClient)this.clients().head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(((HotRodClient)((IterableLike)this.clients().tail()).head()).putIfAbsent(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-")), OperationStatus.OperationNotExecuted);
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.OperationNotExecuted);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.OperationNotExecuted);
        ((HotRodClient)((IterableLike)this.clients().tail()).head()).assertPut(m);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)this.clients().head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v1-"));
        resp = ((HotRodClient)this.clients().head()).replace(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"));
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).assertGet(m), HotRodTestingUtil$.MODULE$.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = ((HotRodClient)this.clients().head()).ping();
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = ((HotRodClient)this.clients().head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).ping((byte)2, 1 + this.nodeCount());
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
    }

    /*
     * WARNING - void declaration
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), (byte)1, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)((IterableLike)this.clients().tail()).head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil$.MODULE$.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), (byte)2, 1 + this.nodeCount());
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        try {
            TestResponse resp2 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), (byte)2, 1 + this.nodeCount());
            HotRodTestingUtil$.MODULE$.assertStatus(resp2, OperationStatus.Success);
            Assert.assertEquals((int)resp2.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp = resp2.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp.members.size(), (int)3);
            ServerAddress serverAddress = newServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$1) {
                    return x$1.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$2;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(this.topoResp$2.members).exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$1;

                        public final boolean apply(ServerAddress x$3) {
                            ServerAddress serverAddress = x$3;
                            ServerAddress serverAddress2 = this.addr$1;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$1 = addr$1;
                        }
                    }));
                }
                {
                    this.topoResp$2 = topoResp$2;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        }
        catch (Throwable throwable) {
            void var3_3;
            this.stopClusteredServer((HotRodServer)var3_3);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(newServer);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), (byte)2, 1 + this.nodeCount() + 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        ObjectRef topoResp = ObjectRef.create((Object)resp.asTopologyAwareResponse());
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members.size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$4) {
                return x$4.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members).exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$2;

                    public final boolean apply(ServerAddress x$5) {
                        ServerAddress serverAddress = x$5;
                        ServerAddress serverAddress2 = this.addr$2;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$2 = addr$2;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25, true);
        try {
            TestResponse resp3 = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), (byte)2, 1 + this.nodeCount() + 2);
            HotRodTestingUtil$.MODULE$.assertStatus(resp3, OperationStatus.Success);
            Assert.assertEquals((int)resp3.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp2 = resp3.asTopologyAwareResponse();
            Assert.assertEquals((int)topoResp2.members.size(), (int)3);
            ServerAddress serverAddress = crashingServer.getAddress();
            ((List)this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ServerAddress apply(HotRodServer x$6) {
                    return x$6.getAddress();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)serverAddress).foreach((Function1)new Serializable(this, topoResp2){
                public static final long serialVersionUID = 0L;
                private final AbstractTestTopologyAwareResponse topoResp$3;

                public final void apply(ServerAddress addr) {
                    Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(this.topoResp$3.members).exists((Function1)new Serializable(this, addr){
                        public static final long serialVersionUID = 0L;
                        private final ServerAddress addr$3;

                        public final boolean apply(ServerAddress x$8) {
                            ServerAddress serverAddress = x$8;
                            ServerAddress serverAddress2 = this.addr$3;
                            return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                        }
                        {
                            this.addr$3 = addr$3;
                        }
                    }));
                }
                {
                    this.topoResp$3 = topoResp$3;
                }
            });
            HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
        }
        catch (Throwable throwable) {
            void var9_8;
            this.stopClusteredServer((HotRodServer)var9_8);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(crashingServer);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), (byte)2, 1 + this.nodeCount() + 3);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        topoResp.elem = resp.asTopologyAwareResponse();
        Assert.assertEquals((int)((AbstractTestTopologyAwareResponse)topoResp.elem).members.size(), (int)2);
        ((List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(HotRodServer x$9) {
                return x$9.getAddress();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, topoResp){
            public static final long serialVersionUID = 0L;
            private final ObjectRef topoResp$1;

            public final void apply(ServerAddress addr) {
                Assert.assertTrue((boolean)JavaConversions$.MODULE$.collectionAsScalaIterable(((AbstractTestTopologyAwareResponse)this.topoResp$1.elem).members).exists((Function1)new Serializable(this, addr){
                    public static final long serialVersionUID = 0L;
                    private final ServerAddress addr$4;

                    public final boolean apply(ServerAddress x$10) {
                        ServerAddress serverAddress = x$10;
                        ServerAddress serverAddress2 = this.addr$4;
                        return !(serverAddress != null ? !serverAddress.equals(serverAddress2) : serverAddress2 != null);
                    }
                    {
                        this.addr$4 = addr$4;
                    }
                }));
            }
            {
                this.topoResp$1 = topoResp$1;
            }
        });
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        resp = ((HotRodClient)this.clients().head()).put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), (byte)3, 1);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus.Success);
        this.checkTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName());
        HotRodTestingUtil$.MODULE$.assertSuccess(((HotRodClient)((IterableLike)this.clients().tail()).head()).get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }

    public void testSize(Method m) {
        String cacheName = "repl-size";
        this.defineCaches(cacheName);
        List<HotRodClient> clients = this.createClients(cacheName);
        TestSizeResponse sizeStart = ((HotRodClient)clients.head()).size();
        HotRodTestingUtil$.MODULE$.assertStatus(sizeStart, OperationStatus.Success);
        Assert.assertEquals((long)0L, (long)sizeStart.size);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this, m, clients){
            public static final long serialVersionUID = 0L;
            private final Method m$1;
            private final List clients$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((HotRodClient)((IterableLike)this.clients$1.tail()).head()).assertPut(this.m$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.m$1 = m$1;
                this.clients$1 = clients$1;
            }
        });
        TestSizeResponse sizeEnd = ((HotRodClient)((IterableLike)clients.tail()).head()).size();
        HotRodTestingUtil$.MODULE$.assertStatus(sizeEnd, OperationStatus.Success);
        Assert.assertEquals((long)20L, (long)sizeEnd.size);
    }

    @Test(enabled=false)
    public void checkTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName) {
        HotRodTestingUtil$.MODULE$.assertHashTopology20Received(topoResp, servers, cacheName, this.currentServerTopologyId());
    }
}

